/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import org.eclipse.cdt.core.parser.IMacroDescriptor;
import org.eclipse.cdt.core.parser.IToken;

public class ObjectMacroDescriptor
implements IMacroDescriptor {
    private final String expansionSignature;
    private final String name;
    private final IToken token;
    private IToken[] tokenizedExpansion = null;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final IToken[] EMPTY_TOKEN_ARRAY = new IToken[0];

    public ObjectMacroDescriptor(String string, String string2) {
        this.name = string;
        this.expansionSignature = string2;
        this.token = null;
    }

    public ObjectMacroDescriptor(String string, IToken iToken, String string2) {
        this.name = string;
        this.token = iToken;
        this.expansionSignature = string2;
    }

    public IMacroDescriptor.MacroType getMacroType() {
        return IMacroDescriptor.MacroType.OBJECT_LIKE;
    }

    public String[] getParameters() {
        return EMPTY_STRING_ARRAY;
    }

    public IToken[] getTokenizedExpansion() {
        if (this.token == null) {
            return EMPTY_TOKEN_ARRAY;
        }
        if (this.tokenizedExpansion == null) {
            this.tokenizedExpansion = new IToken[1];
            this.tokenizedExpansion[0] = this.token;
        }
        return this.tokenizedExpansion;
    }

    public String getName() {
        return this.name;
    }

    public String getCompleteSignature() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define ");
        stringBuffer.append(this.name);
        stringBuffer.append(' ');
        stringBuffer.append(this.expansionSignature);
        return stringBuffer.toString();
    }

    public boolean compatible(IMacroDescriptor iMacroDescriptor) {
        if (iMacroDescriptor.getName() == null) {
            return false;
        }
        if (iMacroDescriptor.getMacroType() != this.getMacroType()) {
            return false;
        }
        if (!this.name.equals(iMacroDescriptor.getName())) {
            return false;
        }
        String string = iMacroDescriptor.getExpansionSignature();
        if (string == null) {
            return this.expansionSignature == null;
        }
        return string.equals(this.expansionSignature);
    }

    public String getExpansionSignature() {
        return this.expansionSignature;
    }

    public boolean isCircular() {
        int n = 0;
        while (n < this.getTokenizedExpansion().length) {
            IToken iToken = this.tokenizedExpansion[n];
            if (iToken.getType() == 1 && iToken.getImage().equals(this.getName())) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

