/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.internal.core.parser.scanner.IScannerContext;

public class ScannerContextInclusion
implements IScannerContext {
    public static final int UNDO_BUFFER_SIZE = 4;
    public CodeReader code;
    private IASTInclusion inc;
    private final int index;
    private int line;
    protected int offset = 0;

    public ScannerContextInclusion(CodeReader codeReader, IASTInclusion iASTInclusion, int n) {
        this.code = codeReader;
        this.line = 1;
        this.inc = iASTInclusion;
        this.index = n;
    }

    public boolean isFinal() {
        return false;
    }

    public final String getContextName() {
        return new String(this.code.filename);
    }

    public int getOffset() {
        return this.offset;
    }

    public void close() {
    }

    public int getChar() {
        char c;
        if (this.offset == this.code.buffer.length) {
            return -1;
        }
        if ((char)(c = this.code.buffer[this.offset++]) == '\n') {
            ++this.line;
        }
        return c;
    }

    public void ungetChar(int n) {
        --this.offset;
        if (n == 10) {
            --this.line;
        }
    }

    public int getKind() {
        return IScannerContext.ContextKind.INCLUSION;
    }

    public IASTInclusion getExtension() {
        return this.inc;
    }

    public int getFilenameIndex() {
        return this.index;
    }

    public final int getLine() {
        return this.line;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("file ");
        stringBuffer.append(this.getContextName());
        stringBuffer.append(":");
        stringBuffer.append(this.getLine());
        return stringBuffer.toString();
    }
}

