/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner2;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.cdt.internal.core.parser.scanner2.CharTable;

public class CharArrayObjectMap
extends CharTable {
    public static final CharArrayObjectMap EMPTY_MAP = new CharArrayObjectMap(0){

        public Object clone() {
            return this;
        }

        public List toList() {
            return Collections.EMPTY_LIST;
        }

        public Object put(char[] cArray, int n, int n2, Object object) {
            throw new UnsupportedOperationException();
        }
    };
    private Object[] valueTable = new Object[this.capacity()];

    public CharArrayObjectMap(int n) {
        super(n);
    }

    public Object put(char[] cArray, int n, int n2, Object object) {
        int n3 = this.addIndex(cArray, n, n2);
        Object object2 = this.valueTable[n3];
        this.valueTable[n3] = object;
        return object2;
    }

    public final Object put(char[] cArray, Object object) {
        return this.put(cArray, 0, cArray.length, object);
    }

    public final Object get(char[] cArray, int n, int n2) {
        int n3 = this.lookup(cArray, n, n2);
        if (n3 >= 0) {
            return this.valueTable[n3];
        }
        return null;
    }

    public final Object get(char[] cArray) {
        return this.get(cArray, 0, cArray.length);
    }

    public final Object getAt(int n) {
        if (n < 0 || n > this.currEntry) {
            return null;
        }
        return this.valueTable[n];
    }

    public final Object remove(char[] cArray, int n, int n2) {
        int n3 = this.lookup(cArray, n, n2);
        if (n3 < 0) {
            return null;
        }
        Object object = this.valueTable[n3];
        if (n3 < this.currEntry) {
            System.arraycopy(this.valueTable, n3 + 1, this.valueTable, n3, this.currEntry - n3);
        }
        this.valueTable[this.currEntry] = null;
        this.removeEntry(n3);
        return object;
    }

    public Object clone() {
        int n = this.capacity();
        CharArrayObjectMap charArrayObjectMap = new CharArrayObjectMap(n);
        System.arraycopy(this.valueTable, 0, charArrayObjectMap.valueTable, 0, this.valueTable.length);
        System.arraycopy(this.keyTable, 0, charArrayObjectMap.keyTable, 0, this.keyTable.length);
        if (this.hashTable != null) {
            System.arraycopy(this.hashTable, 0, charArrayObjectMap.hashTable, 0, this.hashTable.length);
        }
        if (this.nextTable != null) {
            System.arraycopy(this.nextTable, 0, charArrayObjectMap.nextTable, 0, this.nextTable.length);
        }
        charArrayObjectMap.currEntry = this.currEntry;
        return charArrayObjectMap;
    }

    protected void resize(int n) {
        Object[] objectArray = this.valueTable;
        this.valueTable = new Object[n];
        System.arraycopy(objectArray, 0, this.valueTable, 0, objectArray.length);
        super.resize(n);
    }

    public void clear() {
        super.clear();
        int n = 0;
        while (n < this.capacity()) {
            this.valueTable[n] = null;
            ++n;
        }
    }

    protected int partition(Comparator comparator, int n, int n2) {
        char[] cArray = this.keyTable[n];
        Object object = null;
        int n3 = n;
        int n4 = n2;
        while (true) {
            if (comparator.compare(this.keyTable[n4], cArray) > 0) {
                --n4;
                continue;
            }
            if (n3 < n4) {
                while (comparator.compare(this.keyTable[n3], cArray) < 0) {
                    ++n3;
                }
            }
            if (n3 >= n4) break;
            object = this.keyTable[n4];
            this.keyTable[n4] = this.keyTable[n3];
            this.keyTable[n3] = object;
            object = this.valueTable[n4];
            this.valueTable[n4] = this.valueTable[n3];
            this.valueTable[n3] = object;
        }
        return n4;
    }
}

