/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner2;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.core.parser.scanner2.CharArrayUtils;
import org.eclipse.cdt.internal.core.parser.scanner2.HashTable;

public class CharTable
extends HashTable {
    protected char[][] keyTable = new char[this.capacity()][];

    protected CharTable(int n) {
        super(n);
    }

    protected void resize(int n) {
        char[][] cArray = this.keyTable;
        this.keyTable = new char[n][];
        System.arraycopy(cArray, 0, this.keyTable, 0, cArray.length);
        super.resize(n);
    }

    public void clear() {
        super.clear();
        int n = 0;
        while (n < this.capacity()) {
            this.keyTable[n] = null;
            ++n;
        }
    }

    protected final int hash(char[] cArray, int n, int n2) {
        return CharArrayUtils.hash(cArray, n, n2) & this.keyTable.length * 2 - 1;
    }

    protected final int hash(int n) {
        return this.hash(this.keyTable[n], 0, this.keyTable[n].length);
    }

    protected final int hash(char[] cArray) {
        return this.hash(cArray, 0, cArray.length);
    }

    protected final int addIndex(char[] cArray) {
        return this.addIndex(cArray, 0, cArray.length);
    }

    protected final int addIndex(char[] cArray, int n, int n2) {
        if (this.hashTable != null) {
            int n3 = this.hash(cArray, n, n2);
            int n4 = this.lookup(cArray, n, n2, n3);
            if (n4 != -1) {
                return n4;
            }
            if (this.currEntry + 1 >= this.capacity()) {
                this.resize();
                n3 = this.hash(cArray, n, n2);
            }
            ++this.currEntry;
            this.keyTable[this.currEntry] = CharArrayUtils.extract(cArray, n, n2);
            this.linkIntoHashTable(this.currEntry, n3);
        } else {
            int n5 = this.lookup(cArray, n, n2);
            if (n5 != -1) {
                return n5;
            }
            if (this.currEntry + 1 >= this.capacity()) {
                this.resize();
                if (this.capacity() > 2) {
                    return this.addIndex(cArray, n, n2);
                }
            }
            ++this.currEntry;
            this.keyTable[this.currEntry] = CharArrayUtils.extract(cArray, n, n2);
        }
        return this.currEntry;
    }

    protected void removeEntry(int n) {
        int n2 = this.hash(this.keyTable[n]);
        if (n < this.currEntry) {
            System.arraycopy(this.keyTable, n + 1, this.keyTable, n, this.currEntry - n);
        }
        this.keyTable[this.currEntry] = null;
        this.removeEntry(n, n2);
    }

    public List toList() {
        ArrayList<char[]> arrayList = new ArrayList<char[]>(this.size());
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(this.keyAt(n2));
            ++n2;
        }
        return arrayList;
    }

    public final char[] keyAt(int n) {
        if (n < 0 || n > this.currEntry) {
            return null;
        }
        return this.keyTable[n];
    }

    public final boolean containsKey(char[] cArray) {
        return this.lookup(cArray) != -1;
    }

    public final char[] findKey(char[] cArray, int n, int n2) {
        int n3 = this.lookup(cArray, n, n2);
        if (n3 == -1) {
            return null;
        }
        return this.keyTable[n3];
    }

    protected int lookup(char[] cArray) {
        return this.lookup(cArray, 0, cArray.length);
    }

    protected final int lookup(char[] cArray, int n, int n2) {
        if (this.hashTable != null) {
            return this.lookup(cArray, n, n2, this.hash(cArray, n, n2));
        }
        int n3 = 0;
        while (n3 <= this.currEntry) {
            if (CharArrayUtils.equals(cArray, n, n2, this.keyTable[n3])) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    protected final int lookup(char[] cArray, int n, int n2, int n3) {
        if (this.hashTable[n3] == 0) {
            return -1;
        }
        int n4 = this.hashTable[n3] - 1;
        if (CharArrayUtils.equals(cArray, n, n2, this.keyTable[n4])) {
            return n4;
        }
        n4 = this.nextTable[n4] - 1;
        while (n4 >= 0) {
            if (CharArrayUtils.equals(cArray, n, n2, this.keyTable[n4])) {
                return n4;
            }
            n4 = this.nextTable[n4] - 1;
        }
        return -1;
    }
}

