/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner2;

import org.eclipse.cdt.internal.core.parser.scanner2.CharArrayObjectMap;
import org.eclipse.cdt.internal.core.parser.scanner2.CharArrayUtils;
import org.eclipse.cdt.internal.core.parser.scanner2.FunctionStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectStyleMacro;

public class ExpressionEvaluator {
    private static char[] emptyCharArray = new char[0];
    private static final int bufferInitialSize = 8;
    private int bufferStackPos = -1;
    private char[][] bufferStack = new char[8][];
    private Object[] bufferData = new Object[8];
    private int[] bufferPos = new int[8];
    private int[] bufferLimit = new int[8];
    CharArrayObjectMap definitions;
    int tokenType = 0;
    long tokenValue;
    private static char[] _defined = "defined".toCharArray();
    private static final int tNULL = 0;
    private static final int tEOF = 1;
    private static final int tNUMBER = 2;
    private static final int tLPAREN = 3;
    private static final int tRPAREN = 4;
    private static final int tNOT = 5;
    private static final int tCOMPL = 6;
    private static final int tMULT = 7;
    private static final int tDIV = 8;
    private static final int tMOD = 9;
    private static final int tPLUS = 10;
    private static final int tMINUS = 11;
    private static final int tSHIFTL = 12;
    private static final int tSHIFTR = 13;
    private static final int tLT = 14;
    private static final int tGT = 15;
    private static final int tLTEQUAL = 16;
    private static final int tGTEQUAL = 17;
    private static final int tEQUAL = 18;
    private static final int tNOTEQUAL = 19;
    private static final int tBITAND = 20;
    private static final int tBITXOR = 21;
    private static final int tBITOR = 22;
    private static final int tAND = 23;
    private static final int tOR = 24;
    private static final int tQUESTION = 25;
    private static final int tCOLON = 26;
    private static final int t_defined = 27;

    public long evaluate(char[] cArray, int n, int n2, CharArrayObjectMap charArrayObjectMap) {
        this.bufferStack[++this.bufferStackPos] = cArray;
        this.bufferPos[this.bufferStackPos] = n;
        this.bufferLimit[this.bufferStackPos] = n + n2;
        this.definitions = charArrayObjectMap;
        this.tokenType = 0;
        long l = 0L;
        try {
            l = this.expression();
        }
        catch (EvalException evalException) {}
        while (this.bufferStackPos >= 0) {
            this.popContext();
        }
        return l;
    }

    private long expression() throws EvalException {
        return this.conditionalExpression();
    }

    private long conditionalExpression() throws EvalException {
        long l = this.logicalOrExpression();
        if (this.LA() == 25) {
            this.consume();
            long l2 = this.expression();
            if (this.LA() != 26) {
                throw new EvalException("bad conditional expression");
            }
            this.consume();
            long l3 = this.conditionalExpression();
            return l != 0L ? l2 : l3;
        }
        return l;
    }

    private long logicalOrExpression() throws EvalException {
        long l = this.logicalAndExpression();
        while (this.LA() == 24) {
            this.consume();
            long l2 = this.logicalAndExpression();
            l = l != 0L || l2 != 0L ? 1 : 0;
        }
        return l;
    }

    private long logicalAndExpression() throws EvalException {
        long l = this.inclusiveOrExpression();
        while (this.LA() == 23) {
            this.consume();
            long l2 = this.inclusiveOrExpression();
            l = l != 0L && l2 != 0L ? 1 : 0;
        }
        return l;
    }

    private long inclusiveOrExpression() throws EvalException {
        long l = this.exclusiveOrExpression();
        while (this.LA() == 22) {
            this.consume();
            long l2 = this.exclusiveOrExpression();
            l |= l2;
        }
        return l;
    }

    private long exclusiveOrExpression() throws EvalException {
        long l = this.andExpression();
        while (this.LA() == 21) {
            this.consume();
            long l2 = this.andExpression();
            l ^= l2;
        }
        return l;
    }

    private long andExpression() throws EvalException {
        long l = this.equalityExpression();
        while (this.LA() == 20) {
            this.consume();
            long l2 = this.equalityExpression();
            l &= l2;
        }
        return l;
    }

    private long equalityExpression() throws EvalException {
        long l = this.relationalExpression();
        int n = this.LA();
        while (n == 18 || n == 19) {
            this.consume();
            long l2 = this.relationalExpression();
            l = n == 18 ? (long)(l == l2 ? 1 : 0) : (long)(l != l2 ? 1 : 0);
            n = this.LA();
        }
        return l;
    }

    private long relationalExpression() throws EvalException {
        long l = this.shiftExpression();
        int n = this.LA();
        while (n == 14 || n == 16 || n == 15 || n == 17) {
            this.consume();
            long l2 = this.shiftExpression();
            switch (n) {
                case 14: {
                    l = l < l2 ? 1 : 0;
                    break;
                }
                case 16: {
                    l = l <= l2 ? 1 : 0;
                    break;
                }
                case 15: {
                    l = l > l2 ? 1 : 0;
                    break;
                }
                case 17: {
                    l = l >= l2 ? 1 : 0;
                }
            }
            n = this.LA();
        }
        return l;
    }

    private long shiftExpression() throws EvalException {
        long l = this.additiveExpression();
        int n = this.LA();
        while (n == 12 || n == 13) {
            this.consume();
            long l2 = this.additiveExpression();
            l = n == 12 ? (l <<= (int)l2) : (l >>= (int)l2);
            n = this.LA();
        }
        return l;
    }

    private long additiveExpression() throws EvalException {
        long l = this.multiplicativeExpression();
        int n = this.LA();
        while (n == 10 || n == 11) {
            this.consume();
            long l2 = this.multiplicativeExpression();
            l = n == 10 ? (l += l2) : (l -= l2);
            n = this.LA();
        }
        return l;
    }

    private long multiplicativeExpression() throws EvalException {
        long l = this.unaryExpression();
        int n = this.LA();
        while (n == 7 || n == 8) {
            this.consume();
            long l2 = this.unaryExpression();
            if (n == 7) {
                l *= l2;
            } else if (l2 != 0L) {
                l /= l2;
            } else {
                throw new EvalException("Divide by 0 encountered");
            }
            n = this.LA();
        }
        return l;
    }

    private long unaryExpression() throws EvalException {
        switch (this.LA()) {
            case 10: {
                this.consume();
                return this.unaryExpression();
            }
            case 11: {
                this.consume();
                return -this.unaryExpression();
            }
            case 5: {
                this.consume();
                return this.unaryExpression() == 0L ? 1 : 0;
            }
            case 6: {
                this.consume();
                return this.unaryExpression() ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case 2: {
                return this.consume();
            }
            case 27: {
                return this.handleDefined();
            }
            case 3: {
                this.consume();
                long l = this.expression();
                if (this.LA() == 4) {
                    this.consume();
                    return l;
                }
                throw new EvalException("missing )");
            }
        }
        throw new EvalException("expression syntax error");
    }

    /*
     * Unable to fully structure code
     */
    private long handleDefined() throws EvalException {
        this.skipWhiteSpace();
        var1_1 = this.bufferStack[this.bufferStackPos];
        var2_2 = this.bufferLimit[this.bufferStackPos];
        v0 = this.bufferStackPos;
        this.bufferPos[v0] = this.bufferPos[v0] + 1;
        if (this.bufferPos[v0] >= var2_2) {
            return 0L;
        }
        var3_3 = var1_1[this.bufferPos[this.bufferStackPos]];
        var4_4 = false;
        if (var3_3 == '(') {
            var4_4 = true;
            this.skipWhiteSpace();
            v1 = this.bufferStackPos;
            this.bufferPos[v1] = this.bufferPos[v1] + 1;
            if (this.bufferPos[v1] >= var2_2) {
                return 0L;
            }
            var3_3 = var1_1[this.bufferPos[this.bufferStackPos]];
        }
        if (!(var3_3 >= 'A' && var3_3 <= 'Z' || var3_3 == '_' || var3_3 >= 'a' && var3_3 <= 'z')) {
            throw new EvalException("illegal identifier in defined()");
        }
        var5_5 = this.bufferPos[this.bufferStackPos];
        var6_6 = 1;
        ** GOTO lbl25
        while ((var3_3 = var1_1[this.bufferPos[this.bufferStackPos]]) >= 'A' && var3_3 <= 'Z' || var3_3 == '_' || var3_3 >= 'a' && var3_3 <= 'z' || var3_3 >= '0' && var3_3 <= '9') {
            ++var6_6;
lbl25:
            // 2 sources

            v2 = this.bufferStackPos;
            this.bufferPos[v2] = this.bufferPos[v2] + 1;
            if (this.bufferPos[v2] < var2_2) continue;
        }
        v3 = this.bufferStackPos;
        this.bufferPos[v3] = this.bufferPos[v3] - 1;
        if (var4_4) {
            this.skipWhiteSpace();
            v4 = this.bufferStackPos;
            this.bufferPos[v4] = this.bufferPos[v4] + 1;
            if (this.bufferPos[v4] < var2_2 && var1_1[this.bufferPos[this.bufferStackPos]] != ')') {
                throw new EvalException("missing ) on defined");
            }
        }
        this.nextToken();
        return this.definitions.get(var1_1, var5_5, var6_6) != null ? 1 : 0;
    }

    private int LA() throws EvalException {
        if (this.tokenType == 0) {
            this.nextToken();
        }
        return this.tokenType;
    }

    private long consume() throws EvalException {
        long l = this.tokenValue;
        if (this.tokenType != 1) {
            this.nextToken();
        }
        return l;
    }

    /*
     * Unable to fully structure code
     */
    private void nextToken() throws EvalException {
        block24: while (this.bufferStackPos >= 0) {
            this.skipWhiteSpace();
            v0 = this.bufferStackPos;
            this.bufferPos[v0] = this.bufferPos[v0] + 1;
            if (this.bufferPos[v0] >= this.bufferLimit[this.bufferStackPos]) {
                this.popContext();
                continue;
            }
            var1_1 = this.bufferStack[this.bufferStackPos];
            var2_2 = this.bufferLimit[this.bufferStackPos];
            var3_3 = this.bufferPos[this.bufferStackPos];
            switch (var1_1[var3_3]) {
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    var4_4 = this.bufferPos[this.bufferStackPos];
                    var5_5 = 1;
                    ** GOTO lbl18
                    while ((var6_7 = var1_1[this.bufferPos[this.bufferStackPos]]) >= 'a' && var6_7 <= 'z' || var6_7 >= 'A' && var6_7 <= 'Z' || var6_7 == '_' || var6_7 >= '0' && var6_7 <= '9') {
                        ++var5_5;
lbl18:
                        // 2 sources

                        v1 = this.bufferStackPos;
                        this.bufferPos[v1] = this.bufferPos[v1] + 1;
                        if (this.bufferPos[v1] < var2_2) continue;
                    }
                    v2 = this.bufferStackPos;
                    this.bufferPos[v2] = this.bufferPos[v2] - 1;
                    var3_3 = this.bufferPos[this.bufferStackPos];
                    if (CharArrayUtils.equals(var1_1, var4_4, var5_5, ExpressionEvaluator._defined)) {
                        this.tokenType = 27;
                        return;
                    }
                    var6_6 = null;
                    if (this.bufferData[this.bufferStackPos] instanceof FunctionStyleMacro.Expansion) {
                        var6_6 = ((FunctionStyleMacro.Expansion)this.bufferData[this.bufferStackPos]).definitions.get(var1_1, var4_4, var5_5);
                    }
                    if (var6_6 == null) {
                        var6_6 = this.definitions.get(var1_1, var4_4, var5_5);
                    }
                    if (var6_6 != null) {
                        if (var6_6 instanceof FunctionStyleMacro) {
                            this.handleFunctionStyleMacro((FunctionStyleMacro)var6_6);
                            break;
                        }
                        if (var6_6 instanceof ObjectStyleMacro) {
                            var7_8 = (ObjectStyleMacro)var6_6;
                            var8_10 = var7_8.expansion;
                            if (var8_10.length <= 0) break;
                            this.pushContext(var8_10, var7_8);
                            break;
                        }
                        if (!(var6_6 instanceof char[]) || ((Object)(var7_8 = (Object)((char[])var6_6))).length <= 0) continue block24;
                        this.pushContext((char[])var7_8, null);
                        break;
                    }
                    this.tokenValue = 0L;
                    this.tokenType = 2;
                    return;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.tokenValue = var1_1[var3_3] - 48;
                    this.tokenType = 2;
                    var7_9 = false;
                    if (var1_1[var3_3] != '0' || var3_3 + 1 >= var2_2) ** GOTO lbl77
                    switch (var1_1[var3_3 + 1]) {
                        case 'X': 
                        case 'x': {
                            var7_9 = true;
                            v3 = this.bufferStackPos;
                            this.bufferPos[v3] = this.bufferPos[v3] + 1;
                        }
                    }
                    if (true) ** GOTO lbl77
                    do {
                        if ((var8_11 = var1_1[this.bufferPos[this.bufferStackPos]]) < '0' || var8_11 > '9') ** GOTO lbl64
                        this.tokenValue *= (long)(var7_9 != false ? 16 : 10);
                        this.tokenValue += (long)(var8_11 - 48);
                        ** GOTO lbl77
lbl64:
                        // 1 sources

                        if (!var7_9) ** GOTO lbl-1000
                        if (var8_11 >= 'a' && var8_11 <= 'f') {
                            this.tokenValue *= 16L;
                            this.tokenValue += (long)(var8_11 - 97);
                        } else if (var8_11 >= 'A' && var8_11 <= 'F') {
                            this.tokenValue *= 16L;
                            this.tokenValue += (long)(var8_11 - 65);
                        } else lbl-1000:
                        // 2 sources

                        {
                            if (var8_11 != 'L') break;
                            v4 = this.bufferStackPos;
                            this.bufferPos[v4] = this.bufferPos[v4] + 1;
                            break;
                        }
lbl77:
                        // 5 sources

                        v5 = this.bufferStackPos;
                    } while ((this.bufferPos[v5] = this.bufferPos[v5] + 1) < var2_2);
                    v6 = this.bufferStackPos;
                    this.bufferPos[v6] = this.bufferPos[v6] - 1;
                    return;
                }
                case '(': {
                    this.tokenType = 3;
                    return;
                }
                case ')': {
                    this.tokenType = 4;
                    return;
                }
                case ':': {
                    this.tokenType = 26;
                    return;
                }
                case '?': {
                    this.tokenType = 25;
                    return;
                }
                case '+': {
                    this.tokenType = 10;
                    return;
                }
                case '-': {
                    this.tokenType = 11;
                    return;
                }
                case '*': {
                    this.tokenType = 7;
                    return;
                }
                case '/': {
                    this.tokenType = 8;
                    return;
                }
                case '%': {
                    this.tokenType = 9;
                    return;
                }
                case '^': {
                    this.tokenType = 21;
                    return;
                }
                case '&': {
                    if (var3_3 + 1 < var2_2 && var1_1[var3_3 + 1] == '&') {
                        v7 = this.bufferStackPos;
                        this.bufferPos[v7] = this.bufferPos[v7] + 1;
                        this.tokenType = 23;
                        return;
                    }
                    this.tokenType = 20;
                    return;
                }
                case '|': {
                    if (var3_3 + 1 < var2_2 && var1_1[var3_3 + 1] == '|') {
                        v8 = this.bufferStackPos;
                        this.bufferPos[v8] = this.bufferPos[v8] + 1;
                        this.tokenType = 24;
                        return;
                    }
                    this.tokenType = 22;
                    return;
                }
                case '~': {
                    this.tokenType = 6;
                    return;
                }
                case '!': {
                    if (var3_3 + 1 < var2_2 && var1_1[var3_3 + 1] == '=') {
                        v9 = this.bufferStackPos;
                        this.bufferPos[v9] = this.bufferPos[v9] + 1;
                        this.tokenType = 19;
                        return;
                    }
                    this.tokenType = 5;
                    return;
                }
                case '=': {
                    if (var3_3 + 1 < var2_2 && var1_1[var3_3 + 1] == '=') {
                        v10 = this.bufferStackPos;
                        this.bufferPos[v10] = this.bufferPos[v10] + 1;
                        this.tokenType = 18;
                        return;
                    }
                    throw new EvalException("assignment not allowed");
                }
                case '<': {
                    if (var3_3 + 1 < var2_2) {
                        if (var1_1[var3_3 + 1] == '=') {
                            v11 = this.bufferStackPos;
                            this.bufferPos[v11] = this.bufferPos[v11] + 1;
                            this.tokenType = 16;
                            return;
                        }
                        if (var1_1[var3_3 + 1] == '<') {
                            v12 = this.bufferStackPos;
                            this.bufferPos[v12] = this.bufferPos[v12] + 1;
                            this.tokenType = 12;
                            return;
                        }
                    }
                    this.tokenType = 14;
                    return;
                }
                case '>': {
                    if (var3_3 + 1 < var2_2) {
                        if (var1_1[var3_3 + 1] == '=') {
                            v13 = this.bufferStackPos;
                            this.bufferPos[v13] = this.bufferPos[v13] + 1;
                            this.tokenType = 17;
                            return;
                        }
                        if (var1_1[var3_3 + 1] == '>') {
                            v14 = this.bufferStackPos;
                            this.bufferPos[v14] = this.bufferPos[v14] + 1;
                            this.tokenType = 13;
                            return;
                        }
                    }
                    this.tokenType = 15;
                    return;
                }
            }
        }
        this.tokenType = 1;
    }

    private void handleFunctionStyleMacro(FunctionStyleMacro functionStyleMacro) {
        char[] cArray;
        char[] cArray2 = this.bufferStack[this.bufferStackPos];
        int n = this.bufferLimit[this.bufferStackPos];
        int n2 = this.bufferStackPos;
        this.bufferPos[n2] = this.bufferPos[n2] + 1;
        if (this.bufferPos[n2] >= n || cArray2[this.bufferPos[this.bufferStackPos]] != '(') {
            return;
        }
        FunctionStyleMacro.Expansion expansion = new FunctionStyleMacro.Expansion(functionStyleMacro);
        char[][] cArray3 = functionStyleMacro.arglist;
        int n3 = -1;
        int n4 = 0;
        while (this.bufferPos[this.bufferStackPos] < n) {
            if (++n3 >= cArray3.length || cArray3[n3] == null) break;
            this.skipWhiteSpace();
            int n5 = this.bufferStackPos;
            int n6 = this.bufferPos[n5] + 1;
            this.bufferPos[n5] = n6;
            int n7 = n6;
            char c = cArray2[n7];
            if (c == ')') {
                if (n4 == 0) break;
                --n4;
                continue;
            }
            if (c == ',') {
                expansion.definitions.put(cArray3[n3], emptyCharArray);
                continue;
            }
            if (c == '(') {
                ++n4;
                continue;
            }
            int n8 = n7;
            int n9 = n8 - 1;
            while (this.bufferPos[this.bufferStackPos] < n) {
                this.skipOverMacroArg();
                n9 = this.bufferPos[this.bufferStackPos];
                this.skipWhiteSpace();
                int n10 = this.bufferStackPos;
                this.bufferPos[n10] = this.bufferPos[n10] + 1;
                if (this.bufferPos[n10] >= n || (c = cArray2[this.bufferPos[this.bufferStackPos]]) == ',' || c == ')') break;
            }
            char[] cArray4 = emptyCharArray;
            int n11 = n9 - n8 + 1;
            if (n11 > 0) {
                cArray4 = new char[n11];
                System.arraycopy(cArray2, n8, cArray4, 0, n11);
            }
            expansion.definitions.put(cArray3[n3], cArray4);
            if (c == ')') break;
        }
        if ((cArray = functionStyleMacro.expansion).length > 0) {
            this.pushContext(cArray, expansion);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private void skipOverMacroArg() {
        block13: {
            int n;
            int n2;
            char[] cArray;
            block12: {
                cArray = this.bufferStack[this.bufferStackPos];
                n2 = this.bufferLimit[this.bufferStackPos];
                if (!true) break block12;
                n = this.bufferStackPos;
                if ((this.bufferPos[n] = this.bufferPos[n] + 1) >= n2) break block13;
            }
            do {
                block0 : switch (cArray[this.bufferPos[this.bufferStackPos]]) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case ')': 
                    case ',': {
                        int n3 = this.bufferStackPos;
                        this.bufferPos[n3] = this.bufferPos[n3] - 1;
                        return;
                    }
                    case '\\': {
                        int n4 = this.bufferPos[this.bufferStackPos];
                        if (n4 + 1 >= n2 || cArray[n4 + 1] != '\n') break;
                        int n5 = this.bufferStackPos;
                        this.bufferPos[n5] = this.bufferPos[n5] - 1;
                        return;
                    }
                    case '\"': {
                        boolean bl = false;
                        while (true) {
                            int n6 = this.bufferStackPos;
                            this.bufferPos[n6] = this.bufferPos[n6] + 1;
                            if (this.bufferPos[n6] >= this.bufferLimit[this.bufferStackPos]) break block0;
                            switch (cArray[this.bufferPos[this.bufferStackPos]]) {
                                case '\\': {
                                    bl = !bl;
                                    break;
                                }
                                case '\"': {
                                    if (!bl) break block0;
                                    bl = false;
                                    break;
                                }
                                default: {
                                    bl = false;
                                    break;
                                }
                            }
                        }
                    }
                }
                n = this.bufferStackPos;
            } while ((this.bufferPos[n] = this.bufferPos[n] + 1) < n2);
        }
        int n = this.bufferStackPos;
        this.bufferPos[n] = this.bufferPos[n] - 1;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private void skipWhiteSpace() {
        block11: {
            int n;
            int n2;
            char[] cArray;
            block10: {
                cArray = this.bufferStack[this.bufferStackPos];
                n2 = this.bufferLimit[this.bufferStackPos];
                if (!true) break block10;
                n = this.bufferStackPos;
                if ((this.bufferPos[n] = this.bufferPos[n] + 1) >= n2) break block11;
            }
            do {
                block9: {
                    int n3 = this.bufferPos[this.bufferStackPos];
                    switch (cArray[n3]) {
                        case '\t': 
                        case '\r': 
                        case ' ': {
                            break block9;
                        }
                        case '/': {
                            if (n3 + 1 >= n2) break;
                            if (cArray[n3 + 1] == '/') {
                                return;
                            }
                            if (cArray[n3 + 1] != '*') break;
                            int n4 = this.bufferStackPos;
                            this.bufferPos[n4] = this.bufferPos[n4] + 2;
                            while (this.bufferPos[this.bufferStackPos] < n2) {
                                n3 = this.bufferPos[this.bufferStackPos];
                                if (cArray[n3] == '*' && n3 + 1 < n2 && cArray[n3 + 1] == '/') {
                                    int n5 = this.bufferStackPos;
                                    this.bufferPos[n5] = this.bufferPos[n5] + 1;
                                    break block9;
                                }
                                int n6 = this.bufferStackPos;
                                this.bufferPos[n6] = this.bufferPos[n6] + 1;
                            }
                            break block9;
                        }
                        case '\\': {
                            if (n3 + 1 >= n2 || cArray[n3 + 1] != '\n') break;
                            int n7 = this.bufferStackPos;
                            this.bufferPos[n7] = this.bufferPos[n7] + 1;
                            break block9;
                        }
                    }
                    int n8 = this.bufferStackPos;
                    this.bufferPos[n8] = this.bufferPos[n8] - 1;
                    return;
                }
                n = this.bufferStackPos;
            } while ((this.bufferPos[n] = this.bufferPos[n] + 1) < n2);
        }
    }

    private void pushContext(char[] cArray, Object object) {
        if (++this.bufferStackPos == this.bufferStack.length) {
            int n = this.bufferStack.length * 2;
            char[][] cArray2 = this.bufferStack;
            this.bufferStack = new char[n][];
            System.arraycopy(cArray2, 0, this.bufferStack, 0, cArray2.length);
            Object[] objectArray = this.bufferData;
            this.bufferData = new Object[n];
            System.arraycopy(objectArray, 0, this.bufferData, 0, objectArray.length);
            int[] nArray = this.bufferPos;
            this.bufferPos = new int[n];
            System.arraycopy(nArray, 0, this.bufferPos, 0, nArray.length);
            int[] nArray2 = this.bufferLimit;
            this.bufferLimit = new int[n];
            System.arraycopy(nArray2, 0, this.bufferLimit, 0, nArray2.length);
        }
        this.bufferStack[this.bufferStackPos] = cArray;
        this.bufferPos[this.bufferStackPos] = -1;
        this.bufferLimit[this.bufferStackPos] = cArray.length;
        this.bufferData[this.bufferStackPos] = object;
    }

    private void popContext() {
        this.bufferStack[this.bufferStackPos] = null;
        this.bufferData[this.bufferStackPos] = null;
        --this.bufferStackPos;
    }

    private static class EvalException
    extends Exception {
        public EvalException(String string) {
            super(string);
        }
    }
}

