/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner2;

import java.util.Comparator;

public class HashTable {
    protected static final int minHashSize = 2;
    protected int currEntry = -1;
    protected int[] hashTable;
    protected int[] nextTable;

    public boolean isEmpty() {
        return this.currEntry == -1;
    }

    public final int size() {
        return this.currEntry + 1;
    }

    public HashTable(int n) {
        int n2 = 1;
        while (n2 < n) {
            n2 <<= 1;
        }
        if (n2 > 2) {
            this.hashTable = new int[n2 * 2];
            this.nextTable = new int[n2];
        } else {
            this.hashTable = null;
            this.nextTable = null;
        }
    }

    protected void resize() {
        this.resize(this.capacity() << 1);
    }

    public void clear() {
        this.currEntry = -1;
        if (this.hashTable == null) {
            return;
        }
        int n = 0;
        while (n < this.capacity()) {
            this.hashTable[2 * n] = 0;
            this.hashTable[2 * n + 1] = 0;
            this.nextTable[n] = 0;
            ++n;
        }
    }

    protected void rehash() {
        if (this.nextTable == null) {
            return;
        }
        int n = 0;
        while (n < this.capacity()) {
            this.hashTable[2 * n] = 0;
            this.hashTable[2 * n + 1] = 0;
            this.nextTable[n] = 0;
            ++n;
        }
        n = 0;
        while (n <= this.currEntry) {
            this.linkIntoHashTable(n, this.hash(n));
            ++n;
        }
    }

    protected void resize(int n) {
        if (n > 2) {
            this.hashTable = new int[n * 2];
            this.nextTable = new int[n];
            int n2 = 0;
            while (n2 <= this.currEntry) {
                this.linkIntoHashTable(n2, this.hash(n2));
                ++n2;
            }
        }
    }

    protected int hash(int n) {
        throw new UnsupportedOperationException();
    }

    protected void linkIntoHashTable(int n, int n2) {
        if (this.nextTable == null) {
            return;
        }
        if (this.hashTable[n2] == 0) {
            this.hashTable[n2] = n + 1;
        } else {
            int n3 = this.hashTable[n2] - 1;
            while (this.nextTable[n3] != 0) {
                n3 = this.nextTable[n3] - 1;
            }
            this.nextTable[n3] = n + 1;
        }
    }

    public final int capacity() {
        if (this.nextTable == null) {
            return 2;
        }
        return this.nextTable.length;
    }

    protected void removeEntry(int n, int n2) {
        int n3;
        if (this.nextTable == null) {
            --this.currEntry;
            return;
        }
        if (this.hashTable[n2] == n + 1) {
            this.hashTable[n2] = this.nextTable[n];
        } else {
            n3 = this.hashTable[n2] - 1;
            while (this.nextTable[n3] != 0 && this.nextTable[n3] != n + 1) {
                n3 = this.nextTable[n3] - 1;
            }
            this.nextTable[n3] = this.nextTable[n];
        }
        if (n < this.currEntry) {
            System.arraycopy(this.nextTable, n + 1, this.nextTable, n, this.currEntry - n);
            n3 = 0;
            while (n3 < this.hashTable.length) {
                if (this.hashTable[n3] > n + 1) {
                    int n4 = n3;
                    this.hashTable[n4] = this.hashTable[n4] - 1;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < this.nextTable.length) {
                if (this.nextTable[n3] > n + 1) {
                    int n5 = n3;
                    this.nextTable[n5] = this.nextTable[n5] - 1;
                }
                ++n3;
            }
        }
        this.nextTable[this.currEntry] = 0;
        --this.currEntry;
    }

    public final void sort(Comparator comparator) {
        if (this.size() > 1) {
            this.quickSort(comparator, 0, this.size() - 1);
            this.rehash();
        }
    }

    private final void quickSort(Comparator comparator, int n, int n2) {
        if (n < n2) {
            int n3 = this.partition(comparator, n, n2);
            if (n < n3) {
                this.quickSort(comparator, n, n3);
            }
            if (++n3 < n2) {
                this.quickSort(comparator, n3, n2);
            }
        }
    }

    protected int partition(Comparator comparator, int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public void dumpNexts() {
        if (this.nextTable == null) {
            return;
        }
        int n = 0;
        while (n < this.nextTable.length) {
            if (this.nextTable[n] != 0) {
                System.out.print(n);
                int n2 = this.nextTable[n] - 1;
                while (n2 >= 0) {
                    System.out.print(" -> " + n2);
                    n2 = this.nextTable[n2] - 1;
                }
                System.out.println("");
            }
            ++n;
        }
    }
}

