/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner2;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectTable;

public class ObjectMap
extends ObjectTable {
    public static final ObjectMap EMPTY_MAP = new ObjectMap(0){

        public Object clone() {
            return this;
        }

        public List toList() {
            return Collections.EMPTY_LIST;
        }

        public Object put(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }
    };
    private Object[] valueTable = new Object[this.capacity()];

    public ObjectMap(int n) {
        super(n);
    }

    public Object clone() {
        ObjectMap objectMap = (ObjectMap)super.clone();
        objectMap.valueTable = new Object[this.capacity()];
        System.arraycopy(this.valueTable, 0, objectMap.valueTable, 0, this.valueTable.length);
        return objectMap;
    }

    public final void clear() {
        super.clear();
        int n = 0;
        while (n < this.valueTable.length) {
            this.valueTable[n] = null;
            ++n;
        }
    }

    protected void resize(int n) {
        Object[] objectArray = this.valueTable;
        this.valueTable = new Object[n];
        System.arraycopy(objectArray, 0, this.valueTable, 0, objectArray.length);
        super.resize(n);
    }

    public Object put(Object object, Object object2) {
        int n = this.add(object);
        Object object3 = this.valueTable[n];
        this.valueTable[n] = object2;
        return object3;
    }

    public final Object get(Object object) {
        int n = this.lookup(object);
        if (n >= 0) {
            return this.valueTable[n];
        }
        return null;
    }

    public final Object getAt(int n) {
        if (n < 0 || n > this.currEntry) {
            return null;
        }
        return this.valueTable[n];
    }

    public final Object remove(Object object) {
        if (object == null) {
            return null;
        }
        int n = this.lookup(object);
        if (n < 0) {
            return null;
        }
        Object object2 = this.valueTable[n];
        this.removeEntry(n);
        return object2;
    }

    protected final void removeEntry(int n) {
        if (n < this.currEntry) {
            System.arraycopy(this.valueTable, n + 1, this.valueTable, n, this.currEntry - n);
        }
        this.valueTable[this.currEntry] = null;
        super.removeEntry(n);
    }

    protected int partition(Comparator comparator, int n, int n2) {
        Object object = this.keyTable[n];
        Object object2 = null;
        int n3 = n;
        int n4 = n2;
        while (true) {
            if (comparator.compare(this.keyTable[n4], object) > 0) {
                --n4;
                continue;
            }
            if (n3 < n4) {
                while (comparator.compare(this.keyTable[n3], object) < 0) {
                    ++n3;
                }
            }
            if (n3 >= n4) break;
            object2 = this.keyTable[n4];
            this.keyTable[n4] = this.keyTable[n3];
            this.keyTable[n3] = object2;
            object2 = this.valueTable[n4];
            this.valueTable[n4] = this.valueTable[n3];
            this.valueTable[n3] = object2;
        }
        return n4;
    }
}

