/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner2;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.core.parser.scanner2.HashTable;

public abstract class ObjectTable
extends HashTable
implements Cloneable {
    protected Object[] keyTable = new Object[this.capacity()];

    public ObjectTable(int n) {
        super(n);
    }

    public Object clone() {
        ObjectTable objectTable = null;
        try {
            objectTable = (ObjectTable)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        int n = this.capacity();
        objectTable.keyTable = new Object[n];
        System.arraycopy(this.keyTable, 0, objectTable.keyTable, 0, this.keyTable.length);
        if (this.hashTable != null) {
            objectTable.hashTable = new int[n * 2];
            objectTable.nextTable = new int[n];
            System.arraycopy(this.hashTable, 0, objectTable.hashTable, 0, this.hashTable.length);
            System.arraycopy(this.nextTable, 0, objectTable.nextTable, 0, this.nextTable.length);
        }
        objectTable.currEntry = this.currEntry;
        return objectTable;
    }

    public List toList() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.size());
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(this.keyAt(n2));
            ++n2;
        }
        return arrayList;
    }

    public Object keyAt(int n) {
        if (n < 0 || n > this.currEntry) {
            return null;
        }
        return this.keyTable[n];
    }

    public void clear() {
        super.clear();
        int n = 0;
        while (n < this.keyTable.length) {
            this.keyTable[n] = null;
            ++n;
        }
    }

    protected final int hash(int n) {
        return this.hash(this.keyTable[n]);
    }

    private int hash(Object object) {
        return object.hashCode() & this.capacity() * 2 - 1;
    }

    protected void resize(int n) {
        Object[] objectArray = this.keyTable;
        this.keyTable = new Object[n];
        System.arraycopy(objectArray, 0, this.keyTable, 0, objectArray.length);
        super.resize(n);
    }

    protected final int add(Object object) {
        int n = this.lookup(object);
        if (n != -1) {
            return n;
        }
        if (this.currEntry + 1 >= this.capacity()) {
            this.resize();
        }
        ++this.currEntry;
        this.keyTable[this.currEntry] = object;
        this.linkIntoHashTable(this.currEntry, this.hash(object));
        return this.currEntry;
    }

    protected void removeEntry(int n) {
        int n2 = this.hash(this.keyTable[n]);
        if (n < this.currEntry) {
            System.arraycopy(this.keyTable, n + 1, this.keyTable, n, this.currEntry - n);
        }
        this.keyTable[this.currEntry] = null;
        this.removeEntry(n, n2);
    }

    protected final int lookup(Object object) {
        if (this.hashTable != null) {
            int n = this.hash(object);
            if (this.hashTable[n] == 0) {
                return -1;
            }
            int n2 = this.hashTable[n] - 1;
            if (object.equals(this.keyTable[n2])) {
                return n2;
            }
            n2 = this.nextTable[n2] - 1;
            while (n2 >= 0) {
                if (object.equals(this.keyTable[n2])) {
                    return n2;
                }
                n2 = this.nextTable[n2] - 1;
            }
            return -1;
        }
        int n = 0;
        while (n <= this.currEntry) {
            if (object.equals(this.keyTable[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean containsKey(Object object) {
        return this.lookup(object) != -1;
    }

    public Object[] keyArray() {
        Object[] objectArray = new Object[this.size()];
        System.arraycopy(this.keyTable, 0, objectArray, 0, objectArray.length);
        return objectArray;
    }
}

