/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.token;

import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.scanner2.CharArrayUtils;

public abstract class AbstractToken
implements IToken,
ITokenDuple {
    private final char[] filename;
    protected int type;
    protected int lineNumber = 1;
    protected IToken next = null;

    public AbstractToken(int n, int n2, char[] cArray) {
        this.setType(n);
        this.lineNumber = n2;
        this.filename = cArray;
    }

    public AbstractToken(int n, char[] cArray, int n2) {
        this.setType(n);
        this.filename = cArray;
        this.lineNumber = n2;
    }

    public String toString() {
        return this.getImage();
    }

    public abstract String getImage();

    public abstract int getOffset();

    public abstract int getLength();

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public char[] getFilename() {
        return this.filename;
    }

    public int getEndOffset() {
        return this.getOffset() + this.getLength();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof IToken)) {
            return false;
        }
        if (((IToken)object).getType() != this.getType()) {
            return false;
        }
        return CharArrayUtils.equals(((IToken)object).getCharImage(), this.getCharImage());
    }

    public boolean canBeAPrefix() {
        switch (this.getType()) {
            case 1: 
            case 34: {
                return true;
            }
        }
        if (this.getType() >= 54 && this.getType() <= 128) {
            return true;
        }
        return this.getType() >= 134 && this.getType() <= 137;
    }

    public boolean looksLikeExpression() {
        switch (this.getType()) {
            case 2: 
            case 8: 
            case 16: 
            case 21: 
            case 23: 
            case 30: 
            case 34: 
            case 36: 
            case 50: 
            case 81: 
            case 114: 
            case 129: 
            case 130: 
            case 131: 
            case 132: {
                return true;
            }
        }
        return false;
    }

    public boolean isOperator() {
        switch (this.getType()) {
            case 6: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 51: 
            case 52: 
            case 72: 
            case 92: {
                return true;
            }
        }
        return false;
    }

    public boolean isPointer() {
        return this.getType() == 30 || this.getType() == 23;
    }

    public final IToken getNext() {
        return this.next;
    }

    public void setNext(IToken iToken) {
        this.next = iToken;
    }

    public boolean contains(ITokenDuple iTokenDuple) {
        return iTokenDuple.getFirstToken() == iTokenDuple.getLastToken() && iTokenDuple.getFirstToken() == this;
    }

    public char[] extractNameFromTemplateId() {
        return this.getCharImage();
    }

    public int findLastTokenType(int n) {
        if (this.getType() == n) {
            return 0;
        }
        return -1;
    }

    public IToken getFirstToken() {
        return this;
    }

    public ITokenDuple getLastSegment() {
        return this;
    }

    public IToken getLastToken() {
        return this;
    }

    public ITokenDuple getLeadingSegments() {
        return null;
    }

    public int getSegmentCount() {
        return 1;
    }

    public int getStartOffset() {
        return this.getOffset();
    }

    public ITokenDuple getSubrange(int n, int n2) {
        if (n == 0 && n2 == 0) {
            return this;
        }
        return null;
    }

    public List[] getTemplateIdArgLists() {
        return null;
    }

    public IToken getToken(int n) {
        if (n == 0) {
            return this;
        }
        return null;
    }

    public boolean isIdentifier() {
        return this.getType() == 1;
    }

    public Iterator iterator() {
        return new SingleIterator();
    }

    public int length() {
        return 1;
    }

    public boolean syntaxOfName() {
        return this.getType() == 1;
    }

    public String[] toQualifiedName() {
        String[] stringArray = new String[]{this.getImage()};
        return stringArray;
    }

    public void freeReferences(IReferenceManager iReferenceManager) {
    }

    public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
    }

    private class SingleIterator
    implements Iterator {
        boolean hasNext = true;

        SingleIterator() {
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public Object next() {
            this.hasNext = false;
            return AbstractToken.this;
        }
    }
}

