/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.token;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.scanner2.CharArrayUtils;
import org.eclipse.cdt.internal.core.parser.token.AbstractToken;
import org.eclipse.cdt.internal.core.parser.token.TokenFactory;

public class BasicTokenDuple
implements ITokenDuple {
    private int numSegments = -1;
    protected final IToken firstToken;
    protected final IToken lastToken;
    private static final char[] EMPTY_STRING = "".toCharArray();
    private char[] stringRepresentation = null;

    BasicTokenDuple(IToken iToken, IToken iToken2) {
        this.firstToken = iToken;
        this.lastToken = iToken2;
    }

    BasicTokenDuple(ITokenDuple iTokenDuple, ITokenDuple iTokenDuple2) {
        this(iTokenDuple.getFirstToken(), iTokenDuple2.getLastToken());
    }

    public IToken getFirstToken() {
        return this.firstToken;
    }

    public IToken getLastToken() {
        return this.lastToken;
    }

    public Iterator iterator() {
        return new TokenIterator();
    }

    public ITokenDuple getLastSegment() {
        IToken iToken = null;
        IToken iToken2 = null;
        IToken iToken3 = null;
        while (iToken3 != this.getLastToken()) {
            IToken iToken4 = iToken3 = iToken3 != null ? iToken3.getNext() : this.getFirstToken();
            if (iToken == null) {
                iToken = iToken3;
            }
            if (iToken3.getType() == 42) {
                iToken3 = TokenFactory.consumeTemplateIdArguments(iToken3, this.getLastToken());
            } else if (iToken3.getType() == 3) {
                iToken = null;
                continue;
            }
            iToken2 = iToken3;
        }
        List[] listArray = this.getTemplateIdArgLists();
        if (listArray != null && listArray[listArray.length - 1] != null) {
            ArrayList<List> arrayList = new ArrayList<List>(1);
            arrayList.add(listArray[listArray.length - 1]);
            return TokenFactory.createTokenDuple(iToken, iToken2, arrayList);
        }
        return TokenFactory.createTokenDuple(iToken, iToken2);
    }

    public ITokenDuple getLeadingSegments() {
        if (this.getFirstToken() == null) {
            return null;
        }
        int n = this.getSegmentCount();
        if (n <= 1) {
            return null;
        }
        IToken iToken = null;
        IToken iToken2 = null;
        IToken iToken3 = null;
        IToken iToken4 = null;
        while (iToken4 != this.getLastToken()) {
            IToken iToken5 = iToken4 = iToken4 != null ? iToken4.getNext() : this.getFirstToken();
            if (iToken == null) {
                iToken = iToken4;
            }
            if (iToken4.getType() == 42) {
                iToken4 = TokenFactory.consumeTemplateIdArguments(iToken4, this.getLastToken());
            } else if (iToken4.getType() == 3) {
                iToken2 = iToken3;
                continue;
            }
            iToken3 = iToken4;
        }
        if (iToken2 == null) {
            return null;
        }
        if (this.getTemplateIdArgLists() != null) {
            List[] listArray = this.getTemplateIdArgLists();
            ArrayList<List> arrayList = new ArrayList<List>(listArray.length - 1);
            boolean bl = false;
            int n2 = 0;
            while (n2 < listArray.length - 1) {
                arrayList.add(listArray[n2]);
                if (listArray[n2] != null) {
                    bl = true;
                }
                ++n2;
            }
            return TokenFactory.createTokenDuple(iToken, iToken2, bl ? arrayList : null);
        }
        return TokenFactory.createTokenDuple(iToken, iToken2);
    }

    public int getSegmentCount() {
        if (this.numSegments == -1) {
            this.numSegments = this.calculateSegmentCount();
        }
        return this.numSegments;
    }

    public static int getCharArrayLength(IToken iToken, IToken iToken2) {
        if (iToken == iToken2) {
            return iToken.getCharImage().length;
        }
        IToken iToken3 = null;
        IToken iToken4 = iToken;
        int n = 0;
        while (true) {
            if (iToken4 == null) {
                return 0;
            }
            if (iToken3 != null && iToken3.getType() != 3 && iToken3.getType() != 1 && iToken3.getType() != 42 && iToken3.getType() != 34 && iToken4.getType() != 46 && iToken3.getType() != 10 && iToken4.getType() != 11 && iToken4.getType() != 3) {
                ++n;
            }
            n += iToken4.getCharImage().length;
            if (iToken4 == iToken2) break;
            iToken3 = iToken4;
            iToken4 = iToken4.getNext();
        }
        return n;
    }

    public static char[] createCharArrayRepresentation(IToken iToken, IToken iToken2) {
        if (iToken == iToken2) {
            return iToken.getCharImage();
        }
        IToken iToken3 = null;
        IToken iToken4 = iToken;
        int n = BasicTokenDuple.getCharArrayLength(iToken, iToken2);
        char[] cArray = new char[n];
        int n2 = 0;
        while (true) {
            if (iToken3 != null && iToken3.getType() != 3 && iToken3.getType() != 1 && iToken3.getType() != 42 && iToken3.getType() != 34 && iToken4.getType() != 46 && iToken3.getType() != 10 && iToken4.getType() != 11 && iToken4.getType() != 3) {
                cArray[n2++] = 32;
            }
            if (iToken4 == null) {
                return EMPTY_STRING;
            }
            CharArrayUtils.overWrite(cArray, n2, iToken4.getCharImage());
            n2 += iToken4.getCharImage().length;
            if (iToken4 == iToken2) break;
            iToken3 = iToken4;
            iToken4 = iToken4.getNext();
        }
        return cArray;
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            this.stringRepresentation = BasicTokenDuple.createCharArrayRepresentation(this.firstToken, this.lastToken);
        }
        return String.valueOf(this.stringRepresentation);
    }

    public boolean isIdentifier() {
        return this.firstToken == this.lastToken && this.firstToken.getType() == 1;
    }

    public int length() {
        int n = 1;
        IToken iToken = this.firstToken;
        while (iToken != this.lastToken) {
            ++n;
            iToken = iToken.getNext();
        }
        return n;
    }

    public ITokenDuple getSubrange(int n, int n2) {
        return TokenFactory.createTokenDuple(this.getToken(n), this.getToken(n2));
    }

    public IToken getToken(int n) {
        if (n < 0) {
            return null;
        }
        IToken iToken = this.firstToken;
        int n2 = 0;
        while (iToken != this.lastToken) {
            iToken = iToken.getNext();
            if (n2 == n) {
                return iToken;
            }
            ++n2;
        }
        return null;
    }

    public int findLastTokenType(int n) {
        int n2 = 0;
        int n3 = -1;
        IToken iToken = this.firstToken;
        while (iToken != this.lastToken) {
            if (iToken.getType() == n) {
                n3 = n2;
            }
            ++n2;
            iToken = iToken.getNext();
        }
        return n3;
    }

    public int getEndOffset() {
        return this.getLastToken().getEndOffset();
    }

    public int getLineNumber() {
        return this.getFirstToken().getLineNumber();
    }

    public int getStartOffset() {
        return this.getFirstToken().getOffset();
    }

    public List[] getTemplateIdArgLists() {
        return null;
    }

    public boolean syntaxOfName() {
        IToken iToken = this.firstToken;
        while (iToken != this.lastToken) {
            if (iToken.isOperator()) {
                iToken = iToken.getNext();
                continue;
            }
            switch (iToken.getType()) {
                case 1: 
                case 3: 
                case 34: 
                case 95: {
                    iToken = iToken.getNext();
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ITokenDuple)) {
            return false;
        }
        return ((ITokenDuple)object).getFirstToken().equals(this.getFirstToken()) && ((ITokenDuple)object).getLastToken().equals(this.getLastToken());
    }

    public char[] extractNameFromTemplateId() {
        ITokenDuple iTokenDuple = this.getLastSegment();
        List[] listArray = this.getTemplateIdArgLists();
        if (listArray == null || listArray[listArray.length - 1] == null) {
            return iTokenDuple.toCharArray();
        }
        AbstractToken abstractToken = (AbstractToken)iTokenDuple.getFirstToken();
        IToken iToken = iTokenDuple.getLastToken();
        if (abstractToken == null) {
            return EMPTY_STRING;
        }
        char[] cArray = abstractToken.getCharImage();
        if (abstractToken == iToken) {
            return cArray;
        }
        char[] cArray2 = new char[BasicTokenDuple.getCharArrayLength(abstractToken, this.lastToken)];
        CharArrayUtils.overWrite(cArray2, 0, cArray);
        int n = cArray.length;
        if (abstractToken.getType() == 34) {
            abstractToken = (AbstractToken)abstractToken.next;
            cArray = abstractToken.getCharImage();
            CharArrayUtils.overWrite(cArray2, n, cArray);
            n += cArray.length;
        } else if (abstractToken.getType() == 95) {
            abstractToken = (AbstractToken)abstractToken.next;
            cArray2[n++] = 32;
            AbstractToken abstractToken2 = abstractToken;
            IToken iToken2 = null;
            while (abstractToken != iToken) {
                iToken2 = abstractToken.next;
                if (iToken2.getType() == 42) break;
                abstractToken = (AbstractToken)iToken2;
            }
            CharArrayUtils.overWrite(cArray2, n, BasicTokenDuple.createCharArrayRepresentation(abstractToken2, abstractToken));
            n += BasicTokenDuple.getCharArrayLength(abstractToken2, abstractToken);
        }
        return CharArrayUtils.extract(cArray2, 0, n);
    }

    public boolean contains(ITokenDuple iTokenDuple) {
        if (iTokenDuple == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        IToken iToken = this.getFirstToken();
        while (iToken != null) {
            if (iToken == iTokenDuple.getFirstToken()) {
                bl = true;
            }
            if (iToken == iTokenDuple.getLastToken()) {
                bl2 = true;
            }
            if (bl && bl2 || iToken == this.getLastToken()) break;
            iToken = iToken.getNext();
        }
        return bl && bl2;
    }

    public String[] toQualifiedName() {
        return this.generateQualifiedName();
    }

    private String[] generateQualifiedName() {
        ArrayList<String> arrayList = new ArrayList<String>();
        IToken iToken = this.firstToken;
        while (iToken != this.lastToken) {
            boolean bl = false;
            if (iToken.getType() == 3) {
                iToken = iToken.getNext();
                continue;
            }
            if (iToken.getType() == 34) {
                bl = true;
                iToken = iToken.getNext();
            }
            if (iToken.getType() == 1) {
                if (bl) {
                    StringBuffer stringBuffer = new StringBuffer("~");
                    stringBuffer.append(iToken.getImage());
                    arrayList.add(stringBuffer.toString());
                } else {
                    arrayList.add(iToken.getImage());
                }
            }
            iToken = iToken.getNext();
        }
        if (iToken.getType() == 1) {
            arrayList.add(iToken.getImage());
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    protected int calculateSegmentCount() {
        int n = 1;
        IToken iToken = null;
        IToken iToken2 = this.getLastToken();
        while (iToken != iToken2) {
            IToken iToken3 = iToken = iToken != null ? iToken.getNext() : this.getFirstToken();
            if (iToken.getType() == 42) {
                iToken = TokenFactory.consumeTemplateIdArguments(iToken, iToken2);
            }
            if (iToken.getType() != 3) continue;
            ++n;
        }
        return n;
    }

    public void freeReferences(IReferenceManager iReferenceManager) {
    }

    public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
    }

    public char[] toCharArray() {
        if (this.stringRepresentation == null) {
            this.stringRepresentation = BasicTokenDuple.createCharArrayRepresentation(this.firstToken, this.lastToken);
        }
        return this.stringRepresentation;
    }

    public char[] getFilename() {
        return this.firstToken.getFilename();
    }

    private class TokenIterator
    implements Iterator {
        private IToken iter;

        TokenIterator() {
            this.iter = BasicTokenDuple.this.firstToken;
        }

        public boolean hasNext() {
            return this.iter != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            IToken iToken = this.iter;
            this.iter = this.iter == BasicTokenDuple.this.lastToken ? null : this.iter.getNext();
            return iToken;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

