/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.token;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.token.BasicTokenDuple;
import org.eclipse.cdt.internal.core.parser.token.TokenFactory;

public class TemplateTokenDuple
extends BasicTokenDuple {
    protected final List[] argLists;
    private final int numSegments;

    public TemplateTokenDuple(IToken iToken, IToken iToken2, List list) {
        super(iToken, iToken2);
        this.argLists = list.toArray(new List[list.size()]);
        this.numSegments = this.calculateSegmentCount();
    }

    public int getSegmentCount() {
        return this.numSegments;
    }

    public ITokenDuple getLastSegment() {
        IToken iToken = null;
        IToken iToken2 = null;
        IToken iToken3 = null;
        while (iToken3 != this.getLastToken()) {
            IToken iToken4 = iToken3 = iToken3 != null ? iToken3.getNext() : this.getFirstToken();
            if (iToken == null) {
                iToken = iToken3;
            }
            if (iToken3.getType() == 42) {
                iToken3 = TokenFactory.consumeTemplateIdArguments(iToken3, this.getLastToken());
            } else if (iToken3.getType() == 3) {
                iToken = null;
                continue;
            }
            iToken2 = iToken3;
        }
        List[] listArray = this.getTemplateIdArgLists();
        if (listArray != null && listArray[listArray.length - 1] != null) {
            ArrayList<List> arrayList = new ArrayList<List>(1);
            arrayList.add(listArray[listArray.length - 1]);
            return TokenFactory.createTokenDuple(iToken, iToken2, arrayList);
        }
        return TokenFactory.createTokenDuple(iToken, iToken2);
    }

    public TemplateTokenDuple(ITokenDuple iTokenDuple, ITokenDuple iTokenDuple2) {
        super(iTokenDuple, iTokenDuple2);
        List[] listArray = iTokenDuple.getTemplateIdArgLists();
        List[] listArray2 = iTokenDuple2.getTemplateIdArgLists();
        int n = listArray != null ? listArray.length : iTokenDuple.getSegmentCount();
        int n2 = listArray2 != null ? listArray2.length : iTokenDuple.getSegmentCount();
        this.argLists = new List[n + n2];
        if (listArray != null) {
            System.arraycopy(listArray, 0, this.argLists, 0, n);
        }
        if (listArray2 != null) {
            System.arraycopy(listArray2, 0, this.argLists, n, n2);
        }
        this.numSegments = this.calculateSegmentCount();
    }

    public List[] getTemplateIdArgLists() {
        return this.argLists;
    }

    public void freeReferences(IReferenceManager iReferenceManager) {
        if (this.argLists == null) {
            return;
        }
        int n = 0;
        while (n < this.argLists.length) {
            if (this.argLists[n] != null) {
                int n2 = 0;
                while (n2 < this.argLists[n].size()) {
                    IASTExpression iASTExpression = (IASTExpression)this.argLists[n].get(n2);
                    iASTExpression.freeReferences(iReferenceManager);
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
        if (this.argLists == null) {
            return;
        }
        int n = 0;
        while (n < this.argLists.length) {
            if (this.argLists[n] != null) {
                int n2 = 0;
                while (n2 < this.argLists[n].size()) {
                    IASTExpression iASTExpression = (IASTExpression)this.argLists[n].get(n2);
                    iASTExpression.acceptElement(iSourceElementRequestor, iReferenceManager);
                    ++n2;
                }
            }
            ++n;
        }
    }
}

