/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.token;

import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.internal.core.parser.scanner.IScannerContext;
import org.eclipse.cdt.internal.core.parser.scanner.IScannerData;
import org.eclipse.cdt.internal.core.parser.token.BasicTokenDuple;
import org.eclipse.cdt.internal.core.parser.token.ImagedExpansionToken;
import org.eclipse.cdt.internal.core.parser.token.ImagedToken;
import org.eclipse.cdt.internal.core.parser.token.SimpleExpansionToken;
import org.eclipse.cdt.internal.core.parser.token.SimpleToken;
import org.eclipse.cdt.internal.core.parser.token.TemplateTokenDuple;

public class TokenFactory {
    protected static final char[] EMPTY_CHAR_ARRAY = "".toCharArray();

    public static IToken createToken(int n, IScannerData iScannerData) {
        if (iScannerData.getContextStack().getCurrentContext().getKind() == IScannerContext.ContextKind.MACROEXPANSION) {
            return new SimpleExpansionToken(n, iScannerData.getContextStack(), TokenFactory.getCurrentFilename(iScannerData));
        }
        return new SimpleToken(n, iScannerData.getContextStack(), TokenFactory.getCurrentFilename(iScannerData));
    }

    private static char[] getCurrentFilename(IScannerData iScannerData) {
        return iScannerData.getContextStack().getInclusionFilename(iScannerData.getContextStack().getMostRelevantFileContextIndex()).toCharArray();
    }

    public static IToken createUniquelyImagedToken(int n, String string, IScannerData iScannerData) {
        if (iScannerData.getContextStack().getCurrentContext().getKind() == IScannerContext.ContextKind.MACROEXPANSION) {
            return new ImagedExpansionToken(n, iScannerData.getContextStack(), string.toCharArray(), TokenFactory.getCurrentFilename(iScannerData));
        }
        return new ImagedToken(n, iScannerData.getContextStack(), string.toCharArray(), TokenFactory.getCurrentFilename(iScannerData));
    }

    public static IToken createStandAloneToken(int n, String string) {
        return new ImagedToken(n, string.toCharArray(), 0, EMPTY_CHAR_ARRAY, 0);
    }

    public static ITokenDuple createTokenDuple(IToken iToken, IToken iToken2) {
        if (iToken == iToken2 && iToken instanceof ITokenDuple) {
            return (ITokenDuple)((Object)iToken);
        }
        return new BasicTokenDuple(iToken, iToken2);
    }

    public static ITokenDuple createTokenDuple(IToken iToken, IToken iToken2, List list) {
        if (iToken == iToken2 && list == null && iToken instanceof ITokenDuple) {
            return (ITokenDuple)((Object)iToken);
        }
        if (list != null && !list.isEmpty()) {
            return new TemplateTokenDuple(iToken, iToken2, list);
        }
        return new BasicTokenDuple(iToken, iToken2);
    }

    public static ITokenDuple createTokenDuple(ITokenDuple iTokenDuple, ITokenDuple iTokenDuple2) {
        List[] listArray = iTokenDuple.getTemplateIdArgLists();
        List[] listArray2 = iTokenDuple2.getTemplateIdArgLists();
        if (listArray == null && listArray2 == null) {
            return new BasicTokenDuple(iTokenDuple, iTokenDuple2);
        }
        return new TemplateTokenDuple(iTokenDuple, iTokenDuple2);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IToken consumeTemplateIdArguments(IToken iToken, IToken iToken2) {
        IToken iToken3 = iToken;
        if (iToken3.getType() != 42) return iToken3;
        if (iToken3 == iToken2) {
            return iToken3;
        }
        BraceCounter braceCounter = BraceCounter.getCounter();
        try {
            braceCounter.addValue(42);
            boolean bl = true;
            do {
                if (!bl || (bl = false) || !true) {
                    iToken3 = iToken3.getNext();
                    switch (iToken3.getType()) {
                        case 46: {
                            if (braceCounter.getLast() != 42) break;
                            braceCounter.removeValue();
                            break;
                        }
                        case 11: {
                            int n;
                            do {
                                n = braceCounter.removeValue();
                            } while (!braceCounter.isEmpty() && n == 42);
                            break;
                        }
                        case 9: {
                            int n;
                            do {
                                n = braceCounter.removeValue();
                            } while (!braceCounter.isEmpty() && n == 42);
                            break;
                        }
                        case 42: {
                            braceCounter.addValue(42);
                            break;
                        }
                        case 10: {
                            braceCounter.addValue(10);
                            break;
                        }
                        case 8: {
                            braceCounter.addValue(8);
                            break;
                        }
                    }
                }
                if (braceCounter.isEmpty()) break;
            } while (iToken3 != iToken2);
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            BraceCounter.returnCounter(braceCounter);
            throw throwable;
        }
        BraceCounter.returnCounter(braceCounter);
        return iToken3;
    }

    public static char[] createCharArrayRepresentation(IToken iToken, IToken iToken2) {
        return BasicTokenDuple.createCharArrayRepresentation(iToken, iToken2);
    }

    protected static class BraceCounter {
        private static final int POOLSIZE = 8;
        private static final BraceCounter[] pool;
        private static final boolean[] free;
        private static int newObjectCount;
        private final int key;
        private int[] array = new int[8];
        int currentIndex = 0;

        static {
            newObjectCount = 8;
            pool = new BraceCounter[8];
            free = new boolean[8];
            int n = 0;
            while (n < 8) {
                BraceCounter.pool[n] = new BraceCounter(n);
                BraceCounter.free[n] = true;
                ++n;
            }
        }

        public static synchronized BraceCounter getCounter() {
            int n = 0;
            while (n < 8) {
                if (free[n]) {
                    BraceCounter.free[n] = false;
                    return pool[n];
                }
                ++n;
            }
            return new BraceCounter(newObjectCount++);
        }

        public static synchronized void returnCounter(BraceCounter braceCounter) {
            if (braceCounter.getKey() > 0 && braceCounter.getKey() < 8) {
                BraceCounter.free[braceCounter.getKey()] = true;
                braceCounter.clear();
            }
        }

        private void clear() {
            this.currentIndex = 0;
            Arrays.fill(this.array, 0, this.array.length, -1);
        }

        private void resizeArray() {
            int[] nArray = new int[this.array.length * 2];
            System.arraycopy(this.array, 0, nArray, 0, this.array.length);
            this.array = nArray;
        }

        public void addValue(int n) {
            if (this.currentIndex == this.array.length) {
                this.resizeArray();
            }
            this.array[this.currentIndex] = n;
            ++this.currentIndex;
        }

        public int removeValue() {
            int n = this.array[this.currentIndex];
            this.array[this.currentIndex] = -1;
            --this.currentIndex;
            return n;
        }

        public int getLast() {
            if (this.isEmpty()) {
                return -1;
            }
            return this.array[this.currentIndex - 1];
        }

        public boolean isEmpty() {
            return this.currentIndex == 0;
        }

        public BraceCounter(int n) {
            this.key = n;
            this.clear();
        }

        public int getKey() {
            return this.key;
        }
    }
}

