/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class IndexSelector {
    ICSearchScope searchScope;
    ICElement focus;
    IndexManager indexManager;
    IPath[] indexKeys;
    boolean isPolymorphicSearch;

    public IndexSelector(ICSearchScope iCSearchScope, ICElement iCElement, boolean bl, IndexManager indexManager) {
        this.searchScope = iCSearchScope;
        this.focus = iCElement;
        this.indexManager = indexManager;
        this.isPolymorphicSearch = bl;
    }

    public static boolean canSeeFocus(ICElement iCElement, boolean bl, IPath iPath) {
        ICModel iCModel = iCElement.getCModel();
        IndexSelector.getCProject(iPath, iCModel);
        return true;
    }

    private void initializeIndexKeys() {
        ArrayList<IPath> arrayList = new ArrayList<IPath>();
        IPath[] iPathArray = this.searchScope.enclosingProjects();
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        ICElement iCElement = this.focus == null ? null : IndexSelector.getProject(this.focus);
        int n = 0;
        while (n < iPathArray.length) {
            IPath iPath;
            IPath iPath2 = iPathArray[n];
            if ((iWorkspaceRoot.getProject(iPath2.lastSegment()).exists() || iPath2.segmentCount() <= 1 || (iPath = iWorkspaceRoot.getFile(iPath2).getLocation()) != null && new File(iPath.toOSString()).exists() || new File(iPath2.toOSString()).exists()) && (iCElement == null || IndexSelector.canSeeFocus(iCElement, this.isPolymorphicSearch, iPath2)) && arrayList.indexOf(iPath2) == -1) {
                arrayList.add(iPath2);
            }
            ++n;
        }
        this.indexKeys = new IPath[arrayList.size()];
        arrayList.toArray(this.indexKeys);
    }

    public IIndex[] getIndexes() {
        if (this.indexKeys == null) {
            this.initializeIndexKeys();
        }
        int n = this.indexKeys.length;
        IIndex[] iIndexArray = new IIndex[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            IIndex iIndex = this.indexManager.getIndex(this.indexKeys[n3], true, false);
            if (iIndex != null) {
                iIndexArray[n2++] = iIndex;
            }
            ++n3;
        }
        if (n2 != n) {
            IIndex[] iIndexArray2 = iIndexArray;
            iIndexArray = new IIndex[n2];
            System.arraycopy(iIndexArray2, 0, iIndexArray, 0, n2);
        }
        return iIndexArray;
    }

    private static ICProject getCProject(IPath iPath, ICModel iCModel) {
        ICProject iCProject = iCModel.getCProject(iPath.lastSegment());
        if (iCProject.exists()) {
            return iCProject;
        }
        return null;
    }

    public static ICElement getProject(ICElement iCElement) {
        while (!(iCElement instanceof ICProject)) {
            iCElement = iCElement.getParent();
        }
        return iCElement;
    }
}

