/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search;

import java.io.IOException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.IndexSelector;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;
import org.eclipse.cdt.internal.core.search.processing.IJob;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class PatternSearchJob
implements IJob {
    protected CSearchPattern pattern;
    protected ICSearchScope scope;
    protected ICElement focus;
    protected IIndexSearchRequestor requestor;
    protected IndexManager indexManager;
    protected int detailLevel;
    protected IndexSelector indexSelector;
    protected boolean isPolymorphicSearch;
    protected long executionTime = 0L;

    public PatternSearchJob(CSearchPattern cSearchPattern, ICSearchScope iCSearchScope, IIndexSearchRequestor iIndexSearchRequestor, IndexManager indexManager) {
        this(cSearchPattern, iCSearchScope, null, false, iIndexSearchRequestor, indexManager);
    }

    public PatternSearchJob(CSearchPattern cSearchPattern, ICSearchScope iCSearchScope, ICElement iCElement, boolean bl, IIndexSearchRequestor iIndexSearchRequestor, IndexManager indexManager) {
        this.pattern = cSearchPattern;
        this.scope = iCSearchScope;
        this.focus = iCElement;
        this.isPolymorphicSearch = bl;
        this.requestor = iIndexSearchRequestor;
        this.indexManager = indexManager;
    }

    public boolean belongsTo(String string) {
        return true;
    }

    public void cancel() {
    }

    public boolean execute(IProgressMonitor iProgressMonitor) {
        boolean bl;
        block9: {
            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            boolean bl2 = true;
            this.executionTime = 0L;
            if (this.indexSelector == null) {
                this.indexSelector = new IndexSelector(this.scope, this.focus, this.isPolymorphicSearch, this.indexManager);
            }
            IIndex[] iIndexArray = this.indexSelector.getIndexes();
            try {
                int n = iIndexArray.length;
                if (iProgressMonitor != null) {
                    iProgressMonitor.beginTask("", n);
                }
                int n2 = 0;
                while (n2 < n) {
                    bl2 &= this.search(iIndexArray[n2], iProgressMonitor);
                    if (iProgressMonitor != null) {
                        if (iProgressMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        iProgressMonitor.worked(1);
                    }
                    ++n2;
                }
                if (JobManager.VERBOSE) {
                    JobManager.verbose("-> execution time: " + this.executionTime + "ms - " + this);
                }
                bl = bl2;
                Object var6_7 = null;
                if (iProgressMonitor == null) break block9;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var6_8 = null;
                    if (iProgressMonitor == null) break block10;
                    iProgressMonitor.done();
                }
                throw throwable;
            }
            iProgressMonitor.done();
        }
        return bl;
    }

    public boolean isReadyToRun() {
        if (this.indexSelector == null) {
            this.indexSelector = new IndexSelector(this.scope, this.focus, this.isPolymorphicSearch, this.indexManager);
            this.indexSelector.getIndexes();
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean search(IIndex iIndex, IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (iIndex == null) {
            return true;
        }
        ReadWriteMonitor readWriteMonitor = this.indexManager.getMonitorFor(iIndex);
        if (readWriteMonitor == null) {
            return true;
        }
        try {
            try {
                block12: {
                    readWriteMonitor.enterRead();
                    if (!iIndex.hasChanged()) break block12;
                    try {
                        try {
                            readWriteMonitor.exitRead();
                            readWriteMonitor.enterWrite();
                            this.indexManager.saveIndex(iIndex);
                        }
                        catch (IOException iOException) {
                            Object var4_4 = null;
                            readWriteMonitor.exitWriteEnterRead();
                            Object var6_8 = null;
                            readWriteMonitor.exitRead();
                            return false;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        readWriteMonitor.exitWriteEnterRead();
                        throw throwable;
                    }
                    {
                        Object var4_6 = null;
                        readWriteMonitor.exitWriteEnterRead();
                    }
                }
                long l = System.currentTimeMillis();
                this.pattern.findIndexMatches(iIndex, this.requestor, this.detailLevel, iProgressMonitor, this.scope);
                this.executionTime += System.currentTimeMillis() - l;
                Object var6_9 = null;
                readWriteMonitor.exitRead();
                return true;
            }
            catch (IOException iOException) {
                Object var6_10 = null;
                readWriteMonitor.exitRead();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            readWriteMonitor.exitRead();
            throw throwable;
        }
    }

    public String toString() {
        return "searching " + this.pattern.toString();
    }
}

