/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.indexing;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.search.indexing.CleanEncounteredHeaders;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

class AddFolderToIndex
extends IndexRequest {
    IPath folderPath;
    IProject project;
    char[][] exclusionPattern;
    ArrayList sourceFilesToIndex;
    ArrayList headerFilesToIndex;

    public AddFolderToIndex(IPath iPath, IProject iProject, char[][] cArray, IndexManager indexManager) {
        super(iProject.getFullPath(), indexManager);
        this.folderPath = iPath;
        this.project = iProject;
        this.exclusionPattern = cArray;
        this.sourceFilesToIndex = new ArrayList();
        this.headerFilesToIndex = new ArrayList();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            return true;
        }
        if (!this.project.isAccessible()) {
            return true;
        }
        IResource iResource = this.project.getParent().findMember(this.folderPath);
        if (iResource == null) return true;
        if (iResource.getType() == 1) {
            return true;
        }
        IIndex iIndex = this.manager.getIndex(this.indexPath, true, true);
        if (iIndex == null) {
            return true;
        }
        ReadWriteMonitor readWriteMonitor = this.manager.getMonitorFor(iIndex);
        if (readWriteMonitor == null) {
            return true;
        }
        try {
            try {
                readWriteMonitor.enterRead();
                final char[][] cArray = this.exclusionPattern;
                iResource.accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy iResourceProxy) throws CoreException {
                        switch (iResourceProxy.getType()) {
                            case 1: {
                                IResource iResource = iResourceProxy.requestResource();
                                if (CoreModel.isValidTranslationUnitName(iResource.getProject(), iResource.getName()) && (cArray == null || !Util.isExcluded(iResource, cArray))) {
                                    AddFolderToIndex.this.sortFiles((IFile)iResource);
                                }
                                return false;
                            }
                            case 2: {
                                if (cArray == null || !Util.isExcluded(iResourceProxy.requestResource(), cArray)) break;
                                return false;
                            }
                        }
                        return true;
                    }
                }, 0);
                this.scheduleJobs();
            }
            catch (CoreException coreException) {
                if (IndexManager.VERBOSE) {
                    JobManager.verbose("-> failed to add " + this.folderPath + " to index because of the following exception:");
                    coreException.printStackTrace();
                }
                Object var6_7 = null;
                readWriteMonitor.exitRead();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            readWriteMonitor.exitRead();
            throw throwable;
        }
        {
            Object var6_9 = null;
            readWriteMonitor.exitRead();
            return true;
        }
    }

    private void scheduleJobs() {
        int n = 0;
        while (n < this.sourceFilesToIndex.size()) {
            this.manager.addSource((IFile)this.sourceFilesToIndex.get(n), this.indexPath, true);
            ++n;
        }
        n = 0;
        while (n < this.headerFilesToIndex.size()) {
            this.manager.addSource((IFile)this.headerFilesToIndex.get(n), this.indexPath, true);
            ++n;
        }
        CleanEncounteredHeaders cleanEncounteredHeaders = new CleanEncounteredHeaders(this.manager);
        this.manager.request(cleanEncounteredHeaders);
    }

    public String toString() {
        return "adding " + this.folderPath + " to index " + this.indexPath;
    }

    protected void sortFiles(IFile iFile) {
        ICFileType iCFileType = CCorePlugin.getDefault().getFileType(iFile.getProject(), iFile.getName());
        if (iCFileType.isHeader()) {
            this.headerFilesToIndex.add(iFile);
        }
        if (iCFileType.isSource()) {
            this.sourceFilesToIndex.add(iFile);
        }
    }
}

