/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.indexing;

import java.io.IOException;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.IQueryResult;
import org.eclipse.cdt.internal.core.model.CModel;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.SourceRoot;
import org.eclipse.cdt.internal.core.search.SimpleLookupTable;
import org.eclipse.cdt.internal.core.search.indexing.AddFolderToIndex;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.indexing.SaveIndex;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class IndexAllProject
extends IndexRequest {
    IProject project;

    public IndexAllProject(IProject iProject, IndexManager indexManager) {
        super(iProject.getFullPath(), indexManager);
        this.project = iProject;
    }

    public boolean equals(Object object) {
        if (object instanceof IndexAllProject) {
            return this.project.equals((Object)((IndexAllProject)object).project);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor iProgressMonitor) {
        ReadWriteMonitor readWriteMonitor;
        block19: {
            block18: {
                if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                    return true;
                }
                if (!this.project.isAccessible()) {
                    return true;
                }
                IIndex iIndex = this.manager.getIndex(this.indexPath, true, true);
                if (iIndex == null) {
                    return true;
                }
                readWriteMonitor = this.manager.getMonitorFor(iIndex);
                if (readWriteMonitor == null) {
                    return true;
                }
                try {
                    try {
                        CModel cModel;
                        readWriteMonitor.enterRead();
                        this.saveIfNecessary(iIndex, readWriteMonitor);
                        IQueryResult[] iQueryResultArray = iIndex.queryInDocumentNames("");
                        int n = iQueryResultArray == null ? 0 : iQueryResultArray.length;
                        SimpleLookupTable simpleLookupTable = new SimpleLookupTable(n == 0 ? 33 : n + 11);
                        int n2 = 0;
                        while (true) {
                            if (n2 >= n) {
                                cModel = CModelManager.getDefault().getCModel();
                                if (cModel != null) break;
                                Object var12_11 = null;
                                readWriteMonitor.exitRead();
                                return false;
                            }
                            simpleLookupTable.put(iQueryResultArray[n2].getPath(), "DELETED");
                            ++n2;
                        }
                        ICProject iCProject = cModel.getCProject(this.project.getName());
                        if (iCProject == null) {
                            break block18;
                        }
                        ISourceRoot[] iSourceRootArray = iCProject.getSourceRoots();
                        int n3 = 0;
                        while (true) {
                            if (n3 >= iSourceRootArray.length) {
                                this.manager.request(new SaveIndex(this.indexPath, this.manager));
                                break block19;
                            }
                            if (iSourceRootArray[n3] instanceof SourceRoot) {
                                ISourceEntry iSourceEntry = ((SourceRoot)iSourceRootArray[n3]).getSourceEntry();
                                this.manager.request(new AddFolderToIndex(iSourceRootArray[n3].getPath(), this.project, iSourceEntry.fullExclusionPatternChars(), this.manager));
                            }
                            ++n3;
                        }
                    }
                    catch (CoreException coreException) {
                        if (IndexManager.VERBOSE) {
                            JobManager.verbose("-> failed to index " + this.project + " because of the following exception:");
                            coreException.printStackTrace();
                        }
                        this.manager.removeIndex(this.indexPath);
                        Object var12_13 = null;
                        readWriteMonitor.exitRead();
                        return false;
                    }
                    catch (IOException iOException) {
                        if (IndexManager.VERBOSE) {
                            JobManager.verbose("-> failed to index " + this.project + " because of the following exception:");
                            iOException.printStackTrace();
                        }
                        this.manager.removeIndex(this.indexPath);
                        Object var12_14 = null;
                        readWriteMonitor.exitRead();
                        return false;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    readWriteMonitor.exitRead();
                    throw throwable;
                }
            }
            Object var12_12 = null;
            readWriteMonitor.exitRead();
            return false;
        }
        Object var12_16 = null;
        readWriteMonitor.exitRead();
        return true;
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing project " + this.project.getFullPath();
    }
}

