/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.indexing;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.core.index.IIndexChangeListener;
import org.eclipse.cdt.core.index.IndexChangeEvent;
import org.eclipse.cdt.core.parser.ParserTimeOut;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.impl.Index;
import org.eclipse.cdt.internal.core.index.impl.IndexDelta;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectSet;
import org.eclipse.cdt.internal.core.search.CWorkspaceScope;
import org.eclipse.cdt.internal.core.search.IndexSelector;
import org.eclipse.cdt.internal.core.search.SimpleLookupTable;
import org.eclipse.cdt.internal.core.search.indexing.AddCompilationUnitToIndex;
import org.eclipse.cdt.internal.core.search.indexing.AddFolderToIndex;
import org.eclipse.cdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.cdt.internal.core.search.indexing.IndexAllProject;
import org.eclipse.cdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.cdt.internal.core.search.indexing.IndexerModelListener;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.indexing.RemoveFolderFromIndex;
import org.eclipse.cdt.internal.core.search.indexing.RemoveFromIndex;
import org.eclipse.cdt.internal.core.search.processing.IJob;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.cdt.internal.core.sourcedependency.UpdateDependency;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IndexManager
extends JobManager
implements IIndexConstants {
    public static int MAX_FILES_IN_MEMORY = 0;
    public IWorkspace workspace;
    public SimpleLookupTable indexNames = new SimpleLookupTable();
    private Map indexes = new HashMap(5);
    private Map monitors = new HashMap(5);
    private boolean needToSave = false;
    private static final CRC32 checksumCalculator = new CRC32();
    private IPath cCorePluginLocation = null;
    private SimpleLookupTable indexStates = null;
    private File savedIndexNamesFile = new File(this.getCCorePluginWorkingLocation().append("savedIndexNames.txt").toOSString());
    private SimpleLookupTable encounteredHeaders = null;
    public static Integer SAVED_STATE = new Integer(0);
    public static Integer UPDATING_STATE = new Integer(1);
    public static Integer UNKNOWN_STATE = new Integer(2);
    public static Integer REBUILDING_STATE = new Integer(3);
    public static boolean VERBOSE = false;
    private ParserTimeOut timeoutThread = null;
    private IndexerModelListener indexModelListener = null;
    protected List indexChangeListeners = Collections.synchronizedList(new ArrayList());
    public static final String INDEX_NOTIFICATION_NAME = Util.bind("indexNotificationJob");
    public static final String INDEX_MODEL_ID = "org.eclipse.cdt.core.newindexmodel";
    public static final String ACTIVATION = "enable";
    public static final String PROBLEM_ACTIVATION = "problemEnable";
    public static final QualifiedName activationKey = new QualifiedName("org.eclipse.cdt.core.newindexmodel", "enable");
    public static final QualifiedName problemsActivationKey = new QualifiedName("org.eclipse.cdt.core.newindexmodel", "problemEnable");
    public static final String INDEXER_ENABLED = "indexEnabled";
    public static final String INDEXER_PROBLEMS_ENABLED = "indexerProblemsEnabled";
    public static final String CDT_INDEXER = "cdt_indexer";
    public static final String INDEXER_VALUE = "indexValue";
    public static final String INDEXER_PROBLEMS_VALUE = "indexProblemsValue";
    public static final int PREPROCESSOR_PROBLEMS_BIT = 1;
    public static final int SEMANTIC_PROBLEMS_BIT = 2;
    public static final int SYNTACTIC_PROBLEMS_BIT = 4;

    public synchronized void aboutToUpdateIndex(IPath iPath, Integer n) {
        Integer n2;
        String string = this.computeIndexName(iPath);
        Object object = this.getIndexStates().get(string);
        Integer n3 = n2 = object == null ? UNKNOWN_STATE : (Integer)object;
        if (n2.equals(REBUILDING_STATE)) {
            return;
        }
        int n4 = n.compareTo(n2);
        if (n4 > 0) {
            this.updateIndexState(string, n);
        } else if (n4 < 0 && this.indexes.get(iPath) == null) {
            this.rebuildIndex(string, iPath);
        }
    }

    public void addSource(IFile iFile, IPath iPath, boolean bl) {
        IProject iProject = iFile.getProject();
        boolean bl2 = false;
        if (iProject != null) {
            bl2 = this.isIndexEnabled(iProject);
        } else {
            org.eclipse.cdt.internal.core.model.Util.log(null, "IndexManager addSource: File has no project associated : " + iFile.getName(), ICLogConstants.CDT);
        }
        if (CCorePlugin.getDefault() == null) {
            return;
        }
        if (bl2) {
            AddCompilationUnitToIndex addCompilationUnitToIndex = new AddCompilationUnitToIndex(iFile, iPath, this, bl);
            if (!this.jobSet.add(addCompilationUnitToIndex.resource.getLocation()) && this.enabledState() == 1) {
                return;
            }
            if (this.awaitingJobsCount() < MAX_FILES_IN_MEMORY && !addCompilationUnitToIndex.initializeContents()) {
                return;
            }
            this.request(addCompilationUnitToIndex);
        }
    }

    public void updateDependencies(IResource iResource) {
        if (CCorePlugin.getDefault() == null || !this.isIndexEnabled(iResource.getProject())) {
            return;
        }
        UpdateDependency updateDependency = new UpdateDependency(iResource);
        this.request(updateDependency);
    }

    String computeIndexName(IPath iPath) {
        String string = (String)this.indexNames.get(iPath);
        if (string == null) {
            String string2 = iPath.toOSString();
            checksumCalculator.reset();
            checksumCalculator.update(string2.getBytes());
            String string3 = String.valueOf(Long.toString(checksumCalculator.getValue())) + ".index";
            if (VERBOSE) {
                JobManager.verbose("-> index name for " + string2 + " is " + string3);
            }
            string = this.getCCorePluginWorkingLocation().append(string3).toOSString();
            this.indexNames.put(iPath, string);
        }
        return string;
    }

    public synchronized IIndex getIndex(IPath iPath, boolean bl, boolean bl2) {
        IIndex iIndex = (IIndex)this.indexes.get(iPath);
        if (iIndex == null) {
            Integer n;
            String string = this.computeIndexName(iPath);
            Object object = this.getIndexStates().get(string);
            Integer n2 = n = object == null ? UNKNOWN_STATE : (Integer)object;
            if (n == UNKNOWN_STATE) {
                this.rebuildIndex(string, iPath);
                return null;
            }
            if (bl) {
                File file = new File(string);
                if (file.exists()) {
                    try {
                        iIndex = new Index(string, "Index for " + iPath.toOSString(), true);
                        this.indexes.put(iPath, iIndex);
                        this.monitors.put(iIndex, new ReadWriteMonitor());
                        return iIndex;
                    }
                    catch (IOException iOException) {
                        if (n != REBUILDING_STATE) {
                            if (VERBOSE) {
                                JobManager.verbose("-> cannot reuse existing index: " + string + " path: " + iPath.toOSString());
                            }
                            this.rebuildIndex(string, iPath);
                            return null;
                        }
                        iIndex = null;
                    }
                }
                if (n == SAVED_STATE) {
                    this.rebuildIndex(string, iPath);
                    return null;
                }
            }
            if (bl2) {
                try {
                    if (VERBOSE) {
                        JobManager.verbose("-> create empty index: " + string + " path: " + iPath.toOSString());
                    }
                    iIndex = new Index(string, "Index for " + iPath.toOSString(), false);
                    this.indexes.put(iPath, iIndex);
                    this.monitors.put(iIndex, new ReadWriteMonitor());
                    return iIndex;
                }
                catch (IOException iOException) {
                    if (VERBOSE) {
                        JobManager.verbose("-> unable to create empty index: " + string + " path: " + iPath.toOSString());
                    }
                    return null;
                }
            }
        }
        return iIndex;
    }

    public synchronized boolean haveEncounteredHeader(IPath iPath, IPath iPath2) {
        SimpleLookupTable simpleLookupTable = this.getEncounteredHeaders();
        ObjectSet objectSet = (ObjectSet)simpleLookupTable.get(iPath);
        if (objectSet == null) {
            objectSet = new ObjectSet(4);
            simpleLookupTable.put(iPath, objectSet);
        }
        if (objectSet.containsKey(iPath2.toOSString())) {
            return true;
        }
        objectSet.put(iPath2.toOSString());
        return false;
    }

    private SimpleLookupTable getIndexStates() {
        if (this.indexStates != null) {
            return this.indexStates;
        }
        this.indexStates = new SimpleLookupTable();
        char[] cArray = this.readIndexState();
        if (cArray.length > 0) {
            char[][] cArray2 = CharOperation.splitOn('\n', cArray);
            int n = 0;
            int n2 = cArray2.length;
            while (n < n2) {
                char[] cArray3 = cArray2[n];
                if (cArray3.length > 0) {
                    this.indexStates.put(new String(cArray3), SAVED_STATE);
                }
                ++n;
            }
        }
        return this.indexStates;
    }

    private SimpleLookupTable getEncounteredHeaders() {
        if (this.encounteredHeaders == null) {
            this.encounteredHeaders = new SimpleLookupTable();
        }
        return this.encounteredHeaders;
    }

    public void resetEncounteredHeaders() {
        this.encounteredHeaders = null;
    }

    private IPath getCCorePluginWorkingLocation() {
        if (this.cCorePluginLocation != null) {
            return this.cCorePluginLocation;
        }
        this.cCorePluginLocation = CCorePlugin.getDefault().getStateLocation();
        return this.cCorePluginLocation;
    }

    public ReadWriteMonitor getMonitorFor(IIndex iIndex) {
        return (ReadWriteMonitor)this.monitors.get(iIndex);
    }

    public void indexAll(IProject iProject) {
        if (CCorePlugin.getDefault() == null) {
            return;
        }
        boolean bl = this.isIndexEnabled(iProject);
        if (bl) {
            if (this.enabledState() == 2) {
                this.enable();
            }
            IndexAllProject indexAllProject = new IndexAllProject(iProject, this);
            int n = this.jobEnd;
            while (n > this.jobStart) {
                if (((Object)indexAllProject).equals(this.awaitingJobs[n])) {
                    return;
                }
                --n;
            }
            this.request(indexAllProject);
        }
    }

    public boolean isIndexEnabled(IProject iProject) {
        if (iProject == null || !iProject.exists() || !iProject.isOpen()) {
            return false;
        }
        Boolean bl = null;
        try {
            bl = (Boolean)iProject.getSessionProperty(activationKey);
        }
        catch (CoreException coreException) {}
        if (bl != null) {
            return bl;
        }
        try {
            bl = this.loadIndexerEnabledFromCDescriptor(iProject);
            if (bl != null) {
                iProject.setSessionProperty(activationKey, (Object)bl);
                return bl;
            }
            bl = new Boolean(true);
            iProject.setSessionProperty(activationKey, (Object)bl);
            return bl;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public int indexProblemsEnabled(IProject iProject) {
        Integer n = null;
        try {
            n = (Integer)iProject.getSessionProperty(problemsActivationKey);
        }
        catch (CoreException coreException) {}
        if (n != null) {
            return n;
        }
        try {
            n = this.loadIndexerProblemsEnabledFromCDescriptor(iProject);
            if (n != null) {
                iProject.setSessionProperty(problemsActivationKey, (Object)n);
                return n;
            }
            n = new Integer(0);
            iProject.setSessionProperty(problemsActivationKey, (Object)n);
            return n;
        }
        catch (CoreException coreException) {
            return 0;
        }
    }

    public void indexSourceFolder(IProject iProject, IPath iPath, char[][] cArray) {
        if (!this.isIndexEnabled(iProject)) {
            return;
        }
        if (this.jobEnd > this.jobStart) {
            IndexAllProject indexAllProject = new IndexAllProject(iProject, this);
            int n = this.jobEnd;
            while (n > this.jobStart) {
                if (((Object)indexAllProject).equals(this.awaitingJobs[n])) {
                    return;
                }
                --n;
            }
        }
        this.request(new AddFolderToIndex(iPath, iProject, cArray, this));
    }

    public void jobWasCancelled(IPath iPath) {
        Object v = this.indexes.get(iPath);
        if (v instanceof IIndex) {
            this.monitors.remove(v);
            this.indexes.remove(iPath);
        }
        this.updateIndexState(this.computeIndexName(iPath), UNKNOWN_STATE);
    }

    protected synchronized void moveToNextJob() {
        this.needToSave = true;
        super.moveToNextJob();
    }

    protected void notifyIdle(long l) {
        if (l > 1000L && this.needToSave) {
            this.saveIndexes();
        }
    }

    public IIndex peekAtIndex(IPath iPath) {
        return (IIndex)this.indexes.get(iPath);
    }

    public String processName() {
        return Util.bind("process.name");
    }

    private void rebuildIndex(String string, IPath iPath) {
        IProject iProject;
        Object object = Util.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), iPath, true);
        if (object == null) {
            return;
        }
        if (VERBOSE) {
            JobManager.verbose("-> request to rebuild index: " + string + " path: " + iPath.toOSString());
        }
        this.updateIndexState(string, REBUILDING_STATE);
        IndexAllProject indexAllProject = null;
        if (object instanceof IProject && (iProject = (IProject)object).exists() && this.isIndexEnabled(iProject)) {
            indexAllProject = new IndexAllProject(iProject, this);
        }
        if (indexAllProject != null) {
            this.request(indexAllProject);
        }
    }

    public synchronized IIndex recreateIndex(IPath iPath) {
        try {
            IIndex iIndex = (IIndex)this.indexes.get(iPath);
            ReadWriteMonitor readWriteMonitor = (ReadWriteMonitor)this.monitors.remove(iIndex);
            String string = this.computeIndexName(iPath);
            if (VERBOSE) {
                JobManager.verbose("-> recreating index: " + string + " for path: " + iPath.toOSString());
            }
            iIndex = new Index(string, "Index for " + iPath.toOSString(), false);
            this.indexes.put(iPath, iIndex);
            this.monitors.put(iIndex, readWriteMonitor);
            return iIndex;
        }
        catch (IOException iOException) {
            if (VERBOSE) {
                JobManager.verbose("-> failed to recreate index for path: " + iPath.toOSString());
                iOException.printStackTrace();
            }
            return null;
        }
    }

    public void remove(String string, IPath iPath) {
        IProject iProject = CCorePlugin.getWorkspace().getRoot().getProject(iPath.toString());
        if (this.isIndexEnabled(iProject)) {
            this.request(new RemoveFromIndex(string, iPath, this));
        }
    }

    public synchronized void removeIndex(IPath iPath) {
        Object v;
        String string;
        File file;
        if (VERBOSE) {
            JobManager.verbose("removing index " + iPath);
        }
        if ((file = new File(string = this.computeIndexName(iPath))).exists()) {
            file.delete();
        }
        if ((v = this.indexes.get(iPath)) instanceof IIndex) {
            this.monitors.remove(v);
        }
        this.indexes.remove(iPath);
        this.updateIndexState(string, null);
    }

    public synchronized void removeIndexFamily(IPath iPath) {
        ArrayList<IPath> arrayList = null;
        Iterator iterator = this.indexes.keySet().iterator();
        while (iterator.hasNext()) {
            IPath iPath2 = (IPath)iterator.next();
            if (!iPath.isPrefixOf(iPath2)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<IPath>();
            }
            arrayList.add(iPath2);
        }
        if (arrayList != null) {
            int n = 0;
            int n2 = arrayList.size();
            while (n < n2) {
                this.removeIndex((IPath)arrayList.get(n));
                ++n;
            }
        }
    }

    public void removeSourceFolderFromIndex(IProject iProject, IPath iPath, char[][] cArray) {
        if (!this.isIndexEnabled(iProject)) {
            return;
        }
        if (this.jobEnd > this.jobStart) {
            IndexAllProject indexAllProject = new IndexAllProject(iProject, this);
            int n = this.jobEnd;
            while (n > this.jobStart) {
                if (((Object)indexAllProject).equals(this.awaitingJobs[n])) {
                    return;
                }
                --n;
            }
        }
        this.request(new RemoveFolderFromIndex(iPath, cArray, iProject, this));
    }

    public void reset() {
        super.reset();
        if (this.indexes != null) {
            this.indexes = new HashMap(5);
            this.monitors = new HashMap(5);
            this.indexStates = null;
            this.encounteredHeaders = null;
        }
        if (this.timeoutThread == null) {
            this.timeoutThread = new ParserTimeOut("Indexer TimeOut Thread");
            this.timeoutThread.setThreadPriority(10);
            Preferences preferences = CCorePlugin.getDefault().getPluginPreferences();
            preferences.setDefault("CDT_INDEXER_TIMEOUT", 20000);
        }
        this.indexNames = new SimpleLookupTable();
        this.cCorePluginLocation = null;
        this.indexModelListener = IndexerModelListener.getDefault();
    }

    public void saveIndex(IIndex iIndex) throws IOException {
        Object object;
        if (iIndex.hasChanged()) {
            if (VERBOSE) {
                JobManager.verbose("-> saving index " + iIndex.getIndexFile());
            }
            iIndex.save();
        }
        String string = iIndex.getIndexFile().getPath();
        if (this.jobEnd > this.jobStart && (object = this.indexNames.keyForValue(string)) != null) {
            int n = this.jobEnd;
            while (n > this.jobStart) {
                IJob iJob = this.awaitingJobs[n];
                if (iJob instanceof IndexRequest && ((IndexRequest)iJob).indexPath.equals(object)) {
                    return;
                }
                --n;
            }
        }
        this.updateIndexState(string, SAVED_STATE);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveIndexes() {
        Object object;
        ArrayList arrayList = new ArrayList();
        IndexManager indexManager = this;
        synchronized (indexManager) {
            Iterator iterator = this.indexes.values().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!(object instanceof IIndex)) continue;
                arrayList.add(object);
            }
        }
        int n = 0;
        int n2 = arrayList.size();
        while (true) {
            if (n >= n2) {
                this.needToSave = false;
                return;
            }
            object = (IIndex)arrayList.get(n);
            ReadWriteMonitor readWriteMonitor = this.getMonitorFor((IIndex)object);
            if (readWriteMonitor != null) {
                Object var7_9;
                try {
                    readWriteMonitor.enterWrite();
                    try {
                        this.saveIndex((IIndex)object);
                    }
                    catch (IOException iOException) {
                        if (VERBOSE) {
                            JobManager.verbose("-> got the following exception while saving:");
                            iOException.printStackTrace();
                        }
                    }
                }
                catch (Throwable throwable) {
                    var7_9 = null;
                    readWriteMonitor.exitWrite();
                    throw throwable;
                }
                {
                    var7_9 = null;
                    readWriteMonitor.exitWrite();
                }
            }
            ++n;
        }
    }

    public void shutdown() {
        File[] fileArray;
        File file;
        if (VERBOSE) {
            JobManager.verbose("Shutdown");
        }
        IndexSelector indexSelector = new IndexSelector(new CWorkspaceScope(), null, false, this);
        IIndex[] iIndexArray = indexSelector.getIndexes();
        SimpleLookupTable simpleLookupTable = new SimpleLookupTable();
        int n = 0;
        int n2 = iIndexArray.length;
        while (n < n2) {
            String string = iIndexArray[n].getIndexFile().getAbsolutePath();
            simpleLookupTable.put(string, string);
            ++n;
        }
        if (this.indexStates != null) {
            Object[] objectArray = this.indexStates.keyTable;
            n2 = 0;
            int n3 = objectArray.length;
            while (n2 < n3) {
                String string = (String)objectArray[n2];
                if (string != null && !simpleLookupTable.containsKey(string)) {
                    this.updateIndexState(string, null);
                }
                ++n2;
            }
        }
        if ((file = new File(this.getCCorePluginWorkingLocation().toOSString())).isDirectory() && (fileArray = file.listFiles()) != null) {
            int n4 = 0;
            int n5 = fileArray.length;
            while (n4 < n5) {
                String string = fileArray[n4].getAbsolutePath();
                if (!simpleLookupTable.containsKey(string) && string.toLowerCase().endsWith(".index")) {
                    if (VERBOSE) {
                        JobManager.verbose("Deleting index file " + fileArray[n4]);
                    }
                    fileArray[n4].delete();
                }
                ++n4;
            }
        }
        this.indexModelListener.shutdown();
        this.timeoutThread = null;
        super.shutdown();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(super.toString());
        stringBuffer.append("In-memory indexes:\n");
        int n = 0;
        Iterator iterator = this.indexes.values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(++n).append(" - ").append(iterator.next().toString()).append('\n');
        }
        return stringBuffer.toString();
    }

    private char[] readIndexState() {
        try {
            return Util.getFileCharContent(this.savedIndexNamesFile, null);
        }
        catch (IOException iOException) {
            if (VERBOSE) {
                JobManager.verbose("Failed to read saved index file names");
            }
            return new char[0];
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateIndexState(String string, Integer n) {
        Object object;
        block22: {
            this.getIndexStates();
            if (n != null) {
                if (n.equals(this.indexStates.get(string))) {
                    return;
                }
                this.indexStates.put(string, n);
            } else {
                if (!this.indexStates.containsKey(string)) {
                    return;
                }
                this.indexStates.removeKey(string);
            }
            BufferedWriter bufferedWriter = null;
            try {
                try {
                    bufferedWriter = new BufferedWriter(new FileWriter(this.savedIndexNamesFile));
                    object = this.indexStates.keyTable;
                    Object[] objectArray = this.indexStates.valueTable;
                    int n2 = 0;
                    int n3 = objectArray.length;
                    while (n2 < n3) {
                        if (objectArray[n2] == SAVED_STATE) {
                            bufferedWriter.write((String)object[n2]);
                            bufferedWriter.write(10);
                        }
                        ++n2;
                    }
                }
                catch (IOException iOException) {
                    if (VERBOSE) {
                        JobManager.verbose("Failed to write saved index file names");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (bufferedWriter == null) throw throwable;
                try {
                    bufferedWriter.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var8_10 = null;
                if (bufferedWriter == null) break block22;
            }
            try {}
            catch (IOException iOException) {}
            bufferedWriter.close();
        }
        if (!VERBOSE) return;
        object = "?";
        if (n == SAVED_STATE) {
            object = "SAVED";
        } else if (n == UPDATING_STATE) {
            object = "UPDATING";
        } else if (n == UNKNOWN_STATE) {
            object = "UNKNOWN";
        } else if (n == REBUILDING_STATE) {
            object = "REBUILDING";
        }
        JobManager.verbose("-> index state updated to: " + (String)object + " for: " + string);
    }

    public ParserTimeOut getTimeout() {
        return this.timeoutThread;
    }

    protected void jobFinishedNotification(IJob iJob) {
        if (iJob instanceof AddCompilationUnitToIndex) {
            AddCompilationUnitToIndex addCompilationUnitToIndex = (AddCompilationUnitToIndex)iJob;
            this.jobSet.remove(addCompilationUnitToIndex.resource.getLocation());
        }
    }

    private Boolean loadIndexerEnabledFromCDescriptor(IProject iProject) throws CoreException {
        ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(iProject, false);
        Boolean bl = null;
        if (iCDescriptor != null) {
            Node node = iCDescriptor.getProjectData(CDT_INDEXER).getFirstChild();
            while (node != null) {
                if (node.getNodeName().equals(INDEXER_ENABLED)) {
                    bl = Boolean.valueOf(((Element)node).getAttribute(INDEXER_VALUE));
                }
                node = node.getNextSibling();
            }
        }
        return bl;
    }

    private Integer loadIndexerProblemsEnabledFromCDescriptor(IProject iProject) throws CoreException {
        ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(iProject, false);
        Integer n = null;
        if (iCDescriptor != null) {
            Node node = iCDescriptor.getProjectData(CDT_INDEXER).getFirstChild();
            while (node != null) {
                if (node.getNodeName().equals(INDEXER_PROBLEMS_ENABLED)) {
                    String string = ((Element)node).getAttribute(INDEXER_PROBLEMS_VALUE);
                    try {
                        n = Integer.valueOf(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Boolean bl = Boolean.valueOf(string);
                        if (bl.booleanValue()) {
                            n = new Integer(1);
                            break;
                        }
                        n = new Integer(0);
                    }
                    break;
                }
                node = node.getNextSibling();
            }
        }
        return n;
    }

    public void removeIndexerProblems(IResource iResource) {
        String string = "remove markers";
        RemoveIndexMarkersJob removeIndexMarkersJob = new RemoveIndexMarkersJob(iResource, string);
        removeIndexMarkersJob.setRule((ISchedulingRule)iResource);
        removeIndexMarkersJob.setPriority(50);
        removeIndexMarkersJob.schedule();
    }

    public void addIndexChangeListener(IIndexChangeListener iIndexChangeListener) {
        List list = this.indexChangeListeners;
        synchronized (list) {
            if (!this.indexChangeListeners.contains(iIndexChangeListener)) {
                this.indexChangeListeners.add(iIndexChangeListener);
            }
        }
    }

    public void removeIndexChangeListener(IIndexChangeListener iIndexChangeListener) {
        List list = this.indexChangeListeners;
        synchronized (list) {
            int n = this.indexChangeListeners.indexOf(iIndexChangeListener);
            if (n != -1) {
                this.indexChangeListeners.remove(n);
            }
        }
    }

    public void notifyListeners(IndexDelta indexDelta) {
        IndexChangeEvent indexChangeEvent = new IndexChangeEvent(indexDelta);
        int n = 0;
        while (n < this.indexChangeListeners.size()) {
            IIndexChangeListener iIndexChangeListener = null;
            Object object = this.indexChangeListeners;
            synchronized (object) {
                iIndexChangeListener = (IIndexChangeListener)this.indexChangeListeners.get(n);
            }
            object = iIndexChangeListener;
            long l = -1L;
            if (VERBOSE) {
                System.out.print("Listener #" + (n + 1) + "=" + object.toString());
                l = System.currentTimeMillis();
            }
            Job job = new Job(INDEX_NOTIFICATION_NAME, (IIndexChangeListener)object, indexChangeEvent){
                private final /* synthetic */ IIndexChangeListener val$listener;
                private final /* synthetic */ IndexChangeEvent val$indexEvent;
                {
                    this.val$listener = iIndexChangeListener;
                    this.val$indexEvent = indexChangeEvent;
                }

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    Platform.run((ISafeRunnable)new ISafeRunnable(this, this.val$listener, this.val$indexEvent){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ IIndexChangeListener val$listener;
                        private final /* synthetic */ IndexChangeEvent val$indexEvent;
                        {
                            this.this$1 = var1_1;
                            this.val$listener = iIndexChangeListener;
                            this.val$indexEvent = indexChangeEvent;
                        }

                        public void handleException(Throwable throwable) {
                            CCorePlugin.log(throwable);
                        }

                        public void run() throws Exception {
                            this.val$listener.indexChanged(this.val$indexEvent);
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            if (VERBOSE) {
                System.out.println(" -> " + (System.currentTimeMillis() - l) + "ms");
            }
            ++n;
        }
    }

    private static class RemoveIndexMarkersJob
    extends Job {
        private final IResource resource;

        public RemoveIndexMarkersJob(IResource iResource, String string) {
            super(string);
            this.resource = iResource;
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            try {
                this.resource.deleteMarkers("org.eclipse.cdt.core.indexermarker", true, 2);
            }
            catch (CoreException coreException) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }
}

