/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.indexing;

import java.io.IOException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.processing.IJob;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public abstract class IndexRequest
implements IJob {
    protected boolean isCancelled = false;
    protected IPath indexPath;
    protected IndexManager manager;

    public IndexRequest(IPath iPath, IndexManager indexManager) {
        this.indexPath = iPath;
        this.manager = indexManager;
    }

    public boolean belongsTo(String string) {
        return string.equals(this.indexPath.segment(0));
    }

    public void cancel() {
        this.manager.jobFinishedNotification(this);
        this.manager.jobWasCancelled(this.indexPath);
        this.isCancelled = true;
    }

    public boolean isReadyToRun() {
        IProject iProject = CCorePlugin.getWorkspace().getRoot().getProject(this.indexPath.segment(0));
        if (!iProject.isAccessible() || !this.manager.isIndexEnabled(iProject)) {
            return false;
        }
        this.manager.aboutToUpdateIndex(this.indexPath, this.updatedIndexState());
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void saveIfNecessary(IIndex iIndex, ReadWriteMonitor readWriteMonitor) throws IOException {
        if (!iIndex.hasChanged()) return;
        try {
            readWriteMonitor.exitRead();
            readWriteMonitor.enterWrite();
            this.manager.saveIndex(iIndex);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            readWriteMonitor.exitWriteEnterRead();
            throw throwable;
        }
        {
            Object var3_5 = null;
            readWriteMonitor.exitWriteEnterRead();
            return;
        }
    }

    protected Integer updatedIndexState() {
        return IndexManager.UPDATING_STATE;
    }
}

