/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.indexing;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.internal.core.model.SourceRoot;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class IndexerModelListener
implements IElementChangedListener {
    private static IndexerModelListener indexerModelListener;
    private static IndexManager indexManager;

    private IndexerModelListener() {
    }

    public static synchronized IndexerModelListener getDefault() {
        if (indexerModelListener == null) {
            indexerModelListener = new IndexerModelListener();
            CoreModel.getDefault().addElementChangedListener(indexerModelListener);
            indexManager = CoreModel.getDefault().getIndexManager();
        }
        return indexerModelListener;
    }

    public void elementChanged(ElementChangedEvent elementChangedEvent) {
        try {
            this.processDelta(elementChangedEvent.getDelta());
        }
        catch (CModelException cModelException) {}
    }

    protected void processDelta(ICElementDelta iCElementDelta) throws CModelException {
        IResource iResource;
        int n = iCElementDelta.getKind();
        int n2 = iCElementDelta.getFlags();
        ICElement iCElement = iCElementDelta.getElement();
        switch (n) {
            case 4: {
                SourceRoot sourceRoot;
                if ((n2 & 0x800) != 0 || (n2 & 0x400) != 0 || (n2 & 0x100) != 0) {
                    iResource = iCElement.getResource();
                    sourceRoot = null;
                    if (iResource == null) {
                        return;
                    }
                    switch (iResource.getType()) {
                        case 1: {
                            indexManager.addSource((IFile)iResource, iResource.getProject().getFullPath(), false);
                            break;
                        }
                        case 2: {
                            sourceRoot = (SourceRoot)this.getElementSource(iCElement);
                            if (sourceRoot == null) break;
                            IProject iProject = iResource.getProject();
                            indexManager.indexSourceFolder(iProject, iResource.getFullPath(), sourceRoot.getSourceEntry().fullExclusionPatternChars());
                            break;
                        }
                        case 4: {
                            indexManager.indexAll(iResource.getProject());
                        }
                    }
                    break;
                }
                if ((n2 & 0x200) == 0 || indexManager.indexProblemsEnabled((IProject)(sourceRoot = (iResource = iCElement.getResource()).getProject())) == 0) break;
                indexManager.removeIndexerProblems(iResource);
            }
        }
        iResource = iCElementDelta.getAffectedChildren();
        int n3 = 0;
        while (n3 < ((IResource)iResource).length) {
            this.processDelta((ICElementDelta)iResource[n3]);
            ++n3;
        }
    }

    ICElement getElementSource(ICElement iCElement) {
        if (iCElement instanceof SourceRoot) {
            return iCElement;
        }
        if (iCElement.getParent() != null) {
            return this.getElementSource(iCElement.getParent());
        }
        return null;
    }

    public void shutdown() {
        if (indexerModelListener != null) {
            CoreModel.getDefault().removeElementChangedListener(indexerModelListener);
        }
    }
}

