/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.indexing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserTimeOut;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ast.IASTASMDefinition;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassReference;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationReference;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTEnumeratorReference;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFieldReference;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTFunctionReference;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTLinkageSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTMethodReference;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceReference;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTParameterReference;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateInstantiation;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameterReference;
import org.eclipse.cdt.core.parser.ast.IASTTemplateSpecialization;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTypedefReference;
import org.eclipse.cdt.core.parser.ast.IASTUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.ast.IASTVariableReference;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.IndexProblemHandler;
import org.eclipse.cdt.internal.core.search.indexing.SourceIndexer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class SourceIndexerRequestor
implements ISourceElementRequestor,
IIndexConstants {
    SourceIndexer indexer;
    IFile resourceFile;
    char[] packageName;
    char[][] enclosingTypeNames = new char[5][];
    int depth = 0;
    int methodDepth = 0;
    private IASTInclusion currentInclude = null;
    private LinkedList includeStack = new LinkedList();
    private int problemMarkersEnabled = 0;
    private Map problemsMap = null;
    private IProgressMonitor pm = new NullProgressMonitor();
    private ParserTimeOut timeoutThread = null;
    private static final String INDEXER_MARKER_ORIGINATOR = "org.eclipse.cdt.core.indexermarker.originator";
    private static final String INDEXER_MARKER_PREFIX = String.valueOf(Util.bind("indexerMarker.prefix")) + " ";
    private static final String INDEXER_MARKER_PROCESSING = Util.bind("indexerMarker.processing");
    private ArrayList filesTraversed = null;
    private IParser parser;

    public SourceIndexerRequestor(SourceIndexer sourceIndexer, IFile iFile, ParserTimeOut parserTimeOut) {
        this.indexer = sourceIndexer;
        this.resourceFile = iFile;
        this.timeoutThread = parserTimeOut;
        this.filesTraversed = new ArrayList(15);
        this.filesTraversed.add(iFile.getLocation().toOSString());
    }

    public boolean acceptProblem(IProblem iProblem) {
        if (this.areProblemMarkersEnabled() && this.shouldRecordProblem(iProblem)) {
            Object object;
            IASTInclusion iASTInclusion = this.peekInclude();
            IFile iFile = this.resourceFile;
            if (iASTInclusion != null) {
                object = new Path(iASTInclusion.getFullFileName());
                iFile = CCorePlugin.getWorkspace().getRoot().getFileForLocation((IPath)object);
            }
            if (iFile != null) {
                object = new AddMarkerProblem(iFile, this.resourceFile, iProblem);
                if (this.problemsMap.containsKey(iFile)) {
                    List list = (List)this.problemsMap.get(iFile);
                    list.add(object);
                } else {
                    ArrayList<RemoveMarkerProblem> arrayList = new ArrayList<RemoveMarkerProblem>();
                    arrayList.add(new RemoveMarkerProblem(iFile, this.resourceFile));
                    arrayList.add((RemoveMarkerProblem)object);
                    this.problemsMap.put(iFile, arrayList);
                }
            }
        }
        return IndexProblemHandler.ruleOnProblem(iProblem, ParserMode.COMPLETE_PARSE);
    }

    public void acceptMacro(IASTMacro iASTMacro) {
        this.indexer.addMacro(iASTMacro);
    }

    public void acceptVariable(IASTVariable iASTVariable) {
        this.indexer.addVariable(iASTVariable);
    }

    public void acceptFunctionDeclaration(IASTFunction iASTFunction) {
        this.indexer.addFunctionDeclaration(iASTFunction);
    }

    public void acceptUsingDirective(IASTUsingDirective iASTUsingDirective) {
    }

    public void acceptUsingDeclaration(IASTUsingDeclaration iASTUsingDeclaration) {
    }

    public void acceptASMDefinition(IASTASMDefinition iASTASMDefinition) {
    }

    public void acceptTypedefDeclaration(IASTTypedefDeclaration iASTTypedefDeclaration) {
        this.indexer.addTypedefDeclaration(iASTTypedefDeclaration);
    }

    public void acceptEnumerationSpecifier(IASTEnumerationSpecifier iASTEnumerationSpecifier) {
        this.indexer.addEnumerationSpecifier(iASTEnumerationSpecifier);
    }

    public void enterFunctionBody(IASTFunction iASTFunction) {
        this.indexer.addFunctionDeclaration(iASTFunction);
    }

    public void exitFunctionBody(IASTFunction iASTFunction) {
    }

    public void enterCompilationUnit(IASTCompilationUnit iASTCompilationUnit) {
    }

    public void enterInclusion(IASTInclusion iASTInclusion) {
        IFile iFile;
        IASTInclusion iASTInclusion2;
        if (this.areProblemMarkersEnabled()) {
            iASTInclusion2 = new Path(iASTInclusion.getFullFileName());
            iFile = CCorePlugin.getWorkspace().getRoot().getFileForLocation((IPath)iASTInclusion2);
            if (iFile != null) {
                this.requestRemoveMarkers(iFile, this.resourceFile);
            }
        }
        iASTInclusion2 = this.peekInclude();
        this.indexer.addInclude(iASTInclusion, iASTInclusion2);
        this.pushInclude(iASTInclusion);
        this.filesTraversed.add(iASTInclusion.getFullFileName());
        iFile = this.resourceFile.getProject();
        ICFileType iCFileType = CCorePlugin.getDefault().getFileType((IProject)iFile, iASTInclusion.getFullFileName());
        if (iCFileType.isHeader()) {
            CCorePlugin.getDefault().getCoreModel().getIndexManager().haveEncounteredHeader(iFile.getFullPath(), (IPath)new Path(iASTInclusion.getFullFileName()));
        }
    }

    public void enterNamespaceDefinition(IASTNamespaceDefinition iASTNamespaceDefinition) {
        this.indexer.addNamespaceDefinition(iASTNamespaceDefinition);
    }

    public void enterClassSpecifier(IASTClassSpecifier iASTClassSpecifier) {
    }

    public void enterLinkageSpecification(IASTLinkageSpecification iASTLinkageSpecification) {
    }

    public void enterTemplateDeclaration(IASTTemplateDeclaration iASTTemplateDeclaration) {
    }

    public void enterTemplateSpecialization(IASTTemplateSpecialization iASTTemplateSpecialization) {
    }

    public void enterTemplateInstantiation(IASTTemplateInstantiation iASTTemplateInstantiation) {
    }

    public void acceptMethodDeclaration(IASTMethod iASTMethod) {
        this.indexer.addMethodDeclaration(iASTMethod);
    }

    public void enterMethodBody(IASTMethod iASTMethod) {
        this.indexer.addMethodDeclaration(iASTMethod);
    }

    public void exitMethodBody(IASTMethod iASTMethod) {
    }

    public void acceptField(IASTField iASTField) {
        this.indexer.addFieldDeclaration(iASTField);
    }

    public void acceptClassReference(IASTClassReference iASTClassReference) {
        if (iASTClassReference.getReferencedElement() instanceof IASTClassSpecifier) {
            this.indexer.addClassReference((IASTClassSpecifier)iASTClassReference.getReferencedElement());
        } else if (iASTClassReference.getReferencedElement() instanceof IASTElaboratedTypeSpecifier) {
            this.indexer.addForwardClassReference((IASTTypeSpecifier)((Object)iASTClassReference.getReferencedElement()));
        }
    }

    public void exitTemplateDeclaration(IASTTemplateDeclaration iASTTemplateDeclaration) {
    }

    public void exitTemplateSpecialization(IASTTemplateSpecialization iASTTemplateSpecialization) {
    }

    public void exitTemplateExplicitInstantiation(IASTTemplateInstantiation iASTTemplateInstantiation) {
    }

    public void exitLinkageSpecification(IASTLinkageSpecification iASTLinkageSpecification) {
    }

    public void exitClassSpecifier(IASTClassSpecifier iASTClassSpecifier) {
        this.indexer.addClassSpecifier(iASTClassSpecifier);
    }

    public void exitNamespaceDefinition(IASTNamespaceDefinition iASTNamespaceDefinition) {
    }

    public void exitInclusion(IASTInclusion iASTInclusion) {
        this.popInclude();
    }

    public void exitCompilationUnit(IASTCompilationUnit iASTCompilationUnit) {
    }

    public void acceptAbstractTypeSpecDeclaration(IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration) {
    }

    public void acceptTypedefReference(IASTTypedefReference iASTTypedefReference) {
        if (iASTTypedefReference.getReferencedElement() instanceof IASTTypedefDeclaration) {
            this.indexer.addTypedefReference((IASTTypedefDeclaration)iASTTypedefReference.getReferencedElement());
        }
    }

    public void acceptNamespaceReference(IASTNamespaceReference iASTNamespaceReference) {
        if (iASTNamespaceReference.getReferencedElement() instanceof IASTNamespaceDefinition) {
            this.indexer.addNamespaceReference((IASTNamespaceDefinition)iASTNamespaceReference.getReferencedElement());
        }
    }

    public void acceptEnumerationReference(IASTEnumerationReference iASTEnumerationReference) {
        if (iASTEnumerationReference.getReferencedElement() instanceof IASTEnumerationSpecifier) {
            this.indexer.addEnumerationReference((IASTEnumerationSpecifier)iASTEnumerationReference.getReferencedElement());
        }
    }

    public void acceptVariableReference(IASTVariableReference iASTVariableReference) {
        if (iASTVariableReference.getReferencedElement() instanceof IASTVariable) {
            this.indexer.addVariableReference((IASTVariable)iASTVariableReference.getReferencedElement());
        }
    }

    public void acceptFunctionReference(IASTFunctionReference iASTFunctionReference) {
        if (iASTFunctionReference.getReferencedElement() instanceof IASTFunction) {
            this.indexer.addFunctionReference((IASTFunction)iASTFunctionReference.getReferencedElement());
        }
    }

    public void acceptFieldReference(IASTFieldReference iASTFieldReference) {
        if (iASTFieldReference.getReferencedElement() instanceof IASTField) {
            this.indexer.addFieldReference((IASTField)iASTFieldReference.getReferencedElement());
        }
    }

    public void acceptMethodReference(IASTMethodReference iASTMethodReference) {
        if (iASTMethodReference.getReferencedElement() instanceof IASTMethod) {
            this.indexer.addMethodReference((IASTMethod)iASTMethodReference.getReferencedElement());
        }
    }

    public void acceptElaboratedForewardDeclaration(IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier) {
        this.indexer.addElaboratedForwardDeclaration(iASTElaboratedTypeSpecifier);
    }

    public void enterCodeBlock(IASTCodeScope iASTCodeScope) {
    }

    public void exitCodeBlock(IASTCodeScope iASTCodeScope) {
    }

    public void acceptEnumeratorReference(IASTEnumeratorReference iASTEnumeratorReference) {
        if (iASTEnumeratorReference.getReferencedElement() instanceof IASTEnumerator) {
            this.indexer.addEnumeratorReference((IASTEnumerator)iASTEnumeratorReference.getReferencedElement());
        }
    }

    public void acceptParameterReference(IASTParameterReference iASTParameterReference) {
        if (iASTParameterReference.getReferencedElement() instanceof IASTParameterDeclaration) {
            this.indexer.addParameterReference((IASTParameterDeclaration)iASTParameterReference.getReferencedElement());
        }
    }

    public void acceptTemplateParameterReference(IASTTemplateParameterReference iASTTemplateParameterReference) {
        boolean cfr_ignored_0 = iASTTemplateParameterReference.getReferencedElement() instanceof IASTTemplateParameterReference;
    }

    public void acceptFriendDeclaration(IASTDeclaration iASTDeclaration) {
    }

    private void pushInclude(IASTInclusion iASTInclusion) {
        this.includeStack.addFirst(this.currentInclude);
        this.currentInclude = iASTInclusion;
    }

    private IASTInclusion popInclude() {
        IASTInclusion iASTInclusion = this.currentInclude;
        this.currentInclude = this.includeStack.size() > 0 ? (IASTInclusion)this.includeStack.removeFirst() : null;
        return iASTInclusion;
    }

    private IASTInclusion peekInclude() {
        return this.currentInclude;
    }

    public CodeReader createReader(String string, Iterator iterator) {
        return ParserUtil.createReader(string, iterator);
    }

    protected void processMarkers(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Problem problem = (Problem)iterator.next();
            if (problem.isAddProblem()) {
                this.addMarkers(problem.file, problem.originator, problem.getIProblem());
                continue;
            }
            this.removeMarkers(problem.file, problem.originator);
        }
    }

    public void removeMarkers(IFile iFile, IFile iFile2) {
        IMarker[] iMarkerArray;
        if (iFile2 == null) {
            try {
                iFile.deleteMarkers("org.eclipse.cdt.core.indexermarker", true, 2);
            }
            catch (CoreException coreException) {}
            return;
        }
        try {
            iMarkerArray = iFile.findMarkers("org.eclipse.cdt.core.indexermarker", true, 2);
        }
        catch (CoreException coreException) {
            return;
        }
        String string = iFile2.getFullPath().toString();
        IMarker iMarker = null;
        String string2 = null;
        int n = 0;
        while (n < iMarkerArray.length) {
            iMarker = iMarkerArray[n];
            try {
                string2 = (String)iMarker.getAttribute(INDEXER_MARKER_ORIGINATOR);
                if (string2 != null && string2.equals(string)) {
                    iMarker.delete();
                }
            }
            catch (CoreException coreException) {}
            ++n;
        }
    }

    private void addMarkers(IFile iFile, IFile iFile2, IProblem iProblem) {
        try {
            IMarker iMarker;
            IMarker[] iMarkerArray = iFile.findMarkers("org.eclipse.cdt.core.indexermarker", true, 0);
            boolean bl = true;
            if (iMarkerArray.length > 0) {
                iMarker = null;
                Integer n = null;
                String string = null;
                int n2 = 0;
                while (n2 < iMarkerArray.length) {
                    iMarker = iMarkerArray[n2];
                    n = (Integer)iMarker.getAttribute("lineNumber");
                    string = (String)iMarker.getAttribute("message");
                    if (n.intValue() == iProblem.getSourceLineNumber() && string.equalsIgnoreCase(String.valueOf(INDEXER_MARKER_PREFIX) + iProblem.getMessage())) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
            }
            if (bl) {
                iMarker = iFile.createMarker("org.eclipse.cdt.core.indexermarker");
                int n = iProblem.getSourceStart();
                int n3 = iProblem.getSourceEnd();
                if (n3 <= n) {
                    n3 = n + 1;
                }
                iMarker.setAttribute("location", iProblem.getSourceLineNumber());
                iMarker.setAttribute("message", (Object)(String.valueOf(INDEXER_MARKER_PREFIX) + iProblem.getMessage()));
                iMarker.setAttribute("severity", 1);
                iMarker.setAttribute("lineNumber", iProblem.getSourceLineNumber());
                iMarker.setAttribute("charStart", n);
                iMarker.setAttribute("charEnd", n3);
                iMarker.setAttribute(INDEXER_MARKER_ORIGINATOR, (Object)iFile2.getFullPath().toString());
            }
        }
        catch (CoreException coreException) {}
    }

    public void setParser(IParser iParser) {
        this.parser = iParser;
    }

    public void setTimeout(int n) {
        this.timeoutThread.setTimeout(n);
    }

    public void startTimer() {
        this.createProgressMonitor(this.parser);
        while (!this.timeoutThread.isReadyToRun()) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.timeoutThread.startTimer();
    }

    public void stopTimer() {
        this.timeoutThread.stopTimer();
        this.pm.setCanceled(false);
    }

    public boolean parserTimeout() {
        return this.pm != null && this.pm.isCanceled();
    }

    private void createProgressMonitor(IParser iParser) {
        this.pm.setCanceled(false);
        this.timeoutThread.setParser(iParser);
    }

    public boolean areProblemMarkersEnabled() {
        return this.problemMarkersEnabled != 0;
    }

    public void setProblemMarkersEnabled(int n) {
        if (n != 0) {
            this.problemsMap = new HashMap();
        }
        this.problemMarkersEnabled = n;
    }

    public void reportProblems() {
        if (!this.areProblemMarkersEnabled()) {
            return;
        }
        Iterator iterator = this.problemsMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            IFile iFile = (IFile)iterator.next();
            List list = (List)this.problemsMap.get(iFile);
            if (list.size() <= 1) {
                try {
                    object = iFile.findMarkers("org.eclipse.cdt.core.indexermarker", true, 0);
                }
                catch (CoreException coreException) {
                    continue;
                }
                if (((IMarker[])object).length == 0) continue;
            }
            object = INDEXER_MARKER_PROCESSING;
            object = String.valueOf(object) + " (";
            object = String.valueOf(object) + iFile.getFullPath();
            object = String.valueOf(object) + ')';
            ProcessMarkersJob processMarkersJob = new ProcessMarkersJob(iFile, list, (String)object);
            IndexManager indexManager = CCorePlugin.getDefault().getCoreModel().getIndexManager();
            IProgressMonitor iProgressMonitor = indexManager.getIndexJobProgressGroup();
            processMarkersJob.setRule((ISchedulingRule)iFile);
            if (iProgressMonitor != null) {
                processMarkersJob.setProgressGroup(iProgressMonitor, 0);
            }
            processMarkersJob.setPriority(50);
            processMarkersJob.schedule();
        }
    }

    public boolean shouldRecordProblem(IProblem iProblem) {
        boolean bl;
        if (iProblem.getSourceLineNumber() == -1) {
            return false;
        }
        boolean bl2 = (this.problemMarkersEnabled & 1) != 0;
        boolean bl3 = (this.problemMarkersEnabled & 2) != 0;
        boolean bl4 = bl = (this.problemMarkersEnabled & 4) != 0;
        if (iProblem.checkCategory(0x2000000)) {
            return bl2 && iProblem.getID() != 0x200000B;
        }
        if (iProblem.checkCategory(0x8000000)) {
            return bl3;
        }
        if (iProblem.checkCategory(0x4000000)) {
            return bl;
        }
        return false;
    }

    public void requestRemoveMarkers(IFile iFile, IFile iFile2) {
        if (!this.areProblemMarkersEnabled()) {
            return;
        }
        RemoveMarkerProblem removeMarkerProblem = new RemoveMarkerProblem(iFile, iFile2);
        if (this.problemsMap.containsKey(iFile)) {
            List list = (List)this.problemsMap.get(iFile);
            list.clear();
            list.add(removeMarkerProblem);
        } else {
            ArrayList<RemoveMarkerProblem> arrayList = new ArrayList<RemoveMarkerProblem>();
            arrayList.add(removeMarkerProblem);
            this.problemsMap.put(iFile, arrayList);
        }
    }

    public ArrayList getFilesTraversed() {
        return this.filesTraversed;
    }

    private class ProcessMarkersJob
    extends Job {
        protected final List problems;
        private final IFile resource;

        public ProcessMarkersJob(IFile iFile, List list, String string) {
            super(string);
            this.problems = list;
            this.resource = iFile;
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(this){
                final /* synthetic */ ProcessMarkersJob this$1;
                {
                    this.this$1 = processMarkersJob;
                }

                public void run(IProgressMonitor iProgressMonitor) {
                    ProcessMarkersJob.access$0(this.this$1).processMarkers(this.this$1.problems);
                }
            };
            try {
                CCorePlugin.getWorkspace().run(iWorkspaceRunnable, (ISchedulingRule)this.resource, 0, null);
            }
            catch (CoreException coreException) {}
            return Status.OK_STATUS;
        }

        static /* synthetic */ SourceIndexerRequestor access$0(ProcessMarkersJob processMarkersJob) {
            return processMarkersJob.SourceIndexerRequestor.this;
        }
    }

    private abstract class Problem {
        public IFile file;
        public IFile originator;

        public Problem(IFile iFile, IFile iFile2) {
            this.file = iFile;
            this.originator = iFile2;
        }

        public abstract boolean isAddProblem();

        public abstract IProblem getIProblem();
    }

    private class AddMarkerProblem
    extends Problem {
        private IProblem problem;

        public AddMarkerProblem(IFile iFile, IFile iFile2, IProblem iProblem) {
            super(iFile, iFile2);
            this.problem = iProblem;
        }

        public boolean isAddProblem() {
            return true;
        }

        public IProblem getIProblem() {
            return this.problem;
        }
    }

    private class RemoveMarkerProblem
    extends Problem {
        public RemoveMarkerProblem(IFile iFile, IFile iFile2) {
            super(iFile, iFile2);
        }

        public boolean isAddProblem() {
            return false;
        }

        public IProblem getIProblem() {
            return null;
        }
    }
}

