/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.IQuickParseCallback;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerException;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.ASTUtil;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.OrPattern;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.impl.BlocksIndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.cdt.internal.core.search.matching.ClassDeclarationPattern;
import org.eclipse.cdt.internal.core.search.matching.DerivedTypesPattern;
import org.eclipse.cdt.internal.core.search.matching.FieldDeclarationPattern;
import org.eclipse.cdt.internal.core.search.matching.FriendPattern;
import org.eclipse.cdt.internal.core.search.matching.IncludePattern;
import org.eclipse.cdt.internal.core.search.matching.MacroDeclarationPattern;
import org.eclipse.cdt.internal.core.search.matching.MethodDeclarationPattern;
import org.eclipse.cdt.internal.core.search.matching.NamespaceDeclarationPattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public abstract class CSearchPattern
implements ICSearchConstants,
ICSearchPattern,
IIndexConstants {
    public static final int IMPOSSIBLE_MATCH = 0;
    public static final int POSSIBLE_MATCH = 1;
    public static final int ACCURATE_MATCH = 2;
    public static final int INACCURATE_MATCH = 3;
    private static final IParserLogService nullLog = new NullLogService();
    protected int _matchMode;
    protected boolean _caseSensitive;
    protected ICSearchConstants.LimitTo _limitTo;

    public CSearchPattern(int n, boolean bl, ICSearchConstants.LimitTo limitTo) {
        this._matchMode = n;
        this._caseSensitive = bl;
        this._limitTo = limitTo;
    }

    public CSearchPattern() {
    }

    public ICSearchConstants.LimitTo getLimitTo() {
        return this._limitTo;
    }

    public boolean canAccept(ICSearchConstants.LimitTo limitTo) {
        return limitTo == this.getLimitTo();
    }

    public static CSearchPattern createPattern(String string, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int n, boolean bl) {
        if (string == null || string.length() == 0) {
            return null;
        }
        CSearchPattern cSearchPattern = null;
        if (searchFor == ICSearchConstants.TYPE || searchFor == ICSearchConstants.CLASS || searchFor == ICSearchConstants.STRUCT || searchFor == ICSearchConstants.FWD_CLASS || searchFor == ICSearchConstants.FWD_STRUCT || searchFor == ICSearchConstants.FWD_UNION || searchFor == ICSearchConstants.ENUM || searchFor == ICSearchConstants.UNION || searchFor == ICSearchConstants.CLASS_STRUCT || searchFor == ICSearchConstants.TYPEDEF) {
            cSearchPattern = CSearchPattern.createClassPattern(string, searchFor, limitTo, n, bl);
        } else if (searchFor == ICSearchConstants.DERIVED) {
            cSearchPattern = CSearchPattern.createDerivedPattern(string, searchFor, limitTo, n, bl);
        } else if (searchFor == ICSearchConstants.FRIEND) {
            cSearchPattern = CSearchPattern.createFriendPattern(string, searchFor, limitTo, n, bl);
        } else if (searchFor == ICSearchConstants.METHOD || searchFor == ICSearchConstants.FUNCTION) {
            cSearchPattern = CSearchPattern.createMethodPattern(string, searchFor, limitTo, n, bl);
        } else if (searchFor == ICSearchConstants.FIELD || searchFor == ICSearchConstants.VAR || searchFor == ICSearchConstants.ENUMTOR) {
            cSearchPattern = CSearchPattern.createFieldPattern(string, searchFor, limitTo, n, bl);
        } else if (searchFor == ICSearchConstants.NAMESPACE) {
            cSearchPattern = CSearchPattern.createNamespacePattern(string, limitTo, n, bl);
        } else if (searchFor == ICSearchConstants.MACRO) {
            cSearchPattern = CSearchPattern.createMacroPattern(string, limitTo, n, bl);
        } else if (searchFor == ICSearchConstants.INCLUDE) {
            cSearchPattern = CSearchPattern.createIncludePattern(string, limitTo, n, bl);
        }
        return cSearchPattern;
    }

    private static CSearchPattern createIncludePattern(String string, ICSearchConstants.LimitTo limitTo, int n, boolean bl) {
        if (limitTo != ICSearchConstants.REFERENCES) {
            return null;
        }
        return new IncludePattern(string.toCharArray(), n, limitTo, bl);
    }

    private static CSearchPattern createMacroPattern(String string, ICSearchConstants.LimitTo limitTo, int n, boolean bl) {
        if (limitTo != ICSearchConstants.DECLARATIONS && limitTo != ICSearchConstants.ALL_OCCURRENCES) {
            return null;
        }
        return new MacroDeclarationPattern(string.toCharArray(), n, ICSearchConstants.DECLARATIONS, bl);
    }

    private static CSearchPattern createNamespacePattern(String string, ICSearchConstants.LimitTo limitTo, int n, boolean bl) {
        if (limitTo == ICSearchConstants.ALL_OCCURRENCES) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createNamespacePattern(string, ICSearchConstants.DECLARATIONS, n, bl));
            orPattern.addPattern(CSearchPattern.createNamespacePattern(string, ICSearchConstants.DEFINITIONS, n, bl));
            orPattern.addPattern(CSearchPattern.createNamespacePattern(string, ICSearchConstants.REFERENCES, n, bl));
            return orPattern;
        }
        char[] cArray = string.toCharArray();
        IScanner iScanner = null;
        Requestor requestor = new Requestor(ParserMode.COMPLETE_PARSE);
        try {
            iScanner = ParserFactory.createScanner(new CodeReader(cArray), (IScannerInfo)new ScannerInfo(), ParserMode.QUICK_PARSE, ParserLanguage.CPP, (ISourceElementRequestor)requestor, nullLog, null);
        }
        catch (ParserFactoryError parserFactoryError) {}
        LinkedList linkedList = CSearchPattern.scanForNames(iScanner, requestor, null, cArray);
        char[] cArray2 = (char[])linkedList.removeLast();
        char[][] cArray3 = new char[][]{};
        return new NamespaceDeclarationPattern(cArray2, (char[][])linkedList.toArray((T[])cArray3), n, limitTo, bl);
    }

    private static CSearchPattern createFieldPattern(String string, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int n, boolean bl) {
        if (limitTo == ICSearchConstants.ALL_OCCURRENCES) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createFieldPattern(string, searchFor, ICSearchConstants.DECLARATIONS, n, bl));
            orPattern.addPattern(CSearchPattern.createFieldPattern(string, searchFor, ICSearchConstants.REFERENCES, n, bl));
            orPattern.addPattern(CSearchPattern.createFieldPattern(string, searchFor, ICSearchConstants.DEFINITIONS, n, bl));
            return orPattern;
        }
        char[] cArray = string.toCharArray();
        Requestor requestor = new Requestor(ParserMode.COMPLETE_PARSE);
        IScanner iScanner = null;
        try {
            iScanner = ParserFactory.createScanner(new CodeReader(cArray), (IScannerInfo)new ScannerInfo(), ParserMode.QUICK_PARSE, ParserLanguage.CPP, (ISourceElementRequestor)requestor, nullLog, null);
        }
        catch (ParserFactoryError parserFactoryError) {}
        LinkedList linkedList = CSearchPattern.scanForNames(iScanner, requestor, null, cArray);
        char[] cArray2 = (char[])linkedList.removeLast();
        char[][] cArray3 = new char[][]{};
        return new FieldDeclarationPattern(cArray2, (char[][])linkedList.toArray((T[])cArray3), n, searchFor, limitTo, bl);
    }

    private static CSearchPattern createMethodPattern(String string, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int n, boolean bl) {
        if (limitTo == ICSearchConstants.ALL_OCCURRENCES) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createMethodPattern(string, searchFor, ICSearchConstants.DECLARATIONS, n, bl));
            orPattern.addPattern(CSearchPattern.createMethodPattern(string, searchFor, ICSearchConstants.REFERENCES, n, bl));
            orPattern.addPattern(CSearchPattern.createMethodPattern(string, searchFor, ICSearchConstants.DEFINITIONS, n, bl));
            return orPattern;
        }
        int n2 = string.indexOf(40);
        String string2 = n2 == -1 ? "" : string.substring(n2);
        String string3 = n2 == -1 ? string : string.substring(0, n2);
        char[] cArray = string3.toCharArray();
        IScanner iScanner = null;
        Requestor requestor = new Requestor(ParserMode.COMPLETE_PARSE);
        try {
            iScanner = ParserFactory.createScanner(new CodeReader(cArray), (IScannerInfo)new ScannerInfo(), ParserMode.QUICK_PARSE, ParserLanguage.CPP, (ISourceElementRequestor)requestor, nullLog, null);
        }
        catch (ParserFactoryError parserFactoryError) {}
        LinkedList linkedList = CSearchPattern.scanForNames(iScanner, requestor, null, cArray);
        LinkedList linkedList2 = CSearchPattern.scanForParameters(string2);
        char[] cArray2 = (char[])linkedList.removeLast();
        char[][] cArray3 = new char[][]{};
        cArray3 = (char[][])linkedList.toArray((T[])cArray3);
        char[][] cArray4 = new char[][]{};
        cArray4 = (char[][])linkedList2.toArray((T[])cArray4);
        return new MethodDeclarationPattern(cArray2, cArray3, cArray4, n, searchFor, limitTo, bl);
    }

    private static CSearchPattern createClassPattern(String string, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int n, boolean bl) {
        if (limitTo == ICSearchConstants.ALL_OCCURRENCES) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createClassPattern(string, searchFor, ICSearchConstants.DECLARATIONS, n, bl));
            orPattern.addPattern(CSearchPattern.createClassPattern(string, searchFor, ICSearchConstants.REFERENCES, n, bl));
            return orPattern;
        }
        if (searchFor == ICSearchConstants.CLASS_STRUCT) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createClassPattern(string, ICSearchConstants.CLASS, limitTo, n, bl));
            orPattern.addPattern(CSearchPattern.createClassPattern(string, ICSearchConstants.STRUCT, limitTo, n, bl));
            return orPattern;
        }
        boolean bl2 = false;
        if (searchFor == ICSearchConstants.FWD_CLASS || searchFor == ICSearchConstants.FWD_STRUCT || searchFor == ICSearchConstants.FWD_UNION) {
            bl2 = true;
        }
        char[] cArray = string.toCharArray();
        IScanner iScanner = null;
        Requestor requestor = new Requestor(ParserMode.COMPLETE_PARSE);
        try {
            iScanner = ParserFactory.createScanner(new CodeReader(cArray), (IScannerInfo)new ScannerInfo(), ParserMode.QUICK_PARSE, ParserLanguage.CPP, (ISourceElementRequestor)requestor, nullLog, null);
        }
        catch (ParserFactoryError parserFactoryError) {}
        IToken iToken = null;
        try {
            iToken = iScanner.nextToken();
        }
        catch (EndOfFileException endOfFileException) {
        }
        catch (ScannerException scannerException) {}
        if (iToken != null) {
            boolean bl3 = true;
            if (iToken.getType() == 65) {
                searchFor = ICSearchConstants.CLASS;
            } else if (iToken.getType() == 109) {
                searchFor = ICSearchConstants.STRUCT;
            } else if (iToken.getType() == 119) {
                searchFor = ICSearchConstants.UNION;
            } else if (iToken.getType() == 77) {
                searchFor = ICSearchConstants.ENUM;
            } else if (iToken.getType() == 116) {
                searchFor = ICSearchConstants.TYPEDEF;
            } else {
                bl3 = false;
            }
            if (bl3) {
                cArray = CharOperation.subarray(cArray, iToken.getLength() + 1, -1);
                iToken = null;
            }
        }
        LinkedList linkedList = CSearchPattern.scanForNames(iScanner, requestor, iToken, cArray);
        char[] cArray2 = (char[])linkedList.removeLast();
        char[][] cArray3 = new char[][]{};
        return new ClassDeclarationPattern(cArray2, (char[][])linkedList.toArray((T[])cArray3), searchFor, limitTo, n, bl, bl2);
    }

    private static CSearchPattern createDerivedPattern(String string, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int n, boolean bl) {
        char[] cArray = string.toCharArray();
        IScanner iScanner = null;
        Requestor requestor = new Requestor(ParserMode.COMPLETE_PARSE);
        try {
            iScanner = ParserFactory.createScanner(new CodeReader(cArray), (IScannerInfo)new ScannerInfo(), ParserMode.QUICK_PARSE, ParserLanguage.CPP, (ISourceElementRequestor)requestor, nullLog, null);
        }
        catch (ParserFactoryError parserFactoryError) {}
        searchFor = ICSearchConstants.DERIVED;
        LinkedList linkedList = CSearchPattern.scanForNames(iScanner, requestor, null, cArray);
        char[] cArray2 = (char[])linkedList.removeLast();
        char[][] cArray3 = new char[][]{};
        return new DerivedTypesPattern(cArray2, (char[][])linkedList.toArray((T[])cArray3), searchFor, limitTo, n, bl);
    }

    private static CSearchPattern createFriendPattern(String string, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int n, boolean bl) {
        char[] cArray = string.toCharArray();
        IScanner iScanner = null;
        Requestor requestor = new Requestor(ParserMode.COMPLETE_PARSE);
        try {
            iScanner = ParserFactory.createScanner(new CodeReader(cArray), (IScannerInfo)new ScannerInfo(), ParserMode.QUICK_PARSE, ParserLanguage.CPP, (ISourceElementRequestor)requestor, nullLog, null);
        }
        catch (ParserFactoryError parserFactoryError) {}
        searchFor = ICSearchConstants.FRIEND;
        LinkedList linkedList = CSearchPattern.scanForNames(iScanner, requestor, null, cArray);
        char[] cArray2 = (char[])linkedList.removeLast();
        char[][] cArray3 = new char[][]{};
        return new FriendPattern(cArray2, (char[][])linkedList.toArray((T[])cArray3), searchFor, limitTo, n, bl);
    }

    private static LinkedList scanForParameters(String string) {
        LinkedList<char[]> linkedList = new LinkedList<char[]>();
        if (string == null || string.equals("")) {
            return linkedList;
        }
        String string2 = "void f " + string + ";";
        IScanner iScanner = null;
        IQuickParseCallback iQuickParseCallback = ParserFactory.createQuickParseCallback();
        try {
            iScanner = ParserFactory.createScanner(new CodeReader(string2.toCharArray()), (IScannerInfo)new ScannerInfo(), ParserMode.QUICK_PARSE, ParserLanguage.CPP, (ISourceElementRequestor)iQuickParseCallback, (IParserLogService)new NullLogService(), null);
        }
        catch (ParserFactoryError parserFactoryError) {}
        IParser iParser = null;
        try {
            iParser = ParserFactory.createParser(iScanner, iQuickParseCallback, ParserMode.QUICK_PARSE, ParserLanguage.CPP, ParserUtil.getParserLogService());
        }
        catch (ParserFactoryError parserFactoryError) {}
        if (iParser.parse()) {
            IASTCompilationUnit iASTCompilationUnit = iQuickParseCallback.getCompilationUnit();
            Iterator iterator = null;
            try {
                iterator = iASTCompilationUnit.getDeclarations();
            }
            catch (ASTNotImplementedException aSTNotImplementedException) {}
            if (iterator == null || !iterator.hasNext()) {
                return null;
            }
            IASTDeclaration iASTDeclaration = (IASTDeclaration)iterator.next();
            if (!(iASTDeclaration instanceof IASTFunction)) {
                return linkedList;
            }
            IASTFunction iASTFunction = (IASTFunction)iASTDeclaration;
            String[] stringArray = ASTUtil.getFunctionParameterTypes(iASTFunction);
            if (stringArray.length == 0) {
                linkedList.add("void".toCharArray());
            } else {
                int n = 0;
                while (n < stringArray.length) {
                    linkedList.add(stringArray[n].toCharArray());
                    ++n;
                }
            }
        }
        return linkedList;
    }

    private static LinkedList scanForNames(IScanner iScanner, Requestor requestor, IToken iToken, char[] cArray) {
        LinkedList<char[]> linkedList = new LinkedList<char[]>();
        String string = new String("");
        int n = 0;
        try {
            IToken iToken2 = iToken != null ? iToken : iScanner.nextToken();
            IToken iToken3 = null;
            boolean bl = false;
            boolean bl2 = false;
            block7: while (true) {
                switch (iToken2.getType()) {
                    case 3: {
                        linkedList.addLast(string.toCharArray());
                        string = new String("");
                        bl2 = false;
                        n += iToken2.getLength();
                        while (n < cArray.length && CharOperation.isWhitespace(cArray[n])) {
                            ++n;
                        }
                        break;
                    }
                    case 95: {
                        string = String.valueOf(string) + iToken2.getImage();
                        string = String.valueOf(string) + ' ';
                        bl2 = true;
                        n += iToken2.getLength();
                        while (n < cArray.length && CharOperation.isWhitespace(cArray[n])) {
                            ++n;
                        }
                        break;
                    }
                    default: {
                        if (iToken2.getType() == 23 || iToken2.getType() == 7) {
                            if (n > 0 && n < cArray.length && CharOperation.isWhitespace(cArray[n - 1]) && !bl2) {
                                string = String.valueOf(string) + ' ';
                            }
                            bl = true;
                        } else if (!bl && !bl2 && string.length() > 0 && iToken3.getType() != 1 && iToken3.getType() != 42 && iToken3.getType() != 34 && iToken3.getType() != 20 && iToken3.getType() != 10 && iToken2.getType() != 11 && iToken2.getType() != 46) {
                            string = String.valueOf(string) + ' ';
                        } else {
                            bl = false;
                        }
                        string = String.valueOf(string) + iToken2.getImage();
                        if (bl && n < cArray.length - 1 && CharOperation.isWhitespace(cArray[n + 1])) {
                            string = String.valueOf(string) + ' ';
                        }
                        n += iToken2.getLength();
                        while (n < cArray.length && CharOperation.isWhitespace(cArray[n])) {
                            ++n;
                        }
                        bl2 = false;
                    }
                }
                iToken3 = iToken2;
                iToken2 = null;
                while (true) {
                    if (iToken2 != null) continue block7;
                    iToken2 = iScanner.nextToken();
                    if (requestor.badCharacterOffset == -1 || iToken2.getOffset() <= requestor.badCharacterOffset) continue;
                    if (!bl && !bl2 && iToken3.getType() != 20) {
                        string = String.valueOf(string) + " ";
                    }
                    string = String.valueOf(string) + "\\";
                    ++n;
                    bl = true;
                    bl2 = false;
                    iToken3 = null;
                    requestor.badCharacterOffset = -1;
                }
                break;
            }
        }
        catch (EndOfFileException endOfFileException) {
            linkedList.addLast(string.toCharArray());
        }
        catch (ScannerException scannerException) {}
        return linkedList;
    }

    protected boolean matchesName(char[] cArray, char[] cArray2) {
        if (cArray == null) {
            return true;
        }
        if (cArray2 != null) {
            switch (this._matchMode) {
                case 0: {
                    return CharOperation.equals(cArray, cArray2, this._caseSensitive);
                }
                case 1: {
                    return CharOperation.prefixEquals(cArray, cArray2, this._caseSensitive);
                }
                case 2: {
                    if (!this._caseSensitive) {
                        cArray = CharOperation.toLowerCase(cArray);
                    }
                    return CharOperation.match(cArray, cArray2, this._caseSensitive);
                }
            }
        }
        return false;
    }

    protected boolean matchQualifications(char[][] cArray, char[][] cArray2) {
        return this.matchQualifications(cArray, cArray2, false);
    }

    protected boolean matchQualifications(char[][] cArray, char[][] cArray2, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = n3 = cArray != null ? cArray.length : 0;
        int n5 = cArray2 != null ? cArray2.length - (bl ? 1 : 0) : (n2 = 0);
        if (n3 == 0) {
            return true;
        }
        int n6 = n = cArray[0].length == 0 ? 1 : 0;
        if (n == 1 && n2 != n3 - 1 || n == 0 && n2 < n3) {
            return false;
        }
        int n7 = 1;
        while (n7 <= n3 - n) {
            if (!this.matchesName(cArray[n3 - n7], cArray2[n2 - n7])) {
                return false;
            }
            ++n7;
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void findIndexMatches(IIndex iIndex, IIndexSearchRequestor iIndexSearchRequestor, int n, IProgressMonitor iProgressMonitor, ICSearchScope iCSearchScope) throws IOException {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        BlocksIndexInput blocksIndexInput = new BlocksIndexInput(iIndex.getIndexFile());
        try {
            ((IndexInput)blocksIndexInput).open();
            this.findIndexMatches(blocksIndexInput, iIndexSearchRequestor, n, iProgressMonitor, iCSearchScope);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            ((IndexInput)blocksIndexInput).close();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        ((IndexInput)blocksIndexInput).close();
    }

    public void findIndexMatches(IndexInput indexInput, IIndexSearchRequestor iIndexSearchRequestor, int n, IProgressMonitor iProgressMonitor, ICSearchScope iCSearchScope) throws IOException {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        char[] cArray = this.indexEntryPrefix();
        if (cArray == null) {
            return;
        }
        IEntryResult[] iEntryResultArray = indexInput.queryEntriesPrefixedBy(cArray);
        if (iEntryResultArray == null) {
            return;
        }
        int n2 = 0;
        int n3 = iEntryResultArray.length;
        while (n2 < n3) {
            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IEntryResult iEntryResult = iEntryResultArray[n2];
            this.resetIndexInfo();
            this.decodeIndexEntry(iEntryResult);
            if (this.matchIndexEntry()) {
                this.feedIndexRequestor(iIndexSearchRequestor, n, iEntryResult.getFileReferences(), indexInput, iCSearchScope);
            }
            ++n2;
        }
    }

    public abstract void feedIndexRequestor(IIndexSearchRequestor var1, int var2, int[] var3, IndexInput var4, ICSearchScope var5) throws IOException;

    protected abstract void resetIndexInfo();

    protected abstract void decodeIndexEntry(IEntryResult var1);

    public abstract char[] indexEntryPrefix();

    protected abstract boolean matchIndexEntry();

    protected static class Requestor
    extends NullSourceElementRequestor {
        public int badCharacterOffset = -1;

        public Requestor(ParserMode parserMode) {
            super(parserMode);
        }

        public boolean acceptProblem(IProblem iProblem) {
            if (iProblem.getID() == 0x1000001) {
                this.badCharacterOffset = iProblem.getSourceStart();
                return false;
            }
            return super.acceptProblem(iProblem);
        }
    }
}

