/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTQualifiedNameElement;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameter;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;

public class FieldDeclarationPattern
extends CSearchPattern {
    private char[][] qualifications;
    private char[][] decodedQualifications;
    private char[] simpleName;
    private char[] decodedSimpleName;
    private ICSearchConstants.SearchFor searchFor;

    public FieldDeclarationPattern(char[] cArray, char[][] cArray2, int n, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, boolean bl) {
        super(n, bl, limitTo);
        this.qualifications = cArray2;
        this.searchFor = searchFor;
        this.simpleName = cArray;
    }

    public int matchLevel(ISourceElementCallbackDelegate iSourceElementCallbackDelegate, ICSearchConstants.LimitTo limitTo) {
        if (iSourceElementCallbackDelegate instanceof IASTField) {
            if (this.searchFor != ICSearchConstants.FIELD || !this.canAccept(limitTo)) {
                return 0;
            }
        } else if (iSourceElementCallbackDelegate instanceof IASTVariable) {
            if (this.searchFor != ICSearchConstants.VAR || !this.canAccept(limitTo)) {
                return 0;
            }
        } else if (iSourceElementCallbackDelegate instanceof IASTEnumerator) {
            if (this.searchFor != ICSearchConstants.ENUMTOR || !this.canAccept(limitTo)) {
                return 0;
            }
        } else if (iSourceElementCallbackDelegate instanceof IASTParameterDeclaration) {
            if (this.searchFor != ICSearchConstants.VAR || !this.canAccept(limitTo)) {
                return 0;
            }
        } else if (iSourceElementCallbackDelegate instanceof IASTTemplateParameter) {
            if (this.searchFor != ICSearchConstants.VAR || !this.canAccept(limitTo)) {
                return 0;
            }
        } else {
            return 0;
        }
        char[] cArray = ((IASTOffsetableNamedElement)((Object)iSourceElementCallbackDelegate)).getNameCharArray();
        if (this.simpleName != null && !this.matchesName(this.simpleName, cArray)) {
            return 0;
        }
        char[][] cArray2 = null;
        if (iSourceElementCallbackDelegate instanceof IASTEnumerator) {
            IASTEnumerationSpecifier iASTEnumerationSpecifier = ((IASTEnumerator)iSourceElementCallbackDelegate).getOwnerEnumerationSpecifier();
            cArray2 = iASTEnumerationSpecifier.getFullyQualifiedNameCharArrays();
        } else if (iSourceElementCallbackDelegate instanceof IASTQualifiedNameElement) {
            cArray2 = ((IASTQualifiedNameElement)((Object)iSourceElementCallbackDelegate)).getFullyQualifiedNameCharArrays();
        }
        if (cArray2 != null && !this.matchQualifications(this.qualifications, cArray2, true)) {
            return 0;
        }
        return 2;
    }

    public char[] indexEntryPrefix() {
        if (this.searchFor == ICSearchConstants.FIELD) {
            return AbstractIndexer.bestFieldPrefix(this._limitTo, this.simpleName, this.qualifications, this._matchMode, this._caseSensitive);
        }
        if (this.searchFor == ICSearchConstants.VAR) {
            return AbstractIndexer.bestVariablePrefix(this._limitTo, this.simpleName, this.qualifications, this._matchMode, this._caseSensitive);
        }
        if (this.searchFor == ICSearchConstants.ENUMTOR) {
            return AbstractIndexer.bestEnumeratorPrefix(this._limitTo, this.simpleName, this.qualifications, this._matchMode, this._caseSensitive);
        }
        return null;
    }

    protected void resetIndexInfo() {
        this.decodedSimpleName = null;
        this.decodedQualifications = null;
    }

    protected void decodeIndexEntry(IEntryResult iEntryResult) {
        char[] cArray = iEntryResult.getWord();
        int n = cArray.length;
        int n2 = 0;
        int n3 = 0;
        if (this.searchFor == ICSearchConstants.FIELD) {
            n2 = CharOperation.indexOf('/', cArray, 0);
            n3 = CharOperation.indexOf('/', cArray, n2 + 1);
        } else if (this.searchFor == ICSearchConstants.VAR) {
            int n4 = CharOperation.indexOf('/', cArray, 0);
            n2 = CharOperation.indexOf('/', cArray, n4 + 1);
            n3 = CharOperation.indexOf('/', cArray, n2 + 1);
        } else if (this.searchFor == ICSearchConstants.ENUMTOR) {
            n2 = CharOperation.indexOf('/', cArray, 0);
            n3 = CharOperation.indexOf('/', cArray, n2 + 1);
        }
        this.decodedSimpleName = CharOperation.subarray(cArray, n2 + 1, n3);
        if (n3 != -1 && n3 + 1 < n) {
            char[][] cArray2 = CharOperation.splitOn('/', CharOperation.subarray(cArray, n3 + 1, n));
            this.decodedQualifications = new char[cArray2.length][];
            int n5 = 0;
            while (n5 < cArray2.length) {
                this.decodedQualifications[n5] = cArray2[cArray2.length - n5 - 1];
                ++n5;
            }
        }
    }

    public void feedIndexRequestor(IIndexSearchRequestor iIndexSearchRequestor, int n, int[] nArray, IndexInput indexInput, ICSearchScope iCSearchScope) throws IOException {
        int n2 = 0;
        int n3 = nArray.length;
        while (n2 < n3) {
            String string;
            IndexedFile indexedFile = indexInput.getIndexedFile(nArray[n2]);
            if (indexedFile != null && iCSearchScope.encloses(string = indexedFile.getPath())) {
                iIndexSearchRequestor.acceptFieldDeclaration(string, this.decodedSimpleName, this.decodedQualifications);
            }
            ++n2;
        }
    }

    protected boolean matchIndexEntry() {
        if (this.simpleName != null && !this.matchesName(this.simpleName, this.decodedSimpleName)) {
            return false;
        }
        return this.matchQualifications(this.qualifications, this.decodedQualifications);
    }
}

