/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;

public class IncludePattern
extends CSearchPattern {
    protected char[] simpleName;
    protected char[] decodedSimpleName;

    public IncludePattern(char[] cArray, int n, ICSearchConstants.LimitTo limitTo, boolean bl) {
        super(n, bl, limitTo);
        this.simpleName = cArray;
    }

    protected void decodeIndexEntry(IEntryResult iEntryResult) {
        char[] cArray = iEntryResult.getWord();
        int n = CharOperation.indexOf('/', cArray, 0);
        this.decodedSimpleName = CharOperation.subarray(cArray, n + 1, -1);
    }

    public void feedIndexRequestor(IIndexSearchRequestor iIndexSearchRequestor, int n, int[] nArray, IndexInput indexInput, ICSearchScope iCSearchScope) throws IOException {
        int n2 = 0;
        int n3 = nArray.length;
        while (n2 < n3) {
            String string;
            IndexedFile indexedFile = indexInput.getIndexedFile(nArray[n2]);
            if (indexedFile != null && iCSearchScope.encloses(string = indexedFile.getPath())) {
                iIndexSearchRequestor.acceptIncludeDeclaration(string, this.decodedSimpleName);
            }
            ++n2;
        }
    }

    protected void resetIndexInfo() {
        this.decodedSimpleName = null;
    }

    public char[] indexEntryPrefix() {
        return AbstractIndexer.bestIncludePrefix(this._limitTo, this.simpleName, this._matchMode, this._caseSensitive);
    }

    protected boolean matchIndexEntry() {
        return this.simpleName == null || this.matchesName(this.simpleName, this.decodedSimpleName);
    }

    public int matchLevel(ISourceElementCallbackDelegate iSourceElementCallbackDelegate, ICSearchConstants.LimitTo limitTo) {
        if (!(iSourceElementCallbackDelegate instanceof IASTInclusion)) {
            return 0;
        }
        if (!this.canAccept(limitTo)) {
            return 0;
        }
        IASTInclusion iASTInclusion = (IASTInclusion)iSourceElementCallbackDelegate;
        String string = iASTInclusion.getFullFileName();
        if (CharOperation.equals(this.simpleName, string.toCharArray(), this._caseSensitive)) {
            return 2;
        }
        return 0;
    }
}

