/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;

public class MacroDeclarationPattern
extends CSearchPattern {
    protected char[] simpleName;
    protected char[] decodedSimpleName;

    public MacroDeclarationPattern(char[] cArray, int n, ICSearchConstants.LimitTo limitTo, boolean bl) {
        super(n, bl, limitTo);
        this.simpleName = cArray;
    }

    public int matchLevel(ISourceElementCallbackDelegate iSourceElementCallbackDelegate, ICSearchConstants.LimitTo limitTo) {
        if (!(iSourceElementCallbackDelegate instanceof IASTMacro) || !this.canAccept(limitTo)) {
            return 0;
        }
        char[] cArray = ((IASTOffsetableNamedElement)((Object)iSourceElementCallbackDelegate)).getNameCharArray();
        if (this.simpleName != null && !this.matchesName(this.simpleName, cArray)) {
            return 0;
        }
        return 2;
    }

    public void feedIndexRequestor(IIndexSearchRequestor iIndexSearchRequestor, int n, int[] nArray, IndexInput indexInput, ICSearchScope iCSearchScope) throws IOException {
        int n2 = 0;
        int n3 = nArray.length;
        while (n2 < n3) {
            String string;
            IndexedFile indexedFile = indexInput.getIndexedFile(nArray[n2]);
            if (indexedFile != null && iCSearchScope.encloses(string = indexedFile.getPath())) {
                iIndexSearchRequestor.acceptMacroDeclaration(string, this.decodedSimpleName);
            }
            ++n2;
        }
    }

    protected void resetIndexInfo() {
        this.decodedSimpleName = null;
    }

    protected void decodeIndexEntry(IEntryResult iEntryResult) {
        char[] cArray = iEntryResult.getWord();
        int n = CharOperation.indexOf('/', cArray, 0);
        this.decodedSimpleName = CharOperation.subarray(cArray, n + 1, -1);
    }

    public char[] indexEntryPrefix() {
        return AbstractIndexer.bestMacroPrefix(this._limitTo, this.simpleName, this._matchMode, this._caseSensitive);
    }

    protected boolean matchIndexEntry() {
        return this.simpleName == null || this.matchesName(this.simpleName, this.decodedSimpleName);
    }
}

