/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.IASTASMDefinition;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassReference;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationReference;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTEnumeratorReference;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFieldReference;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTFunctionReference;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTLinkageSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTMethodReference;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceReference;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTParameterReference;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateInstantiation;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameterReference;
import org.eclipse.cdt.core.parser.ast.IASTTemplateSpecialization;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTypedefReference;
import org.eclipse.cdt.core.parser.ast.IASTUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.ast.IASTVariableReference;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.IMatchLocator;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectSet;
import org.eclipse.cdt.internal.core.search.AcceptMatchOperation;
import org.eclipse.cdt.internal.core.search.indexing.IndexProblemHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class MatchLocator
implements IMatchLocator {
    ArrayList matchStorage;
    protected ObjectSet encounteredHeaders;
    protected ObjectSet tempHeaderSet;
    public static boolean VERBOSE = false;
    private boolean checkForMatch = true;
    private boolean shouldExcludeLocalDeclarations = false;
    private ISourceElementCallbackDelegate lastDeclaration;
    private ICSearchPattern searchPattern;
    private ICSearchResultCollector resultCollector;
    private IProgressMonitor progressMonitor;
    private IPath currentPath = null;
    private ICSearchScope searchScope;
    private IWorkspaceRoot workspaceRoot;
    private IPath realPath;
    private IResource currentResource = null;
    private LinkedList resourceStack = new LinkedList();
    private IASTScope currentScope = null;
    private LinkedList scopeStack = new LinkedList();
    private LinkedList searchStack = new LinkedList();

    public MatchLocator(ICSearchPattern iCSearchPattern, ICSearchResultCollector iCSearchResultCollector, ICSearchScope iCSearchScope) {
        this.searchPattern = iCSearchPattern;
        this.resultCollector = iCSearchResultCollector;
        this.searchScope = iCSearchScope;
    }

    public boolean acceptProblem(IProblem iProblem) {
        return IndexProblemHandler.ruleOnProblem(iProblem, ParserMode.COMPLETE_PARSE);
    }

    public void acceptUsingDirective(IASTUsingDirective iASTUsingDirective) {
    }

    public void acceptUsingDeclaration(IASTUsingDeclaration iASTUsingDeclaration) {
    }

    public void acceptASMDefinition(IASTASMDefinition iASTASMDefinition) {
    }

    public void acceptAbstractTypeSpecDeclaration(IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration) {
    }

    public void enterTemplateDeclaration(IASTTemplateDeclaration iASTTemplateDeclaration) {
    }

    public void enterTemplateSpecialization(IASTTemplateSpecialization iASTTemplateSpecialization) {
    }

    public void enterTemplateInstantiation(IASTTemplateInstantiation iASTTemplateInstantiation) {
    }

    public void exitTemplateDeclaration(IASTTemplateDeclaration iASTTemplateDeclaration) {
    }

    public void exitTemplateSpecialization(IASTTemplateSpecialization iASTTemplateSpecialization) {
    }

    public void exitTemplateExplicitInstantiation(IASTTemplateInstantiation iASTTemplateInstantiation) {
    }

    public void enterCodeBlock(IASTCodeScope iASTCodeScope) {
    }

    public void exitCodeBlock(IASTCodeScope iASTCodeScope) {
    }

    public void enterLinkageSpecification(IASTLinkageSpecification iASTLinkageSpecification) {
        this.pushScope(iASTLinkageSpecification);
    }

    public void exitLinkageSpecification(IASTLinkageSpecification iASTLinkageSpecification) {
        this.popScope();
    }

    public void acceptParameterReference(IASTParameterReference iASTParameterReference) {
        if (this.checkForMatch) {
            this.check(ICSearchConstants.REFERENCES, iASTParameterReference);
        }
    }

    public void acceptTemplateParameterReference(IASTTemplateParameterReference iASTTemplateParameterReference) {
        if (this.checkForMatch) {
            this.check(ICSearchConstants.REFERENCES, iASTTemplateParameterReference);
        }
    }

    public void acceptTypedefDeclaration(IASTTypedefDeclaration iASTTypedefDeclaration) {
        this.lastDeclaration = iASTTypedefDeclaration;
        if (this.checkForMatch) {
            this.check(ICSearchConstants.DECLARATIONS, iASTTypedefDeclaration);
        }
    }

    public void acceptTypedefReference(IASTTypedefReference iASTTypedefReference) {
        if (this.checkForMatch) {
            this.check(ICSearchConstants.REFERENCES, iASTTypedefReference);
        }
    }

    public void acceptEnumeratorReference(IASTEnumeratorReference iASTEnumeratorReference) {
        if (this.checkForMatch) {
            this.check(ICSearchConstants.REFERENCES, iASTEnumeratorReference);
        }
    }

    public void acceptMacro(IASTMacro iASTMacro) {
        if (this.checkForMatch) {
            this.check(ICSearchConstants.DECLARATIONS, iASTMacro);
        }
    }

    public void acceptVariable(IASTVariable iASTVariable) {
        this.lastDeclaration = iASTVariable;
        if (this.checkForMatch) {
            this.check(ICSearchConstants.DECLARATIONS, iASTVariable);
            if (iASTVariable.getInitializerClause() != null || !iASTVariable.isExtern() && !(this.currentScope instanceof IASTLinkageSpecification)) {
                this.check(ICSearchConstants.DEFINITIONS, iASTVariable);
            }
        }
    }

    public void acceptField(IASTField iASTField) {
        this.lastDeclaration = iASTField;
        if (this.checkForMatch) {
            if (this.currentScope instanceof IASTClassSpecifier) {
                this.check(ICSearchConstants.DECLARATIONS, iASTField);
                if (!iASTField.isStatic()) {
                    this.check(ICSearchConstants.DEFINITIONS, iASTField);
                }
            } else {
                this.check(ICSearchConstants.DEFINITIONS, iASTField);
            }
        }
    }

    public void acceptEnumerationSpecifier(IASTEnumerationSpecifier iASTEnumerationSpecifier) {
        this.lastDeclaration = iASTEnumerationSpecifier;
        if (this.checkForMatch) {
            this.check(ICSearchConstants.DECLARATIONS, iASTEnumerationSpecifier);
            Iterator iterator = iASTEnumerationSpecifier.getEnumerators();
            while (iterator.hasNext()) {
                IASTEnumerator iASTEnumerator = (IASTEnumerator)iterator.next();
                this.lastDeclaration = iASTEnumerator;
                this.check(ICSearchConstants.DECLARATIONS, iASTEnumerator);
            }
        }
    }

    public void acceptFunctionDeclaration(IASTFunction iASTFunction) {
        this.lastDeclaration = iASTFunction;
        if (this.checkForMatch) {
            this.check(ICSearchConstants.DECLARATIONS, iASTFunction);
        }
    }

    public void acceptMethodDeclaration(IASTMethod iASTMethod) {
        this.lastDeclaration = iASTMethod;
        if (this.checkForMatch) {
            this.check(ICSearchConstants.DECLARATIONS, iASTMethod);
        }
    }

    public void acceptClassReference(IASTClassReference iASTClassReference) {
        if (this.checkForMatch) {
            this.check(ICSearchConstants.REFERENCES, iASTClassReference);
        }
    }

    public void acceptNamespaceReference(IASTNamespaceReference iASTNamespaceReference) {
        if (this.checkForMatch) {
            this.check(ICSearchConstants.REFERENCES, iASTNamespaceReference);
        }
    }

    public void acceptVariableReference(IASTVariableReference iASTVariableReference) {
        if (this.checkForMatch) {
            this.check(ICSearchConstants.REFERENCES, iASTVariableReference);
        }
    }

    public void acceptFieldReference(IASTFieldReference iASTFieldReference) {
        if (this.checkForMatch) {
            this.check(ICSearchConstants.REFERENCES, iASTFieldReference);
        }
    }

    public void acceptEnumerationReference(IASTEnumerationReference iASTEnumerationReference) {
        if (this.checkForMatch) {
            this.check(ICSearchConstants.REFERENCES, iASTEnumerationReference);
        }
    }

    public void acceptFunctionReference(IASTFunctionReference iASTFunctionReference) {
        if (this.checkForMatch) {
            this.check(ICSearchConstants.REFERENCES, iASTFunctionReference);
        }
    }

    public void acceptMethodReference(IASTMethodReference iASTMethodReference) {
        if (this.checkForMatch) {
            this.check(ICSearchConstants.REFERENCES, iASTMethodReference);
        }
    }

    public void enterFunctionBody(IASTFunction iASTFunction) {
        this.lastDeclaration = iASTFunction;
        if (this.checkForMatch) {
            if (!iASTFunction.previouslyDeclared()) {
                this.check(ICSearchConstants.DECLARATIONS, iASTFunction);
            }
            this.check(ICSearchConstants.DEFINITIONS, iASTFunction);
            Iterator iterator = iASTFunction.getParameters();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof IASTParameterDeclaration)) continue;
                this.check(ICSearchConstants.DECLARATIONS, (IASTParameterDeclaration)e);
            }
        }
        this.pushScope(iASTFunction);
    }

    public void enterMethodBody(IASTMethod iASTMethod) {
        this.lastDeclaration = iASTMethod;
        if (this.checkForMatch) {
            if (!iASTMethod.previouslyDeclared()) {
                this.check(ICSearchConstants.DECLARATIONS, iASTMethod);
            }
            this.check(ICSearchConstants.DEFINITIONS, iASTMethod);
            Iterator iterator = iASTMethod.getParameters();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof IASTParameterDeclaration)) continue;
                this.check(ICSearchConstants.DECLARATIONS, (IASTParameterDeclaration)e);
            }
        }
        this.pushScope(iASTMethod);
    }

    public void enterCompilationUnit(IASTCompilationUnit iASTCompilationUnit) {
        this.pushScope(iASTCompilationUnit);
    }

    public void enterNamespaceDefinition(IASTNamespaceDefinition iASTNamespaceDefinition) {
        this.lastDeclaration = iASTNamespaceDefinition;
        if (this.checkForMatch) {
            this.check(ICSearchConstants.DECLARATIONS, iASTNamespaceDefinition);
            this.check(ICSearchConstants.DEFINITIONS, iASTNamespaceDefinition);
        }
        this.pushScope(iASTNamespaceDefinition);
    }

    public void enterClassSpecifier(IASTClassSpecifier iASTClassSpecifier) {
        this.lastDeclaration = iASTClassSpecifier;
        if (this.checkForMatch) {
            this.check(ICSearchConstants.DECLARATIONS, iASTClassSpecifier);
        }
        this.pushScope(iASTClassSpecifier);
    }

    public void exitFunctionBody(IASTFunction iASTFunction) {
        this.popScope();
    }

    public void exitMethodBody(IASTMethod iASTMethod) {
        this.popScope();
    }

    public void exitClassSpecifier(IASTClassSpecifier iASTClassSpecifier) {
        if (this.checkForMatch) {
            this.check(ICSearchConstants.DECLARATIONS, iASTClassSpecifier);
        }
        this.popScope();
    }

    public void exitNamespaceDefinition(IASTNamespaceDefinition iASTNamespaceDefinition) {
        this.popScope();
    }

    public void exitCompilationUnit(IASTCompilationUnit iASTCompilationUnit) {
        this.popScope();
    }

    public void enterInclusion(IASTInclusion iASTInclusion) {
        String string = iASTInclusion.getFullFileName();
        Path path = new Path(string);
        IFile iFile = null;
        if (!this.encounteredHeaders.containsKey(string)) {
            this.searchStack.addFirst(new Boolean(this.checkForMatch));
            this.checkForMatch = true;
            if (!this.tempHeaderSet.containsKey(string)) {
                this.tempHeaderSet.put(string);
            }
        } else {
            this.searchStack.addFirst(new Boolean(this.checkForMatch));
            this.checkForMatch = false;
        }
        if (this.workspaceRoot != null) {
            iFile = this.workspaceRoot.getFileForLocation((IPath)path);
        }
        this.resourceStack.addFirst(this.currentResource != null ? this.currentResource : this.currentPath);
        this.currentResource = iFile;
        this.currentPath = iFile == null ? path : null;
    }

    public void exitInclusion(IASTInclusion iASTInclusion) {
        Object e = this.resourceStack.removeFirst();
        if (e instanceof IResource) {
            this.currentResource = (IResource)e;
            this.currentPath = null;
        } else {
            this.currentPath = (IPath)e;
            this.currentResource = null;
        }
        Boolean bl = (Boolean)this.searchStack.removeFirst();
        this.checkForMatch = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void locateMatches(String[] object, IWorkspace iWorkspace, IWorkingCopy[] iWorkingCopyArray) throws InterruptedException {
        String string;
        Object object2;
        int n;
        int n2;
        this.matchStorage = new ArrayList();
        this.encounteredHeaders = new ObjectSet(32);
        this.tempHeaderSet = new ObjectSet(32);
        this.workspaceRoot = iWorkspace != null ? iWorkspace.getRoot() : null;
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        int n3 = n2 = iWorkingCopyArray == null ? 0 : iWorkingCopyArray.length;
        if (n2 > 0) {
            String[] stringArray = new String[n2];
            n = 0;
            while (n < n2) {
                object2 = iWorkingCopyArray[n];
                string = object2.getOriginalElement().getPath().toString();
                hashMap.put(string, (String[])object2);
                stringArray[n] = string;
                ++n;
            }
            n = ((Object[])object).length;
            object2 = new String[n + n2];
            System.arraycopy(object, 0, object2, 0, n);
            System.arraycopy(stringArray, 0, object2, n, n2);
            object = object2;
        }
        Arrays.sort(object);
        int n4 = ((Object[])object).length;
        if (this.progressMonitor != null) {
            this.progressMonitor.beginTask("", n4);
        }
        n = 0;
        while (n < n4) {
            block40: {
                Object var18_22;
                Object object3;
                IParser iParser;
                Object object4;
                Object object5;
                Object object6;
                IResource iResource;
                CodeReader codeReader;
                block41: {
                    block43: {
                        IPath iPath;
                        if (this.progressMonitor != null) {
                            if (this.progressMonitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                            this.progressMonitor.worked(1);
                        }
                        object2 = object[n];
                        if (n > 0 && ((String)object2).equals(object[n - 1]) || !this.searchScope.encloses((String)object2) || (iPath = (string = this.workspaceRoot.getFile((IPath)new Path((String)object2))).getLocation()) != null && this.encounteredHeaders.containsKey(iPath.toOSString())) break block40;
                        codeReader = null;
                        this.realPath = null;
                        iResource = null;
                        if (this.workspaceRoot == null) break block41;
                        object6 = (IWorkingCopy)hashMap.get(object2);
                        if (object6 == null) break block43;
                        this.currentResource = object6.getResource();
                        if (this.currentResource == null || !this.currentResource.isAccessible()) break block40;
                        codeReader = new CodeReader(this.currentResource.getLocation().toOSString(), object6.getContents());
                        this.realPath = this.currentResource.getLocation();
                        iResource = this.currentResource.getProject();
                        break block41;
                    }
                    this.currentResource = this.workspaceRoot.findMember((String)object2, true);
                    object5 = null;
                    try {
                        block39: {
                            try {
                                if (this.currentResource == null) break block39;
                                if (this.currentResource.isAccessible() && this.currentResource instanceof IFile) {
                                    object4 = (IFile)this.currentResource;
                                    object5 = object4.getContents();
                                    codeReader = new CodeReader(this.currentResource.getLocation().toOSString(), object4.getCharset(), (InputStream)object5);
                                    this.realPath = this.currentResource.getLocation();
                                    iResource = object4.getProject();
                                    break block39;
                                }
                                iParser = null;
                                if (object5 != null) {
                                    try {
                                        ((InputStream)object5).close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                break block40;
                            }
                            catch (CoreException coreException) {
                                iParser = null;
                                if (object5 != null) {
                                    try {}
                                    catch (IOException iOException) {}
                                    ((InputStream)object5).close();
                                }
                                break block40;
                            }
                            catch (IOException iOException) {
                                iParser = null;
                                if (object5 != null) {
                                    try {}
                                    catch (IOException iOException2) {}
                                    ((InputStream)object5).close();
                                }
                                break block40;
                            }
                        }
                        iParser = null;
                        if (object5 == null) break block41;
                    }
                    catch (Throwable throwable) {
                        iParser = null;
                        if (object5 == null) throw throwable;
                        try {}
                        catch (IOException iOException) {}
                        ((InputStream)object5).close();
                        throw throwable;
                        throw throwable;
                    }
                    try {}
                    catch (IOException iOException) {}
                    ((InputStream)object5).close();
                }
                if (this.currentResource == null) {
                    try {
                        object6 = new Path((String)object2);
                        this.currentPath = object6;
                        codeReader = new CodeReader((String)object2);
                        this.realPath = this.currentPath;
                    }
                    catch (IOException iOException) {
                        break block40;
                    }
                }
                this.checkForMatch = true;
                object6 = new ScannerInfo();
                object5 = CCorePlugin.getDefault().getScannerInfoProvider((IProject)iResource);
                if (object5 != null && (object4 = object5.getScannerInformation(this.currentResource != null ? this.currentResource : iResource)) != null) {
                    object6 = new ScannerInfo(object4.getDefinedSymbols(), object4.getIncludePaths());
                }
                object4 = null;
                object4 = iResource != null ? (CoreModel.hasCCNature((IProject)iResource) ? ParserLanguage.CPP : ParserLanguage.C) : ParserLanguage.CPP;
                iParser = null;
                try {
                    object3 = ParserFactory.createScanner(codeReader, (IScannerInfo)object6, ParserMode.COMPLETE_PARSE, (ParserLanguage)object4, (ISourceElementRequestor)this, ParserUtil.getScannerLogService(), null);
                    iParser = ParserFactory.createParser((IScanner)object3, this, ParserMode.COMPLETE_PARSE, (ParserLanguage)object4, ParserUtil.getParserLogService());
                }
                catch (ParserFactoryError parserFactoryError) {}
                if (VERBOSE) {
                    MatchLocator.verbose("*** New Search for path: " + (String)object2);
                }
                try {
                    block42: {
                        try {
                            iParser.parse();
                        }
                        catch (Exception exception) {
                            if (VERBOSE) {
                                exception.printStackTrace();
                            }
                        }
                        catch (VirtualMachineError virtualMachineError) {
                            if (!VERBOSE) break block42;
                            MatchLocator.verbose("MatchLocator VM Error: ");
                            virtualMachineError.printStackTrace();
                        }
                    }
                    var18_22 = null;
                    this.encounteredHeaders.addAll(this.tempHeaderSet);
                }
                catch (Throwable throwable) {
                    var18_22 = null;
                    this.encounteredHeaders.addAll(this.tempHeaderSet);
                    this.tempHeaderSet.clear();
                    this.scopeStack.clear();
                    this.resourceStack.clear();
                    this.searchStack.clear();
                    this.lastDeclaration = null;
                    this.currentScope = null;
                    iParser = null;
                    throw throwable;
                }
                this.tempHeaderSet.clear();
                this.scopeStack.clear();
                this.resourceStack.clear();
                this.searchStack.clear();
                this.lastDeclaration = null;
                this.currentScope = null;
                iParser = null;
                if (this.matchStorage.size() > 0) {
                    object3 = new AcceptMatchOperation(this.resultCollector, this.matchStorage);
                    try {
                        CCorePlugin.getWorkspace().run((IWorkspaceRunnable)object3, null);
                    }
                    catch (CoreException coreException) {}
                    this.matchStorage.clear();
                }
            }
            ++n;
        }
    }

    protected void report(ISourceElementCallbackDelegate iSourceElementCallbackDelegate, int n) {
        try {
            Object object;
            if (this.currentResource != null && !this.searchScope.encloses(this.currentResource.getFullPath().toOSString())) {
                return;
            }
            int n2 = 0;
            int n3 = 0;
            if (iSourceElementCallbackDelegate instanceof IASTReference) {
                object = (IASTReference)iSourceElementCallbackDelegate;
                n2 = object.getOffset();
                n3 = n2 + object.getName().length();
                if (VERBOSE) {
                    MatchLocator.verbose("Report Match: " + object.getName());
                }
            } else if (iSourceElementCallbackDelegate instanceof IASTOffsetableNamedElement) {
                object = (IASTOffsetableNamedElement)((Object)iSourceElementCallbackDelegate);
                n2 = object.getNameOffset() != 0 ? object.getNameOffset() : object.getStartingOffset();
                n3 = object.getNameEndOffset();
                if (n3 == 0) {
                    n3 = n2 + object.getName().length();
                }
                if (VERBOSE) {
                    MatchLocator.verbose("Report Match: " + object.getName());
                }
            }
            object = null;
            ISourceElementCallbackDelegate iSourceElementCallbackDelegate2 = null;
            if (iSourceElementCallbackDelegate instanceof IASTReference) {
                iSourceElementCallbackDelegate2 = this.currentScope instanceof IASTFunction || this.currentScope instanceof IASTMethod ? (ISourceElementCallbackDelegate)((Object)this.currentScope) : this.lastDeclaration;
            } else if (this.currentScope instanceof IASTFunction || this.currentScope instanceof IASTMethod) {
                if (this.shouldExcludeLocalDeclarations) {
                    return;
                }
                iSourceElementCallbackDelegate2 = (ISourceElementCallbackDelegate)((Object)this.currentScope);
            } else {
                iSourceElementCallbackDelegate2 = iSourceElementCallbackDelegate;
            }
            if (this.currentResource != null) {
                object = this.resultCollector.createMatch(this.currentResource, n2, n3, iSourceElementCallbackDelegate2, null);
            } else if (this.currentPath != null) {
                object = this.resultCollector.createMatch(this.currentPath, n2, n3, iSourceElementCallbackDelegate2, this.realPath);
            }
            if (object != null) {
                this.matchStorage.add(object);
            }
        }
        catch (CoreException coreException) {}
    }

    private void check(ICSearchConstants.LimitTo limitTo, ISourceElementCallbackDelegate iSourceElementCallbackDelegate) {
        if (!this.searchPattern.canAccept(limitTo)) {
            return;
        }
        int n = 0;
        n = iSourceElementCallbackDelegate instanceof IASTReference ? this.searchPattern.matchLevel(((IASTReference)iSourceElementCallbackDelegate).getReferencedElement(), limitTo) : this.searchPattern.matchLevel(iSourceElementCallbackDelegate, limitTo);
        if (n != 0) {
            this.report(iSourceElementCallbackDelegate, n);
        }
    }

    private void pushScope(IASTScope iASTScope) {
        this.scopeStack.addFirst(this.currentScope);
        this.currentScope = iASTScope;
    }

    private IASTScope popScope() {
        IASTScope iASTScope = this.currentScope;
        this.currentScope = this.scopeStack.size() > 0 ? (IASTScope)this.scopeStack.removeFirst() : null;
        return iASTScope;
    }

    public void setShouldExcludeLocalDeclarations(boolean bl) {
        this.shouldExcludeLocalDeclarations = bl;
    }

    public void acceptElaboratedForewardDeclaration(IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier) {
        this.check(ICSearchConstants.DECLARATIONS, iASTElaboratedTypeSpecifier);
    }

    public void acceptFriendDeclaration(IASTDeclaration iASTDeclaration) {
    }

    public static void verbose(String string) {
        System.out.println("(" + Thread.currentThread() + ") " + string);
    }

    public CodeReader createReader(String string, Iterator iterator) {
        return ParserUtil.createReader(string, iterator);
    }

    public boolean parserTimeout() {
        return false;
    }

    public void setProgressMonitor(IProgressMonitor iProgressMonitor) {
        this.progressMonitor = iProgressMonitor;
    }
}

