/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.processing;

import java.util.HashSet;
import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.cdt.internal.core.search.processing.IJob;
import org.eclipse.cdt.internal.core.search.processing.IndexingJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class JobManager
implements Runnable {
    protected IJob[] awaitingJobs = new IJob[10];
    protected int jobStart = 0;
    protected int jobEnd = -1;
    protected boolean executing = false;
    protected Thread thread;
    public static final int ENABLED = 1;
    public static final int DISABLED = 0;
    public static final int WAITING = 2;
    private int enabled = 1;
    public static boolean VERBOSE = false;
    public boolean activated = false;
    private int awaitingClients = 0;
    protected HashSet jobSet;
    protected IndexingJob indexJob = null;
    private static final IStatus OK_STATUS = new Status(0, "org.eclipse.cdt.core", 0, "", null);
    private static final IStatus ERROR_STATUS = new Status(4, "org.eclipse.cdt.core", 4, "", null);

    public static void verbose(String string) {
        System.out.println("(" + Thread.currentThread() + ") " + string);
    }

    public IProgressMonitor getIndexJobProgressGroup() {
        if (this.indexJob == null) {
            return null;
        }
        return this.indexJob.getProgressGroup();
    }

    public void activateProcessing() {
        this.activated = true;
    }

    public synchronized int awaitingJobsCount() {
        if (!this.activated) {
            return 1;
        }
        return this.jobEnd - this.jobStart + 1;
    }

    public synchronized IJob currentJob() {
        if (this.enabled != 1) {
            return null;
        }
        if (this.jobStart <= this.jobEnd) {
            return this.awaitingJobs[this.jobStart];
        }
        return null;
    }

    public synchronized void disable() {
        this.enabled = 0;
        if (VERBOSE) {
            JobManager.verbose("DISABLING background indexing");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void discardJobs(String string) {
        if (VERBOSE) {
            JobManager.verbose("DISCARD   background job family - " + string);
        }
        int n = 0;
        try {
            IJob iJob;
            JobManager jobManager = this;
            synchronized (jobManager) {
                iJob = this.currentJob();
                n = this.enabledState();
                this.disable();
            }
            if (iJob != null && (string == null || iJob.belongsTo(string))) {
                iJob.cancel();
                while (this.thread != null && this.executing) {
                    try {
                        if (VERBOSE) {
                            JobManager.verbose("-> waiting end of current background job - " + iJob);
                        }
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            int n2 = -1;
            JobManager jobManager2 = this;
            synchronized (jobManager2) {
                int n3 = this.jobStart;
                while (true) {
                    block24: {
                        if (n3 <= this.jobEnd) break block24;
                        this.jobStart = 0;
                        this.jobEnd = n2;
                        break;
                    }
                    iJob = this.awaitingJobs[n3];
                    this.awaitingJobs[n3] = null;
                    if (string != null && !iJob.belongsTo(string)) {
                        this.awaitingJobs[++n2] = iJob;
                    } else {
                        if (VERBOSE) {
                            JobManager.verbose("-> discarding background job  - " + iJob);
                        }
                        iJob.cancel();
                        if (this.indexJob != null && this.indexJob.tickDown(null) <= 0) {
                            this.indexJob.done(OK_STATUS);
                            this.indexJob = null;
                        }
                    }
                    ++n3;
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (n == 1) {
                this.enable();
                throw throwable;
            }
            if (n != 2) throw throwable;
            this.pause();
            throw throwable;
        }
        {
            Object var7_10 = null;
            if (n == 1) {
                this.enable();
            } else if (n == 2) {
                this.pause();
            }
            if (!VERBOSE) return;
        }
        JobManager.verbose("DISCARD   DONE with background job family - " + string);
    }

    public synchronized void enable() {
        if (this.enabled == 2) {
            this.indexJob = new IndexingJob(this.thread, this);
            this.indexJob.setTicks(this.awaitingJobsCount());
        }
        this.enabled = 1;
        if (VERBOSE) {
            JobManager.verbose("ENABLING  background indexing");
        }
    }

    public synchronized int enabledState() {
        return this.enabled;
    }

    public synchronized void pause() {
        this.enabled = 2;
        if (VERBOSE) {
            JobManager.verbose("WAITING  pausing background indexing");
        }
    }

    protected synchronized void moveToNextJob() {
        if (this.jobStart <= this.jobEnd) {
            this.awaitingJobs[this.jobStart++] = null;
            if (this.jobStart > this.jobEnd) {
                this.jobStart = 0;
                this.jobEnd = -1;
            }
        }
        if (this.indexJob != null) {
            String string = null;
            IJob iJob = this.currentJob();
            if (iJob instanceof IndexRequest) {
                string = " (";
                string = String.valueOf(string) + iJob.toString();
                string = String.valueOf(string) + ")";
            }
            if (this.indexJob.tickDown(string) <= 0) {
                this.indexJob.done(OK_STATUS);
                this.indexJob = null;
            }
        }
    }

    protected void notifyIdle(long l) {
    }

    /*
     * Exception decompiling
     */
    public boolean performConcurrentJob(IJob var1_1, int var2_2, IProgressMonitor var3_3, IJob var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 235->238)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean jobShouldBeIgnored(IJob iJob) {
        if (iJob == null) {
            return false;
        }
        return this.currentJob() == iJob;
    }

    public abstract String processName();

    public synchronized void request(IJob iJob) {
        if (!iJob.isReadyToRun()) {
            if (VERBOSE) {
                JobManager.verbose("ABORTED request of background job - " + iJob);
            }
            return;
        }
        int n = this.awaitingJobs.length;
        if (++this.jobEnd == n) {
            this.jobEnd -= this.jobStart;
            this.awaitingJobs = new IJob[n * 2];
            System.arraycopy(this.awaitingJobs, this.jobStart, this.awaitingJobs, 0, this.jobEnd);
            this.jobStart = 0;
        }
        this.awaitingJobs[this.jobEnd] = iJob;
        if (this.enabledState() == 2) {
            this.enable();
        } else if (this.enabledState() == 1) {
            if (this.indexJob == null) {
                this.indexJob = new IndexingJob(this.thread, this);
            } else {
                this.indexJob.tickUp();
            }
        }
        if (VERBOSE) {
            JobManager.verbose("REQUEST   background job - " + iJob);
        }
    }

    public void reset() {
        if (VERBOSE) {
            JobManager.verbose("Reset");
        }
        if (this.thread != null) {
            this.discardJobs(null);
        } else {
            this.thread = new Thread((Runnable)this, this.processName());
            this.thread.setDaemon(true);
            this.thread.setPriority(4);
            this.thread.start();
        }
        this.jobSet = new HashSet();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        long l = -1L;
        this.activateProcessing();
        try {
            while (true) {
                if (this.thread == null) {
                    return;
                }
                try {
                    Object var4_5;
                    IJob iJob = this.currentJob();
                    if (iJob == null) {
                        if (l < 0L) {
                            l = System.currentTimeMillis();
                        }
                        this.notifyIdle(System.currentTimeMillis() - l);
                        Thread.sleep(500L);
                        continue;
                    }
                    l = -1L;
                    if (VERBOSE) {
                        JobManager.verbose(String.valueOf(this.awaitingJobsCount()) + " awaiting jobs");
                        JobManager.verbose("STARTING background job - " + iJob);
                    }
                    try {
                        this.executing = true;
                        iJob.execute(null);
                    }
                    catch (Throwable throwable) {
                        var4_5 = null;
                        this.executing = false;
                        this.jobFinishedNotification(this.currentJob());
                        if (VERBOSE) {
                            JobManager.verbose("FINISHED background job - " + iJob);
                        }
                        this.moveToNextJob();
                        if (this.awaitingClients != 0) throw throwable;
                        Thread.sleep(50L);
                        throw throwable;
                    }
                    {
                        var4_5 = null;
                        this.executing = false;
                        this.jobFinishedNotification(this.currentJob());
                        if (VERBOSE) {
                            JobManager.verbose("FINISHED background job - " + iJob);
                        }
                        this.moveToNextJob();
                        if (this.awaitingClients != 0) continue;
                        Thread.sleep(50L);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (RuntimeException runtimeException) {
            if (this.indexJob != null) {
                this.indexJob.done(ERROR_STATUS);
                this.indexJob = null;
            }
            if (this.thread == null) throw runtimeException;
            Util.log(runtimeException, "Background Indexer Crash Recovery", ICLogConstants.PDE);
            this.discardJobs(null);
            this.thread = null;
            this.reset();
            throw runtimeException;
        }
        catch (Error error) {
            if (this.indexJob != null) {
                this.indexJob.done(ERROR_STATUS);
                this.indexJob = null;
            }
            if (this.thread == null) throw error;
            if (error instanceof ThreadDeath) throw error;
            Util.log(error, "Background Indexer Crash Recovery", ICLogConstants.PDE);
            this.discardJobs(null);
            this.thread = null;
            this.reset();
            throw error;
        }
    }

    public void shutdown() {
        this.disable();
        this.discardJobs(null);
        Thread thread = this.thread;
        this.thread = null;
        try {
            if (thread != null) {
                thread.join();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append("Enabled:").append(this.enabled).append('\n');
        int n = this.jobEnd - this.jobStart + 1;
        stringBuffer.append("Jobs in queue:").append(n).append('\n');
        int n2 = 0;
        while (n2 < n && n2 < 15) {
            stringBuffer.append(n2).append(" - job[" + n2 + "]: ").append(this.awaitingJobs[this.jobStart + n2]).append('\n');
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected abstract void jobFinishedNotification(IJob var1);
}

