/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.util.ICacheEnumeration;
import org.eclipse.cdt.internal.core.util.ILRUCacheable;
import org.eclipse.cdt.internal.core.util.ToStringSorter;

public class LRUCache
implements Cloneable {
    protected int fCurrentSpace = 0;
    protected int fSpaceLimit;
    protected int fTimestampCounter = 0;
    protected Hashtable fEntryTable;
    protected LRUCacheEntry fEntryQueue = null;
    protected LRUCacheEntry fEntryQueueTail = null;
    protected static final int DEFAULT_SPACELIMIT = 100;

    public LRUCache() {
        this(100);
    }

    public LRUCache(int n) {
        this.fEntryTable = new Hashtable(n);
        this.fSpaceLimit = n;
    }

    public Object clone() {
        LRUCache lRUCache = this.newInstance(this.fSpaceLimit);
        LRUCacheEntry lRUCacheEntry = this.fEntryQueueTail;
        while (lRUCacheEntry != null) {
            lRUCache.privateAdd(lRUCacheEntry._fKey, lRUCacheEntry._fValue, lRUCacheEntry._fSpace);
            lRUCacheEntry = lRUCacheEntry._fPrevious;
        }
        return lRUCache;
    }

    public void flush() {
        this.fCurrentSpace = 0;
        LRUCacheEntry lRUCacheEntry = this.fEntryQueueTail;
        this.fEntryTable = new Hashtable();
        this.fEntryQueueTail = null;
        this.fEntryQueue = null;
        while (lRUCacheEntry != null) {
            this.privateNotifyDeletionFromCache(lRUCacheEntry);
            lRUCacheEntry = lRUCacheEntry._fPrevious;
        }
    }

    public void flush(Object object) {
        LRUCacheEntry lRUCacheEntry = (LRUCacheEntry)this.fEntryTable.get(object);
        if (lRUCacheEntry == null) {
            return;
        }
        this.privateRemoveEntry(lRUCacheEntry, false);
    }

    public Object get(Object object) {
        LRUCacheEntry lRUCacheEntry = (LRUCacheEntry)this.fEntryTable.get(object);
        if (lRUCacheEntry == null) {
            return null;
        }
        this.updateTimestamp(lRUCacheEntry);
        return lRUCacheEntry._fValue;
    }

    public int getCurrentSpace() {
        return this.fCurrentSpace;
    }

    public int getSpaceLimit() {
        return this.fSpaceLimit;
    }

    public Enumeration keys() {
        return this.fEntryTable.keys();
    }

    public ICacheEnumeration keysAndValues() {
        return new ICacheEnumeration(){
            Enumeration fValues;
            LRUCacheEntry fEntry;
            {
                this.fValues = LRUCache.this.fEntryTable.elements();
            }

            public boolean hasMoreElements() {
                return this.fValues.hasMoreElements();
            }

            public Object nextElement() {
                this.fEntry = (LRUCacheEntry)this.fValues.nextElement();
                return this.fEntry._fKey;
            }

            public Object getValue() {
                if (this.fEntry == null) {
                    throw new NoSuchElementException();
                }
                return this.fEntry._fValue;
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    protected boolean makeSpace(int var1_1) {
        var2_2 = this.getSpaceLimit();
        if (this.fCurrentSpace + var1_1 <= var2_2) {
            return true;
        }
        if (var1_1 <= var2_2) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            this.privateRemoveEntry(this.fEntryQueueTail, false);
lbl7:
            // 2 sources

            ** while (this.fCurrentSpace + var1_1 > var2_2 && this.fEntryQueueTail != null)
        }
lbl8:
        // 1 sources

        return true;
    }

    protected LRUCache newInstance(int n) {
        return new LRUCache(n);
    }

    protected void privateAdd(Object object, Object object2, int n) {
        LRUCacheEntry lRUCacheEntry = new LRUCacheEntry(object, object2, n);
        this.privateAddEntry(lRUCacheEntry, false);
    }

    protected void privateAddEntry(LRUCacheEntry lRUCacheEntry, boolean bl) {
        if (!bl) {
            this.fEntryTable.put(lRUCacheEntry._fKey, lRUCacheEntry);
            this.fCurrentSpace += lRUCacheEntry._fSpace;
        }
        lRUCacheEntry._fTimestamp = this.fTimestampCounter++;
        lRUCacheEntry._fNext = this.fEntryQueue;
        lRUCacheEntry._fPrevious = null;
        if (this.fEntryQueue == null) {
            this.fEntryQueueTail = lRUCacheEntry;
        } else {
            this.fEntryQueue._fPrevious = lRUCacheEntry;
        }
        this.fEntryQueue = lRUCacheEntry;
    }

    protected void privateNotifyDeletionFromCache(LRUCacheEntry lRUCacheEntry) {
    }

    protected void privateRemoveEntry(LRUCacheEntry lRUCacheEntry, boolean bl) {
        LRUCacheEntry lRUCacheEntry2 = lRUCacheEntry._fPrevious;
        LRUCacheEntry lRUCacheEntry3 = lRUCacheEntry._fNext;
        if (!bl) {
            this.fEntryTable.remove(lRUCacheEntry._fKey);
            this.fCurrentSpace -= lRUCacheEntry._fSpace;
            this.privateNotifyDeletionFromCache(lRUCacheEntry);
        }
        if (lRUCacheEntry2 == null) {
            this.fEntryQueue = lRUCacheEntry3;
        } else {
            lRUCacheEntry2._fNext = lRUCacheEntry3;
        }
        if (lRUCacheEntry3 == null) {
            this.fEntryQueueTail = lRUCacheEntry2;
        } else {
            lRUCacheEntry3._fPrevious = lRUCacheEntry2;
        }
    }

    public Object put(Object object, Object object2) {
        int n = this.spaceFor(object, object2);
        LRUCacheEntry lRUCacheEntry = (LRUCacheEntry)this.fEntryTable.get(object);
        if (lRUCacheEntry != null) {
            int n2 = lRUCacheEntry._fSpace;
            int n3 = this.getCurrentSpace() - n2 + n;
            if (n3 <= this.getSpaceLimit()) {
                this.updateTimestamp(lRUCacheEntry);
                lRUCacheEntry._fValue = object2;
                lRUCacheEntry._fSpace = n;
                this.fCurrentSpace = n3;
                return object2;
            }
            this.privateRemoveEntry(lRUCacheEntry, false);
        }
        if (this.makeSpace(n)) {
            this.privateAdd(object, object2, n);
        }
        return object2;
    }

    public Object removeKey(Object object) {
        LRUCacheEntry lRUCacheEntry = (LRUCacheEntry)this.fEntryTable.get(object);
        if (lRUCacheEntry == null) {
            return null;
        }
        Object object2 = lRUCacheEntry._fValue;
        this.privateRemoveEntry(lRUCacheEntry, false);
        return object2;
    }

    public void setSpaceLimit(int n) {
        if (n < this.fSpaceLimit) {
            this.makeSpace(this.fSpaceLimit - n);
        }
        this.fSpaceLimit = n;
    }

    protected int spaceFor(Object object, Object object2) {
        if (object2 instanceof ILRUCacheable) {
            return ((ILRUCacheable)object2).getCacheFootprint();
        }
        return 1;
    }

    public String toString() {
        return "LRUCache " + (double)this.fCurrentSpace * 100.0 / (double)this.fSpaceLimit + "% full\n" + this.toStringContents();
    }

    protected String toStringContents() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.fEntryTable.size();
        Object[] objectArray = new Object[n];
        String[] stringArray = new String[n];
        Enumeration enumeration = this.keys();
        int n2 = 0;
        while (n2 < n) {
            Object e = enumeration.nextElement();
            objectArray[n2] = e;
            stringArray[n2] = e instanceof CElement ? ((CElement)e).getElementName() : e.toString();
            ++n2;
        }
        ToStringSorter toStringSorter = new ToStringSorter();
        toStringSorter.sort(objectArray, stringArray);
        int n3 = 0;
        while (n3 < n) {
            String string = toStringSorter.sortedStrings[n3];
            Object object = this.get(toStringSorter.sortedObjects[n3]);
            stringBuffer.append(string);
            stringBuffer.append(" -> ");
            stringBuffer.append(object);
            stringBuffer.append("\n");
            ++n3;
        }
        return stringBuffer.toString();
    }

    protected void updateTimestamp(LRUCacheEntry lRUCacheEntry) {
        lRUCacheEntry._fTimestamp = this.fTimestampCounter++;
        if (this.fEntryQueue != lRUCacheEntry) {
            this.privateRemoveEntry(lRUCacheEntry, true);
            this.privateAddEntry(lRUCacheEntry, true);
        }
    }

    protected static class LRUCacheEntry {
        public Object _fKey;
        public Object _fValue;
        public int _fTimestamp;
        public int _fSpace;
        public LRUCacheEntry _fPrevious;
        public LRUCacheEntry _fNext;

        public LRUCacheEntry(Object object, Object object2, int n) {
            this._fKey = object;
            this._fValue = object2;
            this._fSpace = n;
        }

        public String toString() {
            return "LRUCacheEntry [" + this._fKey + "-->" + this._fValue + "]";
        }
    }
}

