/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.eclipse.cdt.utils.spawner.ProcessFactory;

public class Addr2line {
    private String[] args;
    private Process addr2line;
    private BufferedReader stdout;
    private BufferedWriter stdin;
    private String lastaddr;
    private String lastsymbol;
    private String lastline;

    public Addr2line(String string, String[] stringArray, String string2) throws IOException {
        this.init(string, stringArray, string2);
    }

    public Addr2line(String string, String string2) throws IOException {
        this(string, new String[0], string2);
    }

    public Addr2line(String string) throws IOException {
        this("addr2line", string);
    }

    protected void init(String string, String[] stringArray, String string2) throws IOException {
        if (stringArray == null || stringArray.length == 0) {
            this.args = new String[]{string, "-C", "-f", "-e", string2};
        } else {
            this.args = new String[stringArray.length + 1];
            this.args[0] = string;
            System.arraycopy(stringArray, 0, this.args, 1, stringArray.length);
        }
        this.addr2line = ProcessFactory.getFactory().exec(this.args);
        this.stdin = new BufferedWriter(new OutputStreamWriter(this.addr2line.getOutputStream()));
        this.stdout = new BufferedReader(new InputStreamReader(this.addr2line.getInputStream()));
    }

    protected void getOutput(String string) throws IOException {
        if (!string.equals(this.lastaddr)) {
            this.stdin.write(String.valueOf(string) + "\n");
            this.stdin.flush();
            this.lastsymbol = this.stdout.readLine();
            this.lastline = this.stdout.readLine();
            this.lastaddr = string;
        }
    }

    public String getLine(long l) throws IOException {
        this.getOutput(Integer.toHexString((int)l));
        return this.lastline;
    }

    public String getFunction(long l) throws IOException {
        this.getOutput(Integer.toHexString((int)l));
        return this.lastsymbol;
    }

    public String getFileName(long l) throws IOException {
        int n;
        String string = null;
        String string2 = this.getLine(l);
        if (string2 != null && (n = string2.lastIndexOf(58)) != -1) {
            int n2 = string2.indexOf(58);
            n2 = n == n2 ? 0 : --n2;
            string = string2.substring(n2, n);
        }
        return string;
    }

    public int getLineNumber(long l) throws IOException {
        int n = 0;
        while (n <= 20) {
            int n2;
            String string;
            String string2 = this.getLine(l);
            if (string2 != null && !(string = string2.substring((n2 = string2.lastIndexOf(58)) + 1)).startsWith("0")) {
                return Integer.parseInt(string);
            }
            l += (long)(n += 4);
        }
        return -1;
    }

    public void dispose() {
        try {
            this.stdout.close();
            this.stdin.close();
            this.addr2line.getErrorStream().close();
        }
        catch (IOException iOException) {}
        this.addr2line.destroy();
    }
}

