/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.BinaryFile;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.Objdump;
import org.eclipse.core.runtime.IPath;

public abstract class BinaryObjectAdapter
extends BinaryFile
implements IBinaryParser.IBinaryObject,
IBinaryParser.IBinaryExecutable,
IBinaryParser.IBinaryShared {
    protected IBinaryParser.ISymbol[] NO_SYMBOLS = new IBinaryParser.ISymbol[0];

    public BinaryObjectAdapter(IBinaryParser iBinaryParser, IPath iPath) {
        super(iBinaryParser, iPath);
    }

    public IBinaryParser.ISymbol getSymbol(long l) {
        Object[] objectArray = this.getSymbols();
        int n = Arrays.binarySearch(objectArray, new Long(l));
        if (n >= 0) {
            return objectArray[n];
        }
        if (n == -1) {
            return null;
        }
        Object object = objectArray[(n = -n - 1) - 1];
        if (l < object.getAddress() + object.getSize()) {
            return objectArray[n - 1];
        }
        return null;
    }

    public long getBSS() {
        BinaryObjectInfo binaryObjectInfo = this.getBinaryObjectInfo();
        if (binaryObjectInfo != null) {
            return binaryObjectInfo.bss;
        }
        return 0L;
    }

    public String getCPU() {
        BinaryObjectInfo binaryObjectInfo = this.getBinaryObjectInfo();
        if (binaryObjectInfo != null) {
            return binaryObjectInfo.cpu;
        }
        return "";
    }

    public long getData() {
        BinaryObjectInfo binaryObjectInfo = this.getBinaryObjectInfo();
        if (binaryObjectInfo != null) {
            return binaryObjectInfo.data;
        }
        return 0L;
    }

    public long getText() {
        BinaryObjectInfo binaryObjectInfo = this.getBinaryObjectInfo();
        if (binaryObjectInfo != null) {
            return binaryObjectInfo.text;
        }
        return 0L;
    }

    public boolean hasDebug() {
        BinaryObjectInfo binaryObjectInfo = this.getBinaryObjectInfo();
        if (binaryObjectInfo != null) {
            return binaryObjectInfo.hasDebug;
        }
        return false;
    }

    public boolean isLittleEndian() {
        BinaryObjectInfo binaryObjectInfo = this.getBinaryObjectInfo();
        if (binaryObjectInfo != null) {
            return binaryObjectInfo.isLittleEndian;
        }
        return false;
    }

    public String[] getNeededSharedLibs() {
        BinaryObjectInfo binaryObjectInfo = this.getBinaryObjectInfo();
        if (binaryObjectInfo != null) {
            return binaryObjectInfo.needed;
        }
        return new String[0];
    }

    public String getSoName() {
        BinaryObjectInfo binaryObjectInfo = this.getBinaryObjectInfo();
        if (binaryObjectInfo != null) {
            return binaryObjectInfo.soname;
        }
        return "";
    }

    public String getName() {
        return this.getPath().lastSegment().toString();
    }

    public InputStream getContents() {
        InputStream inputStream = null;
        Objdump objdump = this.getObjdump();
        if (objdump != null) {
            try {
                byte[] byArray = objdump.getOutput();
                inputStream = new ByteArrayInputStream(byArray);
            }
            catch (IOException iOException) {}
        }
        if (inputStream == null) {
            inputStream = super.getContents();
        }
        return inputStream;
    }

    public String toString() {
        return this.getName();
    }

    public Addr2line getAddr2line() {
        return null;
    }

    public CPPFilt getCPPFilt() {
        return null;
    }

    public Objdump getObjdump() {
        return null;
    }

    public abstract IBinaryParser.ISymbol[] getSymbols();

    protected abstract BinaryObjectInfo getBinaryObjectInfo();

    public class BinaryObjectInfo {
        public long bss;
        public long data;
        public long text;
        public boolean hasDebug;
        public boolean isLittleEndian;
        public String soname = "";
        public String[] needed = new String[0];
        public String cpu = "";
    }
}

