/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.eclipse.cdt.utils.spawner.ProcessFactory;

public class CPPFilt {
    private String[] args;
    private Process cppfilt;
    private BufferedReader stdout;
    private BufferedWriter stdin;

    public CPPFilt(String string, String[] stringArray) throws IOException {
        this.init(string, stringArray);
    }

    public CPPFilt(String string) throws IOException {
        this(string, new String[0]);
    }

    public CPPFilt() throws IOException {
        this("c++filt");
    }

    protected void init(String string, String[] stringArray) throws IOException {
        if (stringArray == null || stringArray.length == 0) {
            this.args = new String[]{string};
        } else {
            this.args = new String[stringArray.length + 1];
            this.args[0] = string;
            System.arraycopy(stringArray, 0, this.args, 1, stringArray.length);
        }
        this.cppfilt = ProcessFactory.getFactory().exec(this.args);
        this.stdin = new BufferedWriter(new OutputStreamWriter(this.cppfilt.getOutputStream()));
        this.stdout = new BufferedReader(new InputStreamReader(this.cppfilt.getInputStream()));
    }

    public String getFunction(String string) throws IOException {
        this.stdin.write(String.valueOf(string) + "\n");
        this.stdin.flush();
        String string2 = this.stdout.readLine();
        if (string2 != null) {
            return string2.trim();
        }
        throw new IOException();
    }

    public void dispose() {
        try {
            this.stdout.close();
            this.stdin.close();
            this.cppfilt.getErrorStream().close();
        }
        catch (IOException iOException) {}
        this.cppfilt.destroy();
    }
}

