/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.io.IOException;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.Objdump;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ToolsProvider
extends AbstractCExtension {
    public Addr2line getAddr2line(IPath iPath) {
        IPath iPath2 = this.getAddr2linePath();
        Addr2line addr2line = null;
        if (iPath2 != null && !iPath2.isEmpty()) {
            try {
                addr2line = new Addr2line(iPath2.toOSString(), iPath.toOSString());
            }
            catch (IOException iOException) {}
        }
        return addr2line;
    }

    public CPPFilt getCPPFilt() {
        IPath iPath = this.getCPPFiltPath();
        CPPFilt cPPFilt = null;
        if (iPath != null && !iPath.isEmpty()) {
            try {
                cPPFilt = new CPPFilt(iPath.toOSString());
            }
            catch (IOException iOException) {}
        }
        return cPPFilt;
    }

    public Objdump getObjdump(IPath iPath) {
        IPath iPath2 = this.getObjdumpPath();
        String string = this.getObjdumpArgs();
        Objdump objdump = null;
        if (iPath2 != null && !iPath2.isEmpty()) {
            try {
                objdump = new Objdump(iPath2.toOSString(), string, iPath.toOSString());
            }
            catch (IOException iOException) {}
        }
        return objdump;
    }

    protected IPath getAddr2linePath() {
        ICExtensionReference iCExtensionReference = this.getExtensionReference();
        String string = iCExtensionReference.getExtensionData("addr2line");
        if (string == null || string.length() == 0) {
            string = "addr2line";
        }
        return new Path(string);
    }

    protected IPath getObjdumpPath() {
        ICExtensionReference iCExtensionReference = this.getExtensionReference();
        String string = iCExtensionReference.getExtensionData("objdump");
        if (string == null || string.length() == 0) {
            string = "objdump";
        }
        return new Path(string);
    }

    protected String getObjdumpArgs() {
        ICExtensionReference iCExtensionReference = this.getExtensionReference();
        String string = iCExtensionReference.getExtensionData("objdumpArgs");
        if (string == null || string.length() == 0) {
            string = "";
        }
        return string;
    }

    protected IPath getCPPFiltPath() {
        ICExtensionReference iCExtensionReference = this.getExtensionReference();
        String string = iCExtensionReference.getExtensionData("c++filt");
        if (string == null || string.length() == 0) {
            string = "c++filt";
        }
        return new Path(string);
    }

    protected IPath getStripPath() {
        ICExtensionReference iCExtensionReference = this.getExtensionReference();
        String string = iCExtensionReference.getExtensionData("strip");
        if (string == null || string.length() == 0) {
            string = "strip";
        }
        return new Path(string);
    }
}

