/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.coff.ReadMemoryAccess;

public class Coff {
    public static final String NL = System.getProperty("line.separator", "\n");
    FileHeader filehdr;
    OptionalHeader opthdr;
    RandomAccessFile rfile;
    long startingOffset;
    byte[] string_table;
    SectionHeader[] scnhdrs;
    Symbol[] symbols;

    public FileHeader getFileHeader() throws IOException {
        return this.filehdr;
    }

    public OptionalHeader getOptionalHeader() throws IOException {
        return this.opthdr;
    }

    public SectionHeader[] getSectionHeaders() throws IOException {
        if (this.scnhdrs == null) {
            this.scnhdrs = new SectionHeader[this.getFileHeader().f_nscns];
            long l = 20 + this.getFileHeader().f_opthdr;
            int n = 0;
            while (n < this.scnhdrs.length) {
                this.scnhdrs[n] = new SectionHeader(this.rfile, l);
                ++n;
                l += 40L;
            }
        }
        return this.scnhdrs;
    }

    public Symbol[] getSymbols() throws IOException {
        if (this.symbols == null) {
            long l = this.getFileHeader().f_symptr;
            this.rfile.seek(l);
            this.symbols = new Symbol[this.getFileHeader().f_nsyms];
            int n = 0;
            while (n < this.symbols.length) {
                this.symbols[n] = new Symbol(this.rfile);
                ++n;
            }
        }
        return this.symbols;
    }

    public byte[] getStringTable() throws IOException {
        if (this.string_table == null) {
            long l = 18 * this.getFileHeader().f_nsyms;
            long l2 = (long)this.getFileHeader().f_symptr + l;
            this.rfile.seek(l2);
            byte[] byArray = new byte[4];
            this.rfile.readFully(byArray);
            int n = ReadMemoryAccess.getIntLE(byArray);
            if (n > 4 && (long)n < this.rfile.length()) {
                this.string_table = new byte[n -= 4];
                this.rfile.seek(l2 + 4L);
                this.rfile.readFully(this.string_table);
            } else {
                this.string_table = new byte[0];
            }
        }
        return this.string_table;
    }

    public String toString() {
        int n;
        Object[] objectArray;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            objectArray = null;
            objectArray = this.getFileHeader();
            if (objectArray != null) {
                stringBuffer.append(objectArray);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            objectArray = null;
            objectArray = this.getOptionalHeader();
            if (objectArray != null) {
                stringBuffer.append(objectArray);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            objectArray = this.getSectionHeaders();
            n = 0;
            while (n < objectArray.length) {
                stringBuffer.append(objectArray[n]);
                ++n;
            }
        }
        catch (IOException iOException) {}
        try {
            objectArray = this.getSymbols();
            n = 0;
            while (n < objectArray.length) {
                stringBuffer.append(((Symbol)objectArray[n]).getName(this.getStringTable())).append(NL);
                ++n;
            }
        }
        catch (IOException iOException) {}
        return stringBuffer.toString();
    }

    public static String[] getStringTable(byte[] byArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] == 0) {
                arrayList.add(new String(byArray, n, n2 - n));
                n = n2 + 1;
            }
            ++n2;
        }
        return arrayList.toArray(new String[0]);
    }

    public Coff(String string) throws IOException {
        this(new RandomAccessFile(string, "r"), 0L);
    }

    public Coff(RandomAccessFile randomAccessFile, long l) throws IOException {
        this.commonSetup(randomAccessFile, l);
    }

    /*
     * Exception decompiling
     */
    void commonSetup(RandomAccessFile var1_1, long var2_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 88->92)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void main(String[] stringArray) {
        try {
            Coff coff = new Coff(stringArray[0]);
            System.out.println(coff);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static class FileHeader {
        public static final int FILHSZ = 20;
        public static final int F_RELFLG = 1;
        public static final int F_EXEC = 2;
        public static final int F_LNNO = 4;
        public static final int F_LSYMS = 8;
        public static final int F_AR16WR = 128;
        public static final int F_AR32WR = 256;
        public static final int F_AR32W = 512;
        public static final int F_DYNLOAD = 4096;
        public static final int F_SHROBJ = 8192;
        public static final int F_DLL = 8192;
        public int f_magic;
        public int f_nscns;
        public int f_timdat;
        public int f_symptr;
        public int f_nsyms;
        public int f_opthdr;
        public int f_flags;

        public FileHeader(RandomAccessFile randomAccessFile) throws IOException {
            this(randomAccessFile, randomAccessFile.getFilePointer());
        }

        public FileHeader(RandomAccessFile randomAccessFile, long l) throws IOException {
            randomAccessFile.seek(l);
            byte[] byArray = new byte[20];
            randomAccessFile.readFully(byArray);
            this.commonSetup(byArray, true);
        }

        public FileHeader(byte[] byArray, boolean bl) throws EOFException {
            this.commonSetup(byArray, bl);
        }

        public void commonSetup(byte[] byArray, boolean bl) throws EOFException {
            if (byArray == null || byArray.length < 20) {
                throw new EOFException(CCorePlugin.getResourceString("Util.exception.arrayToSmall"));
            }
            ReadMemoryAccess readMemoryAccess = new ReadMemoryAccess(byArray, bl);
            this.f_magic = readMemoryAccess.getUnsignedShort();
            this.f_nscns = readMemoryAccess.getUnsignedShort();
            this.f_timdat = readMemoryAccess.getInt();
            this.f_symptr = readMemoryAccess.getInt();
            this.f_nsyms = readMemoryAccess.getInt();
            this.f_opthdr = readMemoryAccess.getUnsignedShort();
            this.f_flags = readMemoryAccess.getUnsignedShort();
        }

        public boolean isStrip() {
            return (this.f_flags & 1) == 1;
        }

        public boolean isExec() {
            return (this.f_flags & 2) == 2;
        }

        public boolean isDebug() {
            return (this.f_flags & 4) != 4;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("FILE HEADER VALUES").append(NL);
            stringBuffer.append("f_magic = ").append(this.f_magic).append(NL);
            stringBuffer.append("f_nscns = ").append(this.f_nscns).append(NL);
            stringBuffer.append("f_timdat = ");
            stringBuffer.append(DateFormat.getDateInstance().format(new Date(this.f_timdat)));
            stringBuffer.append(NL);
            stringBuffer.append("f_symptr = ").append(this.f_symptr).append(NL);
            stringBuffer.append("f_nsyms = ").append(this.f_nsyms).append(NL);
            stringBuffer.append("f_opthdr = ").append(this.f_opthdr).append(NL);
            stringBuffer.append("f_flags = ").append(this.f_flags).append(NL);
            return stringBuffer.toString();
        }
    }

    public static class OptionalHeader {
        public static final int AOUTHDRSZ = 28;
        public short magic;
        public short vstamp;
        public int tsize;
        public int dsize;
        public int bsize;
        public int entry;
        public int text_start;
        public int data_start;

        public OptionalHeader(RandomAccessFile randomAccessFile) throws IOException {
            this(randomAccessFile, randomAccessFile.getFilePointer() + 20L);
        }

        public OptionalHeader(RandomAccessFile randomAccessFile, long l) throws IOException {
            randomAccessFile.seek(l);
            byte[] byArray = new byte[28];
            randomAccessFile.readFully(byArray);
            ReadMemoryAccess readMemoryAccess = new ReadMemoryAccess(byArray, true);
            this.magic = readMemoryAccess.getShort();
            this.vstamp = readMemoryAccess.getShort();
            this.tsize = readMemoryAccess.getInt();
            this.dsize = readMemoryAccess.getInt();
            this.bsize = readMemoryAccess.getInt();
            this.entry = readMemoryAccess.getInt();
            this.text_start = readMemoryAccess.getInt();
            this.data_start = readMemoryAccess.getInt();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("OPTIONAL HEADER VALUES").append(NL);
            stringBuffer.append("magic      = ").append(this.magic).append(NL);
            stringBuffer.append("vstamp     = ").append(this.vstamp).append(NL);
            stringBuffer.append("tsize      = ").append(this.tsize).append(NL);
            stringBuffer.append("dsize      = ").append(this.dsize).append(NL);
            stringBuffer.append("bsize      = ").append(this.bsize).append(NL);
            stringBuffer.append("entry      = ").append(this.entry).append(NL);
            stringBuffer.append("text_start = ").append(this.text_start).append(NL);
            stringBuffer.append("data_start = ").append(this.data_start).append(NL);
            return stringBuffer.toString();
        }
    }

    public static class SectionHeader {
        public static final int SCNHSZ = 40;
        public static final String _TEXT = ".text";
        public static final String _DATA = ".data";
        public static final String _BSS = ".bss";
        public static final String _COMMENT = ".comment";
        public static final String _LIB = ".lib";
        public static final int STYP_REG = 0;
        public static final int STYP_DSECT = 1;
        public static final int STYP_NOLOAD = 2;
        public static final int STYP_GROUP = 4;
        public static final int STYP_PAD = 8;
        public static final int STYP_COPY = 16;
        public static final int STYP_TEXT = 32;
        public static final int S_SHRSEG = 32;
        public static final int STYP_DATA = 64;
        public static final int STYP_BSS = 128;
        public static final int S_NEWFCN = 256;
        public static final int STYP_INFO = 512;
        public static final int STYP_OVER = 1024;
        public static final int STYP_LIB = 2048;
        public static final int STYP_MERGE = 8192;
        public static final int STYP_REVERSE_PAD = 16384;
        public static final int STYP_LIT = 32800;
        public byte[] s_name = new byte[8];
        public int s_paddr;
        public int s_vaddr;
        public int s_size;
        public int s_scnptr;
        public int s_relptr;
        public int s_lnnoptr;
        public int s_nreloc;
        public int s_nlnno;
        public int s_flags;
        RandomAccessFile sfile;

        public SectionHeader(RandomAccessFile randomAccessFile, long l) throws IOException {
            this.sfile = randomAccessFile;
            randomAccessFile.seek(l);
            byte[] byArray = new byte[40];
            randomAccessFile.readFully(byArray);
            ReadMemoryAccess readMemoryAccess = new ReadMemoryAccess(byArray, true);
            readMemoryAccess.getBytes(this.s_name);
            this.s_paddr = readMemoryAccess.getInt();
            this.s_vaddr = readMemoryAccess.getInt();
            this.s_size = readMemoryAccess.getInt();
            this.s_scnptr = readMemoryAccess.getInt();
            this.s_relptr = readMemoryAccess.getInt();
            this.s_lnnoptr = readMemoryAccess.getInt();
            this.s_nreloc = readMemoryAccess.getUnsignedShort();
            this.s_nlnno = readMemoryAccess.getUnsignedShort();
            this.s_flags = readMemoryAccess.getInt();
        }

        public byte[] getRawData() throws IOException {
            byte[] byArray = new byte[this.s_size];
            this.sfile.seek(this.s_scnptr);
            this.sfile.readFully(byArray);
            return byArray;
        }

        public Reloc[] getRelocs() throws IOException {
            Reloc[] relocArray = new Reloc[this.s_nreloc];
            this.sfile.seek(this.s_relptr);
            int n = 0;
            while (n < this.s_nreloc) {
                relocArray[n] = new Reloc(this.sfile);
                ++n;
            }
            return relocArray;
        }

        public Lineno[] getLinenos() throws IOException {
            Lineno[] linenoArray = new Lineno[this.s_nlnno];
            this.sfile.seek(this.s_lnnoptr);
            int n = 0;
            while (n < this.s_nlnno) {
                linenoArray[n] = new Lineno(this.sfile);
                ++n;
            }
            return linenoArray;
        }

        public String toString() {
            int n;
            Object[] objectArray;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SECTION HEADER VALUES").append(NL);
            stringBuffer.append(new String(this.s_name)).append(NL);
            stringBuffer.append("s_paddr = ").append(this.s_paddr).append(NL);
            stringBuffer.append("s_vaddr = ").append(this.s_vaddr).append(NL);
            stringBuffer.append("s_size = ").append(this.s_size).append(NL);
            stringBuffer.append("s_scnptr = ").append(this.s_scnptr).append(NL);
            stringBuffer.append("s_relptr = ").append(this.s_relptr).append(NL);
            stringBuffer.append("s_lnnoptr = ").append(this.s_lnnoptr).append(NL);
            stringBuffer.append("s_nreloc = ").append(this.s_nreloc).append(NL);
            stringBuffer.append("s_nlnno = ").append(this.s_nlnno).append(NL);
            stringBuffer.append("s_flags = ").append(this.s_flags).append(NL);
            try {
                objectArray = this.getRelocs();
                n = 0;
                while (n < objectArray.length) {
                    stringBuffer.append(objectArray[n]);
                    ++n;
                }
            }
            catch (IOException iOException) {}
            try {
                objectArray = this.getLinenos();
                n = 0;
                while (n < objectArray.length) {
                    stringBuffer.append(objectArray[n]);
                    ++n;
                }
            }
            catch (IOException iOException) {}
            return stringBuffer.toString();
        }
    }

    public static class Reloc {
        public static final int RELSZ = 16;
        public int r_vaddr;
        public int r_symndx;
        public int r_type;

        public Reloc(RandomAccessFile randomAccessFile) throws IOException {
            this(randomAccessFile, randomAccessFile.getFilePointer());
        }

        public Reloc(RandomAccessFile randomAccessFile, long l) throws IOException {
            randomAccessFile.seek(l);
            byte[] byArray = new byte[16];
            randomAccessFile.readFully(byArray);
            ReadMemoryAccess readMemoryAccess = new ReadMemoryAccess(byArray, true);
            this.r_vaddr = readMemoryAccess.getInt();
            this.r_symndx = readMemoryAccess.getInt();
            this.r_type = readMemoryAccess.getUnsignedShort();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("RELOC VALUES").append(NL);
            stringBuffer.append("r_vaddr = ").append(this.r_vaddr);
            stringBuffer.append(" r_symndx = ").append(this.r_symndx).append(NL);
            return stringBuffer.toString();
        }
    }

    public static class Lineno {
        public static final int LINESZ = 6;
        public int l_addr;
        public int l_lnno;

        public Lineno(RandomAccessFile randomAccessFile) throws IOException {
            this(randomAccessFile, randomAccessFile.getFilePointer());
        }

        public Lineno(RandomAccessFile randomAccessFile, long l) throws IOException {
            randomAccessFile.seek(l);
            byte[] byArray = new byte[6];
            randomAccessFile.readFully(byArray);
            ReadMemoryAccess readMemoryAccess = new ReadMemoryAccess(byArray, true);
            this.l_addr = readMemoryAccess.getInt();
            this.l_lnno = readMemoryAccess.getUnsignedShort();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.l_lnno == 0) {
                stringBuffer.append("Function address = ").append(this.l_addr).append(NL);
            } else {
                stringBuffer.append("line# ").append(this.l_lnno);
                stringBuffer.append(" at address = ").append(this.l_addr).append(NL);
            }
            return stringBuffer.toString();
        }
    }

    public static class Symbol {
        public static final int SYMSZ = 18;
        public static final int SYMNMLEN = 8;
        public static final int DT_NON = 0;
        public static final int DT_PTR = 1;
        public static final int DT_FCN = 2;
        public static final int DT_ARY = 3;
        public static final int N_TMASK = 48;
        public static final int N_BTSHFT = 4;
        public static final int N_TSHIFT = 2;
        public byte[] _n_name = new byte[8];
        public int n_value;
        public short n_scnum;
        public int n_type;
        public byte n_sclass;
        public byte n_numaux;

        public Symbol(RandomAccessFile randomAccessFile) throws IOException {
            this(randomAccessFile, randomAccessFile.getFilePointer());
        }

        public Symbol(RandomAccessFile randomAccessFile, long l) throws IOException {
            randomAccessFile.seek(l);
            byte[] byArray = new byte[18];
            randomAccessFile.readFully(byArray);
            ReadMemoryAccess readMemoryAccess = new ReadMemoryAccess(byArray, true);
            readMemoryAccess.getBytes(this._n_name);
            this.n_value = readMemoryAccess.getInt();
            this.n_scnum = readMemoryAccess.getShort();
            this.n_type = readMemoryAccess.getUnsignedShort();
            this.n_sclass = readMemoryAccess.getByte();
            this.n_numaux = readMemoryAccess.getByte();
        }

        public boolean isLongName() {
            return this._n_name[0] == 0;
        }

        public String getName() {
            int n = 0;
            while (n < this._n_name.length) {
                if (this._n_name[n] == 0) {
                    return new String(this._n_name, 0, n);
                }
                ++n;
            }
            return "";
        }

        public String getName(byte[] byArray) {
            if (byArray.length > 0 && this.isLongName()) {
                ReadMemoryAccess readMemoryAccess = new ReadMemoryAccess(this._n_name, true);
                readMemoryAccess.getInt();
                int n = readMemoryAccess.getInt() - 4;
                if (n > 0) {
                    int n2 = n;
                    while (n2 < byArray.length) {
                        if (byArray[n2] == 0) {
                            return new String(byArray, n, n2 - n);
                        }
                        ++n2;
                    }
                }
            }
            return this.getName();
        }

        public boolean isPointer() {
            return (this.n_type & 0x30) == 16;
        }

        public boolean isFunction() {
            return (this.n_type & 0x30) == 32;
        }

        public boolean isArray() {
            return (this.n_type & 0x30) == 48;
        }

        public String toString() {
            return this.getName();
        }
    }
}

