/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.coff.Coff;
import org.eclipse.cdt.utils.coff.Exe;
import org.eclipse.cdt.utils.coff.ReadMemoryAccess;

public class PE {
    public static final String NL = System.getProperty("line.separator", "\n");
    RandomAccessFile rfile;
    String filename;
    Exe.ExeHeader exeHeader;
    DOSHeader dosHeader;
    Coff.FileHeader fileHeader;
    Coff.OptionalHeader optionalHeader;
    NTOptionalHeader ntHeader;
    ImageDataDirectory[] dataDirectories;
    Coff.SectionHeader[] scnhdrs;
    Coff.Symbol[] symbolTable;
    byte[] stringTable;

    public PE(String string) throws IOException {
        this(string, 0L);
    }

    public PE(String string, long l) throws IOException {
        this(string, l, true);
    }

    /*
     * Exception decompiling
     */
    public PE(String var1_1, long var2_2, boolean var4_3) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 283->287)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isValidMachine(int n) {
        switch (n) {
            case 332: 
            case 354: 
            case 358: 
            case 360: 
            case 388: 
            case 418: 
            case 422: 
            case 448: 
            case 450: 
            case 496: 
            case 512: 
            case 614: 
            case 616: 
            case 644: 
            case 870: 
            case 1126: {
                return true;
            }
        }
        return false;
    }

    public static Attribute getAttributes(Coff.FileHeader fileHeader) {
        Attribute attribute = new Attribute();
        switch (fileHeader.f_magic) {
            case 0: {
                attribute.cpu = "none";
                break;
            }
            case 388: {
                attribute.cpu = "alpha";
                break;
            }
            case 448: {
                attribute.cpu = "arm";
                break;
            }
            case 644: {
                attribute.cpu = "arm64";
                break;
            }
            case 332: {
                attribute.cpu = "x86";
                break;
            }
            case 512: {
                attribute.cpu = "ia64";
                break;
            }
            case 616: {
                attribute.cpu = "m68k";
                break;
            }
            case 614: {
                attribute.cpu = "mips16";
                break;
            }
            case 870: {
                attribute.cpu = "mipsfpu";
                break;
            }
            case 1126: {
                attribute.cpu = "mipsfpu16";
                break;
            }
            case 496: {
                attribute.cpu = "powerpc";
                break;
            }
            case 354: {
                attribute.cpu = "r3000";
                break;
            }
            case 358: {
                attribute.cpu = "r4000";
                break;
            }
            case 360: {
                attribute.cpu = "r10000";
                break;
            }
            case 418: {
                attribute.cpu = "sh3";
                break;
            }
            case 422: {
                attribute.cpu = "sh4";
                break;
            }
            case 450: {
                attribute.cpu = "thumb";
            }
        }
        attribute.type = (fileHeader.f_flags & 0x2000) != 0 ? 2 : ((fileHeader.f_flags & 2) != 0 ? 1 : 3);
        attribute.isle = true;
        if ((fileHeader.f_flags & 0x80) != 0) {
            attribute.isle = true;
        }
        if ((fileHeader.f_flags & 0x8000) != 0) {
            attribute.isle = false;
        }
        attribute.bDebug = (fileHeader.f_flags & 0x200) == 0;
        if ((fileHeader.f_flags & 0x40) != 0) {
            attribute.word = 16;
        }
        if ((fileHeader.f_flags & 0x100) != 0) {
            attribute.word = 32;
        }
        return attribute;
    }

    public static boolean isExeHeader(byte[] byArray) {
        return byArray != null && byArray.length >= 2 && byArray[0] == 77 && byArray[1] == 90;
    }

    public Attribute getAttribute() throws IOException {
        return PE.getAttributes(this.getFileHeader());
    }

    public static Attribute getAttribute(byte[] byArray) throws IOException {
        Object object;
        ReadMemoryAccess readMemoryAccess = new ReadMemoryAccess(byArray, true);
        int n = 0;
        try {
            new Exe.ExeHeader(readMemoryAccess);
            object = new DOSHeader(readMemoryAccess);
            n = ((DOSHeader)object).e_lfanew;
            if (n + 4 < byArray.length) {
                if (byArray[n + 0] != 80 || byArray[n + 1] != 69 || byArray[n + 2] != 0 || byArray[n + 3] != 0) {
                    throw new IOException(CCorePlugin.getResourceString("Util.exception.notPE"));
                }
                n += 4;
            }
        }
        catch (IOException iOException) {}
        if (n < byArray.length) {
            object = new byte[byArray.length - n];
            System.arraycopy(byArray, n, object, 0, byArray.length - n);
            Coff.FileHeader fileHeader = new Coff.FileHeader((byte[])object, true);
            if (PE.isValidMachine(fileHeader.f_magic)) {
                return PE.getAttributes(fileHeader);
            }
        }
        throw new IOException(CCorePlugin.getResourceString("Util.exception.notPE"));
    }

    public static Attribute getAttribute(String string) throws IOException {
        PE pE = new PE(string);
        Attribute attribute = pE.getAttribute();
        pE.dispose();
        return attribute;
    }

    public void dispose() throws IOException {
        if (this.rfile != null) {
            this.rfile.close();
            this.rfile = null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            super.finalize();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        super.finalize();
    }

    public Exe.ExeHeader getExeHeader() {
        return this.exeHeader;
    }

    public DOSHeader getDOSHeader() {
        return this.dosHeader;
    }

    public Coff.FileHeader getFileHeader() {
        return this.fileHeader;
    }

    public Coff.OptionalHeader getOptionalHeader() {
        return this.optionalHeader;
    }

    public NTOptionalHeader getNTOptionalHeader() {
        return this.ntHeader;
    }

    public ImageDataDirectory[] getImageDataDirectories() throws IOException {
        if (this.dataDirectories == null) {
            RandomAccessFile randomAccessFile = this.getRandomAccessFile();
            long l = 0L;
            if (this.dosHeader != null) {
                l = this.dosHeader.e_lfanew + 4;
            }
            randomAccessFile.seek(l += 116L);
            this.dataDirectories = new ImageDataDirectory[16];
            byte[] byArray = new byte[this.dataDirectories.length * 8];
            randomAccessFile.readFully(byArray);
            ReadMemoryAccess readMemoryAccess = new ReadMemoryAccess(byArray, true);
            int n = 0;
            while (n < this.dataDirectories.length) {
                int n2 = readMemoryAccess.getInt();
                int n3 = readMemoryAccess.getInt();
                this.dataDirectories[n] = new ImageDataDirectory(n2, n3);
                ++n;
            }
        }
        return this.dataDirectories;
    }

    public Coff.SectionHeader[] getSectionHeaders() throws IOException {
        if (this.scnhdrs == null) {
            RandomAccessFile randomAccessFile = this.getRandomAccessFile();
            this.scnhdrs = new Coff.SectionHeader[this.fileHeader.f_nscns];
            long l = 0L;
            if (this.dosHeader != null) {
                l = this.dosHeader.e_lfanew + 4;
            }
            l += (long)(20 + this.fileHeader.f_opthdr);
            int n = 0;
            while (n < this.scnhdrs.length) {
                this.scnhdrs[n] = new Coff.SectionHeader(randomAccessFile, l);
                ++n;
                l += 40L;
            }
        }
        return this.scnhdrs;
    }

    public Coff.Symbol[] getSymbols() throws IOException {
        if (this.symbolTable == null) {
            RandomAccessFile randomAccessFile = this.getRandomAccessFile();
            long l = this.fileHeader.f_symptr;
            this.symbolTable = new Coff.Symbol[this.fileHeader.f_nsyms];
            int n = 0;
            while (n < this.symbolTable.length) {
                this.symbolTable[n] = new Coff.Symbol(randomAccessFile, l);
                NTOptionalHeader nTOptionalHeader = this.getNTOptionalHeader();
                if (nTOptionalHeader != null) {
                    this.symbolTable[n].n_value += nTOptionalHeader.ImageBase + nTOptionalHeader.FileAlignment;
                }
                ++n;
                l += 18L;
            }
        }
        return this.symbolTable;
    }

    public byte[] getStringTable() throws IOException {
        if (this.stringTable == null) {
            if (this.fileHeader.f_nsyms > 0) {
                RandomAccessFile randomAccessFile = this.getRandomAccessFile();
                long l = 18 * this.fileHeader.f_nsyms;
                long l2 = (long)this.fileHeader.f_symptr + l;
                randomAccessFile.seek(l2);
                byte[] byArray = new byte[4];
                randomAccessFile.readFully(byArray);
                int n = ReadMemoryAccess.getIntLE(byArray);
                if (n > 4 && (long)n < randomAccessFile.length()) {
                    this.stringTable = new byte[n -= 4];
                    randomAccessFile.seek(l2 + 4L);
                    randomAccessFile.readFully(this.stringTable);
                } else {
                    this.stringTable = new byte[0];
                }
            } else {
                this.stringTable = new byte[0];
            }
        }
        return this.stringTable;
    }

    public String toString() {
        int n;
        Object[] objectArray;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.exeHeader != null) {
            stringBuffer.append(this.exeHeader);
        }
        if (this.dosHeader != null) {
            stringBuffer.append(this.dosHeader);
        }
        stringBuffer.append(this.fileHeader);
        if (this.optionalHeader != null) {
            stringBuffer.append(this.optionalHeader);
        }
        if (this.ntHeader != null) {
            stringBuffer.append(this.ntHeader);
        }
        try {
            objectArray = this.getImageDataDirectories();
            n = 0;
            while (n < objectArray.length) {
                stringBuffer.append("Entry ").append(n);
                stringBuffer.append(" ").append(objectArray[n]);
                ++n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            objectArray = this.getSectionHeaders();
            n = 0;
            while (n < objectArray.length) {
                stringBuffer.append(objectArray[n]);
                ++n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            objectArray = this.getSymbols();
            n = 0;
            while (n < objectArray.length) {
                stringBuffer.append(objectArray[n]);
                ++n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            objectArray = this.getStringTable();
            String[] stringArray = Coff.getStringTable((byte[])objectArray);
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringBuffer.append(stringArray[n2]);
                ++n2;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    RandomAccessFile getRandomAccessFile() throws IOException {
        if (this.rfile == null) {
            this.rfile = new RandomAccessFile(this.filename, "r");
        }
        return this.rfile;
    }

    public static void main(String[] stringArray) {
        try {
            PE pE = new PE(stringArray[0]);
            System.out.println(pE);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static class Attribute {
        public static final int PE_TYPE_EXE = 1;
        public static final int PE_TYPE_SHLIB = 2;
        public static final int PE_TYPE_OBJ = 3;
        public static final int PE_TYPE_CORE = 4;
        String cpu;
        int type;
        int word;
        boolean bDebug;
        boolean isle;

        public String getCPU() {
            return this.cpu;
        }

        public int getType() {
            return this.type;
        }

        public boolean hasDebug() {
            return this.bDebug;
        }

        public boolean isLittleEndian() {
            return this.isle;
        }

        public int getWord() {
            return this.word;
        }
    }

    public static class DOSHeader {
        static final int DOSHDRSZ = 100;
        byte[] e_res = new byte[8];
        byte[] e_oemid = new byte[2];
        byte[] e_oeminfo = new byte[2];
        byte[] e_res2 = new byte[20];
        int e_lfanew;
        byte[] dos_message = new byte[64];

        public DOSHeader(RandomAccessFile randomAccessFile) throws IOException {
            this(randomAccessFile, randomAccessFile.getFilePointer());
        }

        public DOSHeader(RandomAccessFile randomAccessFile, long l) throws IOException {
            randomAccessFile.seek(l);
            byte[] byArray = new byte[100];
            randomAccessFile.readFully(byArray);
            ReadMemoryAccess readMemoryAccess = new ReadMemoryAccess(byArray, true);
            this.commonSetup(readMemoryAccess);
        }

        public DOSHeader(byte[] byArray, boolean bl) throws IOException {
            ReadMemoryAccess readMemoryAccess = new ReadMemoryAccess(byArray, bl);
            this.commonSetup(readMemoryAccess);
        }

        public DOSHeader(ReadMemoryAccess readMemoryAccess) throws IOException {
            this.commonSetup(readMemoryAccess);
        }

        public void commonSetup(ReadMemoryAccess readMemoryAccess) throws IOException {
            if (readMemoryAccess.getSize() < 100) {
                throw new IOException("Not a Dos Header");
            }
            readMemoryAccess.getBytes(this.e_res);
            readMemoryAccess.getBytes(this.e_oemid);
            readMemoryAccess.getBytes(this.e_oeminfo);
            readMemoryAccess.getBytes(this.e_res2);
            this.e_lfanew = readMemoryAccess.getInt();
            readMemoryAccess.getBytes(this.dos_message);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("DOS STUB VALUES").append(NL);
            stringBuffer.append("e_lfanew = ").append(this.e_lfanew).append(NL);
            stringBuffer.append(new String(this.dos_message)).append(NL);
            return stringBuffer.toString();
        }
    }

    public static class NTOptionalHeader {
        public static final int NTHDRSZ = 68;
        public int ImageBase;
        public int SectionAlignment;
        public int FileAlignment;
        public short MajorOperatingSystemVersion;
        public short MinorOperatingSystemVersion;
        public short MajorImageVersion;
        public short MinorImageVersion;
        public short MajorSubsystemVersion;
        public short MinorSubsystemVersion;
        public byte[] Reserved = new byte[4];
        public int SizeOfImage;
        public int SizeOfHeaders;
        public int CheckSum;
        public short Subsystem;
        public short DLLCharacteristics;
        public int SizeOfStackReserve;
        public int SizeOfStackCommit;
        public int SizeOfHeapReserve;
        public int SizeOfHeapCommit;
        public int LoaderFlags;
        public int NumberOfRvaAndSizes;

        public NTOptionalHeader(RandomAccessFile randomAccessFile) throws IOException {
            this(randomAccessFile, randomAccessFile.getFilePointer());
        }

        public NTOptionalHeader(RandomAccessFile randomAccessFile, long l) throws IOException {
            randomAccessFile.seek(l);
            byte[] byArray = new byte[68];
            randomAccessFile.readFully(byArray);
            ReadMemoryAccess readMemoryAccess = new ReadMemoryAccess(byArray, true);
            this.ImageBase = readMemoryAccess.getInt();
            this.SectionAlignment = readMemoryAccess.getInt();
            this.FileAlignment = readMemoryAccess.getInt();
            this.MajorOperatingSystemVersion = readMemoryAccess.getShort();
            this.MinorOperatingSystemVersion = readMemoryAccess.getShort();
            this.MajorImageVersion = readMemoryAccess.getShort();
            this.MinorImageVersion = readMemoryAccess.getShort();
            this.MajorSubsystemVersion = readMemoryAccess.getShort();
            this.MinorSubsystemVersion = readMemoryAccess.getShort();
            readMemoryAccess.getBytes(this.Reserved);
            this.SizeOfImage = readMemoryAccess.getInt();
            this.SizeOfHeaders = readMemoryAccess.getInt();
            this.CheckSum = readMemoryAccess.getInt();
            this.Subsystem = readMemoryAccess.getShort();
            this.DLLCharacteristics = readMemoryAccess.getShort();
            this.SizeOfStackReserve = readMemoryAccess.getInt();
            this.SizeOfStackCommit = readMemoryAccess.getInt();
            this.SizeOfHeapReserve = readMemoryAccess.getInt();
            this.SizeOfHeapCommit = readMemoryAccess.getInt();
            this.LoaderFlags = readMemoryAccess.getInt();
            this.NumberOfRvaAndSizes = readMemoryAccess.getInt();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NT OPTIONAL HEADER VALUES").append(NL);
            stringBuffer.append("ImageBase = ").append(this.ImageBase).append(NL);
            stringBuffer.append("SexctionAlignement = ").append(this.SectionAlignment).append(NL);
            stringBuffer.append("FileAlignment = ").append(this.FileAlignment).append(NL);
            stringBuffer.append("MajorOSVersion = ").append(this.MajorOperatingSystemVersion).append(NL);
            stringBuffer.append("MinorOSVersion = ").append(this.MinorOperatingSystemVersion).append(NL);
            stringBuffer.append("MajorImageVersion = ").append(this.MajorImageVersion).append(NL);
            stringBuffer.append("MinorImageVersion = ").append(this.MinorImageVersion).append(NL);
            stringBuffer.append("MajorSubVersion = ").append(this.MajorSubsystemVersion).append(NL);
            stringBuffer.append("MinorSubVersion = ").append(this.MinorSubsystemVersion).append(NL);
            stringBuffer.append("Reserved = ").append(this.Reserved).append(NL);
            stringBuffer.append("SizeOfImage = ").append(this.SizeOfImage).append(NL);
            stringBuffer.append("SizeOfHeaders = ").append(this.SizeOfHeaders).append(NL);
            stringBuffer.append("CheckSum = ").append(this.CheckSum).append(NL);
            stringBuffer.append("Subsystem = ").append(this.Subsystem).append(NL);
            stringBuffer.append("DLL = ").append(this.DLLCharacteristics).append(NL);
            stringBuffer.append("StackReserve = ").append(this.SizeOfStackReserve).append(NL);
            stringBuffer.append("StackCommit = ").append(this.SizeOfStackCommit).append(NL);
            stringBuffer.append("HeapReserve = ").append(this.SizeOfHeapReserve).append(NL);
            stringBuffer.append("HeapCommit = ").append(this.SizeOfHeapCommit).append(NL);
            stringBuffer.append("LoaderFlags = ").append(this.LoaderFlags).append(NL);
            stringBuffer.append("#Rva size = ").append(this.NumberOfRvaAndSizes).append(NL);
            return stringBuffer.toString();
        }
    }

    public class ImageDataDirectory {
        public int rva;
        public int size;

        public ImageDataDirectory(int n, int n2) {
            this.rva = n;
            this.size = n2;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("rva = ").append(this.rva).append(" ");
            stringBuffer.append("size = ").append(this.size).append(NL);
            return stringBuffer.toString();
        }
    }

    public class ImportDirectoryEntry {
        public static final int ENTRYSZ = 20;
        public int rva;
        public int timestamp;
        public int forwarder;
        public int name;
        public int thunk;

        public ImportDirectoryEntry(RandomAccessFile randomAccessFile) throws IOException {
            this(randomAccessFile, randomAccessFile.getFilePointer());
        }

        public ImportDirectoryEntry(RandomAccessFile randomAccessFile, long l) throws IOException {
            randomAccessFile.seek(l);
            byte[] byArray = new byte[20];
            randomAccessFile.readFully(byArray);
            ReadMemoryAccess readMemoryAccess = new ReadMemoryAccess(byArray, true);
            this.rva = readMemoryAccess.getInt();
            this.timestamp = readMemoryAccess.getInt();
            this.forwarder = readMemoryAccess.getInt();
            this.name = readMemoryAccess.getInt();
            this.thunk = readMemoryAccess.getInt();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("rva = ").append(this.rva);
            stringBuffer.append(" timestamp = ").append(this.timestamp);
            stringBuffer.append(" forwarder = ").append(this.forwarder);
            stringBuffer.append(" name = ").append(this.name);
            stringBuffer.append(" thunk = ").append(this.thunk).append(NL);
            return stringBuffer.toString();
        }
    }
}

