/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff.parser;

import java.io.EOFException;
import java.io.IOException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.CygwinToolsProvider;
import org.eclipse.cdt.utils.coff.PE;
import org.eclipse.cdt.utils.coff.PEArchive;
import org.eclipse.cdt.utils.coff.parser.BinaryArchive;
import org.eclipse.cdt.utils.coff.parser.PEBinaryObject;
import org.eclipse.core.runtime.IPath;

public class PEParser
extends CygwinToolsProvider
implements IBinaryParser {
    public IBinaryParser.IBinaryFile getBinary(IPath iPath) throws IOException {
        return this.getBinary(null, iPath);
    }

    public IBinaryParser.IBinaryFile getBinary(byte[] byArray, IPath iPath) throws IOException {
        if (iPath == null) {
            throw new IOException(CCorePlugin.getResourceString("Util.exception.nullPath"));
        }
        IBinaryParser.IBinaryFile iBinaryFile = null;
        try {
            PE.Attribute attribute = null;
            if (byArray != null && byArray.length > 0) {
                try {
                    attribute = PE.getAttribute(byArray);
                }
                catch (EOFException eOFException) {}
            }
            if (attribute == null) {
                attribute = PE.getAttribute(iPath.toOSString());
            }
            if (attribute != null) {
                switch (attribute.getType()) {
                    case 1: {
                        iBinaryFile = this.createBinaryExecutable(iPath);
                        break;
                    }
                    case 2: {
                        iBinaryFile = this.createBinaryShared(iPath);
                        break;
                    }
                    case 3: {
                        iBinaryFile = this.createBinaryObject(iPath);
                        break;
                    }
                    case 4: {
                        iBinaryFile = this.createBinaryCore(iPath);
                    }
                }
            }
        }
        catch (IOException iOException) {
            iBinaryFile = this.createBinaryArchive(iPath);
        }
        return iBinaryFile;
    }

    public String getFormat() {
        return "PE";
    }

    public boolean isBinary(byte[] byArray, IPath iPath) {
        boolean bl;
        boolean bl2 = bl = PE.isExeHeader(byArray) || PEArchive.isARHeader(byArray);
        if (!bl && byArray.length > 1) {
            int n = (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
            switch (n) {
                case 332: 
                case 354: 
                case 358: 
                case 360: 
                case 388: 
                case 418: 
                case 422: 
                case 448: 
                case 450: 
                case 496: 
                case 512: 
                case 614: 
                case 616: 
                case 644: 
                case 870: 
                case 1126: {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public int getHintBufferSize() {
        return 512;
    }

    protected IBinaryParser.IBinaryExecutable createBinaryExecutable(IPath iPath) {
        return new PEBinaryObject(this, iPath){

            public int getType() {
                return 2;
            }
        };
    }

    protected IBinaryParser.IBinaryObject createBinaryCore(IPath iPath) {
        return new PEBinaryObject(this, iPath){

            public int getType() {
                return 16;
            }
        };
    }

    protected IBinaryParser.IBinaryObject createBinaryObject(IPath iPath) {
        return new PEBinaryObject(this, iPath){

            public int getType() {
                return 1;
            }
        };
    }

    protected IBinaryParser.IBinaryShared createBinaryShared(IPath iPath) {
        return new PEBinaryObject(this, iPath){

            public int getType() {
                return 4;
            }
        };
    }

    protected IBinaryParser.IBinaryArchive createBinaryArchive(IPath iPath) throws IOException {
        return new BinaryArchive(this, iPath);
    }
}

