/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.debug.stabs;

import org.eclipse.cdt.core.CCorePlugin;

public class StringField {
    String name;
    char symbolDescriptor;
    String typeInformation;

    public StringField(String string) {
        this.parseStringField(string.toCharArray());
    }

    public String getName() {
        return this.name;
    }

    public char getSymbolDescriptor() {
        return this.symbolDescriptor;
    }

    public String getTypeInformation() {
        return this.typeInformation;
    }

    void parseStringField(char[] cArray) {
        int n = 0;
        char c = '\u0000';
        while (n < cArray.length) {
            char c2 = cArray[n];
            if (c2 == ':' && c != ':') break;
            c = c2;
            ++n;
        }
        this.name = n < cArray.length ? new String(cArray, 0, n) : new String(cArray);
        if (this.name.length() > 1 && this.name.charAt(0) == '$') {
            switch (this.name.charAt(1)) {
                case 't': {
                    this.name = "this";
                    break;
                }
                case 'v': {
                    break;
                }
                case 'e': {
                    this.name = "eh_throw";
                    break;
                }
                case '_': {
                    break;
                }
                case 'X': {
                    break;
                }
                default: {
                    this.name = CCorePlugin.getResourceString("StringField.unknownName");
                }
            }
        }
        if (n < cArray.length && Character.isLetter(cArray[++n])) {
            this.symbolDescriptor = cArray[n];
            ++n;
        }
        this.typeInformation = n < cArray.length ? new String(cArray, n, cArray.length - n) : new String();
    }
}

