/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.debug.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.utils.debug.DebugParameterKind;
import org.eclipse.cdt.utils.debug.DebugType;
import org.eclipse.cdt.utils.debug.DebugVariableKind;
import org.eclipse.cdt.utils.debug.IDebugEntryRequestor;
import org.eclipse.cdt.utils.debug.tools.DebugSym;

public class DebugSymsRequestor
implements IDebugEntryRequestor {
    DebugSym currentCU;
    DebugSym currentFunction;
    List list = new ArrayList();

    public DebugSym[] getSortedEntries() {
        Object[] objectArray = this.getEntries();
        Arrays.sort(objectArray);
        return objectArray;
    }

    public DebugSym[] getEntries() {
        DebugSym[] debugSymArray = new DebugSym[this.list.size()];
        this.list.toArray(debugSymArray);
        return debugSymArray;
    }

    public DebugSym getEntry(long l) {
        Object[] objectArray = this.getSortedEntries();
        int n = Arrays.binarySearch(objectArray, new Long(l));
        if (n >= 0) {
            return objectArray[n];
        }
        if (n == -1) {
            return null;
        }
        n = -n - 1;
        Object object = objectArray[n - 1];
        if (l < ((DebugSym)object).addr + ((DebugSym)object).size) {
            return objectArray[n - 1];
        }
        return null;
    }

    public void enterCompilationUnit(String string, long l) {
        DebugSym debugSym = new DebugSym();
        debugSym.name = string;
        debugSym.addr = l;
        debugSym.type = "CU";
        debugSym.filename = string;
        this.currentCU = debugSym;
        this.list.add(debugSym);
    }

    public void exitCompilationUnit(long l) {
        if (this.currentCU != null) {
            this.currentCU.size = l;
        }
        this.currentCU = null;
    }

    public void enterInclude(String string) {
    }

    public void exitInclude() {
    }

    public void enterFunction(String string, DebugType debugType, boolean bl, long l) {
        DebugSym debugSym = new DebugSym();
        debugSym.name = string;
        debugSym.addr = l;
        debugSym.type = "Func";
        if (this.currentCU != null) {
            debugSym.filename = this.currentCU.filename;
        }
        this.currentFunction = debugSym;
        this.list.add(debugSym);
    }

    public void exitFunction(long l) {
        if (this.currentFunction != null) {
            this.currentFunction.size = l;
        }
        this.currentFunction = null;
    }

    public void enterCodeBlock(long l) {
    }

    public void exitCodeBlock(long l) {
    }

    public void acceptStatement(int n, long l) {
        DebugSym debugSym = new DebugSym();
        debugSym.name = "";
        debugSym.addr = l;
        debugSym.startLine = n;
        debugSym.type = "SLINE";
        if (this.currentFunction != null) {
            if (this.currentFunction.startLine == 0) {
                this.currentFunction.startLine = n;
            }
            this.currentFunction.endLine = n;
        }
        if (this.currentCU != null) {
            debugSym.filename = this.currentCU.filename;
        }
        this.list.add(debugSym);
    }

    public void acceptIntegerConst(String string, int n) {
    }

    public void acceptFloatConst(String string, double d) {
    }

    public void acceptTypeConst(String string, DebugType debugType, int n) {
    }

    public void acceptParameter(String string, DebugType debugType, DebugParameterKind debugParameterKind, long l) {
        DebugSym debugSym = new DebugSym();
        debugSym.name = string;
        debugSym.addr = l;
        debugSym.type = "PARAM";
        if (this.currentCU != null) {
            debugSym.filename = this.currentCU.filename;
        }
        this.list.add(debugSym);
    }

    public void acceptVariable(String string, DebugType debugType, DebugVariableKind debugVariableKind, long l) {
        DebugSym debugSym = new DebugSym();
        debugSym.name = string;
        debugSym.addr = l;
        debugSym.type = "VAR";
        if (this.currentCU != null) {
            debugSym.filename = this.currentCU.filename;
        }
        this.list.add(debugSym);
    }

    public void acceptCaughtException(String string, DebugType debugType, long l) {
    }

    public void acceptTypeDef(String string, DebugType debugType) {
    }
}

