/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.pty;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.pty.PTYInputStream;
import org.eclipse.cdt.utils.pty.PTYOutputStream;

public class PTY {
    String slave;
    InputStream in;
    OutputStream out;
    int master;
    private static boolean hasPTY;

    static {
        try {
            System.loadLibrary("pty");
            hasPTY = true;
        }
        catch (SecurityException securityException) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
    }

    public PTY() throws IOException {
        if (hasPTY) {
            this.slave = this.forkpty();
        }
        if (this.slave == null) {
            throw new IOException(CCorePlugin.getResourceString("Util.exception.cannotCreatePty"));
        }
        this.in = new PTYInputStream(new MasterFD());
        this.out = new PTYOutputStream(new MasterFD());
    }

    public String getSlaveName() {
        return this.slave;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    native String forkpty();

    public class MasterFD {
        public int getFD() {
            return PTY.this.master;
        }

        public void setFD(int n) {
            PTY.this.master = n;
        }
    }
}

