/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.som;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.coff.ReadMemoryAccess;
import org.eclipse.cdt.utils.som.SOM;

public class AR {
    public static final String NL = System.getProperty("line.separator", "\n");
    protected String filename;
    protected RandomAccessFile file;
    private byte[] ar_magic = new byte[8];
    private LSTHeader lstHeader;
    private ARHeader[] memberHeaders;

    public AR(String string) throws IOException {
        this.filename = string;
        this.file = new RandomAccessFile(string, "r");
        this.file.read(this.ar_magic);
        if (!AR.isARHeader(this.ar_magic)) {
            this.file.close();
            throw new IOException(CCorePlugin.getResourceString("Util.exception.invalidArchive"));
        }
        this.lstHeader = new LSTHeader();
    }

    public void dispose() {
        try {
            if (this.file != null) {
                this.file.close();
                this.file = null;
            }
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            super.finalize();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        super.finalize();
    }

    public static boolean isARHeader(byte[] byArray) {
        return byArray.length >= 8 && byArray[0] == 33 && byArray[1] == 60 && byArray[2] == 97 && byArray[3] == 114 && byArray[4] == 99 && byArray[5] == 104 && byArray[6] == 62 && byArray[7] == 10;
    }

    private RandomAccessFile getRandomAccessFile() throws IOException {
        if (this.file == null) {
            this.file = new RandomAccessFile(this.filename, "r");
        }
        return this.file;
    }

    public ARHeader[] getHeaders() throws IOException {
        this.loadHeaders();
        return this.memberHeaders;
    }

    private void loadHeaders() throws IOException {
        if (this.memberHeaders != null) {
            return;
        }
        Vector<ARHeader> vector = new Vector<ARHeader>();
        try {
            long l = this.lstHeader.dir_loc + 68;
            int n = this.lstHeader.module_limit * 8;
            this.getRandomAccessFile();
            this.file.seek(l);
            byte[] byArray = new byte[n];
            this.file.readFully(byArray);
            ReadMemoryAccess readMemoryAccess = new ReadMemoryAccess(byArray, false);
            int n2 = 0;
            while (n2 < this.lstHeader.module_limit) {
                int n3 = readMemoryAccess.getInt();
                int n4 = readMemoryAccess.getInt();
                ARHeader aRHeader = new ARHeader(n3 - 60);
                aRHeader.somOffset = n3;
                aRHeader.somSize = n4;
                vector.add(aRHeader);
                ++n2;
            }
        }
        catch (IOException iOException) {}
        this.memberHeaders = vector.toArray(new ARHeader[vector.size()]);
    }

    public String[] extractFiles(String string) throws IOException {
        return this.extractFiles(string, null);
    }

    private String[] extractFiles(String string, String[] stringArray) throws IOException {
        Vector<String> vector = new Vector<String>();
        this.loadHeaders();
        int n = 0;
        int n2 = 0;
        while (n2 < this.memberHeaders.length) {
            String string2 = this.memberHeaders[n2].getObjectName();
            if (stringArray == null || this.stringInStrings(string2, stringArray)) {
                string2 = n + "_" + string2;
                ++n;
                byte[] byArray = this.memberHeaders[n2].getObjectData();
                File file = new File(string, string2);
                vector.add(string2);
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                randomAccessFile.write(byArray);
                randomAccessFile.close();
            }
            ++n2;
        }
        return vector.toArray(new String[0]);
    }

    private boolean stringInStrings(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (string.compareTo(stringArray[n]) == 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.lstHeader != null) {
            stringBuffer.append("LST HEADER VALUES").append(NL);
            stringBuffer.append("system_id    = ").append(this.lstHeader.system_id).append(NL);
            stringBuffer.append("a_magic      = ").append(this.lstHeader.a_magic).append(NL);
            stringBuffer.append("version_id   = ").append(this.lstHeader.version_id).append(NL);
            stringBuffer.append("module_count = ").append(this.lstHeader.module_count).append(NL);
            stringBuffer.append("module_limit = ").append(this.lstHeader.module_limit).append(NL);
            stringBuffer.append("dir_loc      = ").append(this.lstHeader.dir_loc).append(NL);
            int n = 0;
            while (n < this.memberHeaders.length) {
                stringBuffer.append("MEMBER HEADER VALUES").append(NL);
                stringBuffer.append("name      = ").append(this.memberHeaders[n].getObjectName()).append(NL);
                stringBuffer.append("somOffset = ").append(this.memberHeaders[n].somOffset).append(NL);
                stringBuffer.append("somSize   = ").append(this.memberHeaders[n].getSize()).append(NL);
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            AR aR = new AR(stringArray[0]);
            aR.getHeaders();
            aR.extractFiles(stringArray[1]);
            System.out.println(aR);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public class ARHeader {
        public static final int HEADER_SIZE = 60;
        private byte[] ar_name = new byte[16];
        private byte[] ar_date = new byte[12];
        private byte[] ar_uid = new byte[6];
        private byte[] ar_gid = new byte[6];
        private byte[] ar_mode = new byte[8];
        private byte[] ar_size = new byte[10];
        private byte[] ar_fmag = new byte[2];
        String name;
        public int somOffset;
        public int somSize;

        public ARHeader(long l) throws IOException {
            try {
                AR.this.getRandomAccessFile();
                AR.this.file.seek(l);
                AR.this.file.read(this.ar_name);
                int n = 0;
                while (n < 16) {
                    if (this.ar_name[n] == 47) {
                        this.name = new String(this.ar_name, 0, n);
                    }
                    ++n;
                }
                AR.this.file.read(this.ar_date);
                AR.this.file.read(this.ar_uid);
                AR.this.file.read(this.ar_gid);
                AR.this.file.read(this.ar_mode);
                AR.this.file.read(this.ar_size);
                AR.this.file.read(this.ar_fmag);
            }
            catch (IOException iOException) {
                AR.this.dispose();
                CCorePlugin.log(iOException);
            }
        }

        public String getObjectName() {
            return this.name;
        }

        public long getSize() {
            return this.somSize;
        }

        public byte[] getObjectData() throws IOException {
            byte[] byArray = new byte[this.somSize];
            AR.this.file = AR.this.getRandomAccessFile();
            AR.this.file.seek(this.somOffset);
            AR.this.file.read(byArray);
            AR.this.dispose();
            return byArray;
        }

        public SOM getSOM() throws IOException {
            return new SOM(AR.this.filename, this.somOffset);
        }
    }

    public class LSTHeader {
        public static final int LST_HEADER_OFFSET = 68;
        public static final int LST_HEADER_SIZE = 76;
        public short system_id;
        public short a_magic;
        public int version_id;
        public int file_time_sec;
        public int file_time_nano;
        public int hash_loc;
        public int hash_size;
        public int module_count;
        public int module_limit;
        public int dir_loc;
        public int export_loc;
        public int export_count;
        public int import_loc;
        public int aux_loc;
        public int aux_size;
        public int string_loc;
        public int string_size;
        public int free_list;
        public int file_end;
        public int checksum;

        public LSTHeader() throws IOException {
            try {
                AR.this.getRandomAccessFile();
                AR.this.file.seek(68L);
                byte[] byArray = new byte[76];
                AR.this.file.readFully(byArray);
                ReadMemoryAccess readMemoryAccess = new ReadMemoryAccess(byArray, false);
                this.system_id = readMemoryAccess.getShort();
                this.a_magic = readMemoryAccess.getShort();
                this.version_id = readMemoryAccess.getInt();
                this.file_time_sec = readMemoryAccess.getInt();
                this.file_time_nano = readMemoryAccess.getInt();
                this.hash_loc = readMemoryAccess.getInt();
                this.hash_size = readMemoryAccess.getInt();
                this.module_count = readMemoryAccess.getInt();
                this.module_limit = readMemoryAccess.getInt();
                this.dir_loc = readMemoryAccess.getInt();
                this.export_loc = readMemoryAccess.getInt();
                this.export_count = readMemoryAccess.getInt();
                this.import_loc = readMemoryAccess.getInt();
                this.aux_loc = readMemoryAccess.getInt();
                this.aux_size = readMemoryAccess.getInt();
                this.string_loc = readMemoryAccess.getInt();
                this.string_size = readMemoryAccess.getInt();
                this.free_list = readMemoryAccess.getInt();
                this.file_end = readMemoryAccess.getInt();
                this.checksum = readMemoryAccess.getInt();
            }
            catch (IOException iOException) {
                AR.this.dispose();
                CCorePlugin.log(iOException);
            }
        }
    }
}

