/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.som;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.coff.ReadMemoryAccess;

public class SOM {
    public static final String NL = System.getProperty("line.separator", "\n");
    String filename;
    FileHeader filehdr;
    RandomAccessFile rfile;
    long startingOffset;
    byte[] string_table;
    Symbol[] symbols;

    protected SOM() {
    }

    public SOM(String string) throws IOException {
        this(string, 0L);
    }

    public SOM(String string, long l) throws IOException {
        this.filename = string;
        this.commonSetup(new RandomAccessFile(string, "r"), l);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void commonSetup(RandomAccessFile randomAccessFile, long l) throws IOException {
        this.startingOffset = l;
        this.rfile = randomAccessFile;
        try {
            this.filehdr = new FileHeader(this.rfile, this.startingOffset);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.dispose();
            throw throwable;
        }
        {
            Object var4_5 = null;
        }
        this.dispose();
    }

    public void dispose() throws IOException {
        if (this.rfile != null) {
            this.rfile.close();
            this.rfile = null;
        }
    }

    RandomAccessFile getRandomAccessFile() throws IOException {
        if (this.rfile == null) {
            this.rfile = new RandomAccessFile(this.filename, "r");
        }
        return this.rfile;
    }

    public FileHeader getFileHeader() throws IOException {
        return this.filehdr;
    }

    public Attribute getAttributes() {
        Attribute attribute = new Attribute();
        switch (this.filehdr.system_id) {
            case 523: 
            case 528: 
            case 532: {
                attribute.cpu = "PA_RISC";
                break;
            }
            default: {
                attribute.cpu = "unknown";
            }
        }
        switch (this.filehdr.a_magic) {
            case 260: 
            case 263: 
            case 264: 
            case 267: {
                attribute.type = 1;
                break;
            }
            case 269: 
            case 270: {
                attribute.type = 2;
                break;
            }
            default: {
                attribute.type = 3;
            }
        }
        attribute.isle = false;
        attribute.bDebug = this.filehdr.symbol_location != 0 || this.filehdr.symbol_total != 0;
        return attribute;
    }

    public Symbol[] getSymbols() throws IOException {
        if (this.symbols == null) {
            long l = this.startingOffset + (long)this.getFileHeader().symbol_location;
            this.getRandomAccessFile();
            this.rfile.seek(l);
            int n = this.getFileHeader().symbol_total;
            ArrayList<Symbol> arrayList = new ArrayList<Symbol>(n);
            int n2 = 0;
            while (n2 < n) {
                Symbol symbol = new Symbol(this.rfile);
                arrayList.add(symbol);
                ++n2;
            }
            this.symbols = arrayList.toArray(new Symbol[arrayList.size()]);
        }
        return this.symbols;
    }

    public byte[] getStringTable() throws IOException {
        if (this.string_table == null) {
            if (this.getFileHeader().symbol_strings_size > 0) {
                this.getRandomAccessFile();
                long l = this.startingOffset + (long)this.getFileHeader().symbol_strings_location;
                this.rfile.seek(l);
                this.string_table = new byte[this.getFileHeader().symbol_strings_size];
                this.rfile.readFully(this.string_table);
            } else {
                this.string_table = new byte[0];
            }
        }
        return this.string_table;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            FileHeader fileHeader = null;
            fileHeader = this.getFileHeader();
            if (fileHeader != null) {
                stringBuffer.append(fileHeader);
            }
            this.getSymbols();
            int n = 0;
            while (n < this.symbols.length) {
                stringBuffer.append(this.symbols[n]);
                ++n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public static boolean isSOMHeader(byte[] byArray) {
        return byArray != null && byArray[0] == 2 && (byArray[1] == 11 || byArray[1] == 16 || byArray[1] == 20);
    }

    public static Attribute getAttributes(byte[] byArray) throws IOException {
        SOM sOM = new SOM();
        sOM.filehdr = new FileHeader(byArray, false);
        Attribute attribute = sOM.getAttributes();
        sOM.dispose();
        return attribute;
    }

    public static Attribute getAttributes(String string) throws IOException {
        SOM sOM = new SOM(string);
        Attribute attribute = sOM.getAttributes();
        sOM.dispose();
        return attribute;
    }

    public static void main(String[] stringArray) {
        try {
            SOM sOM = new SOM(stringArray[0]);
            System.out.println(sOM);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static class FileHeader {
        public static final int FILHSZ = 128;
        public static final short PA_RISC_10 = 523;
        public static final short PA_RISC_11 = 528;
        public static final short PA_RISC_20 = 532;
        public static final short EXE_SOM_LIB = 260;
        public static final short REL_SOM = 262;
        public static final short PRIV_EXEC_SOM = 263;
        public static final short SHARE_EXEC_SOM = 264;
        public static final short SHARE_DEMAND_LOAD_EXE_SOM = 267;
        public static final short DYN_LOAD_LIB = 269;
        public static final short SHARED_LIB = 270;
        public static final short RELOC_SOM_LIB = 1561;
        public short system_id;
        public short a_magic;
        public int version_id;
        public long file_time_sec;
        public long file_time_nano;
        public int entry_space;
        public int entry_subspace;
        public int entry_offset;
        public int aux_header_location;
        public int aux_header_size;
        public int som_length;
        public int presumed_dp;
        public int space_location;
        public int space_total;
        public int subspace_location;
        public int subspace_total;
        public int loader_fixup_location;
        public int loader_fixup_total;
        public int space_strings_location;
        public int space_strings_size;
        public int init_array_location;
        public int init_array_total;
        public int compiler_location;
        public int compiler_total;
        public int symbol_location;
        public int symbol_total;
        public int fixup_request_location;
        public int fixup_request_total;
        public int symbol_strings_location;
        public int symbol_strings_size;
        public int unloadable_sp_location;
        public int unloadable_sp_size;
        public int checksum;

        public FileHeader(RandomAccessFile randomAccessFile) throws IOException {
            this(randomAccessFile, randomAccessFile.getFilePointer());
        }

        public FileHeader(RandomAccessFile randomAccessFile, long l) throws IOException {
            randomAccessFile.seek(l);
            byte[] byArray = new byte[128];
            randomAccessFile.readFully(byArray);
            this.commonSetup(byArray, false);
        }

        public FileHeader(byte[] byArray, boolean bl) throws IOException {
            this.commonSetup(byArray, bl);
        }

        public void commonSetup(byte[] byArray, boolean bl) throws IOException {
            if (byArray == null || byArray.length < 128) {
                throw new EOFException(CCorePlugin.getResourceString("Util.exception.arrayToSmall"));
            }
            if (!SOM.isSOMHeader(byArray)) {
                throw new IOException(CCorePlugin.getResourceString("Util.exception.notSOM"));
            }
            ReadMemoryAccess readMemoryAccess = new ReadMemoryAccess(byArray, bl);
            this.system_id = readMemoryAccess.getShort();
            this.a_magic = readMemoryAccess.getShort();
            this.version_id = readMemoryAccess.getInt();
            this.file_time_sec = readMemoryAccess.getInt();
            this.file_time_nano = readMemoryAccess.getInt();
            this.entry_space = readMemoryAccess.getInt();
            this.entry_subspace = readMemoryAccess.getInt();
            this.entry_offset = readMemoryAccess.getInt();
            this.aux_header_location = readMemoryAccess.getInt();
            this.aux_header_size = readMemoryAccess.getInt();
            this.som_length = readMemoryAccess.getInt();
            this.presumed_dp = readMemoryAccess.getInt();
            this.space_location = readMemoryAccess.getInt();
            this.space_total = readMemoryAccess.getInt();
            this.subspace_location = readMemoryAccess.getInt();
            this.subspace_total = readMemoryAccess.getInt();
            this.loader_fixup_location = readMemoryAccess.getInt();
            this.loader_fixup_total = readMemoryAccess.getInt();
            this.space_strings_location = readMemoryAccess.getInt();
            this.space_strings_size = readMemoryAccess.getInt();
            this.init_array_location = readMemoryAccess.getInt();
            this.init_array_total = readMemoryAccess.getInt();
            this.compiler_location = readMemoryAccess.getInt();
            this.compiler_total = readMemoryAccess.getInt();
            this.symbol_location = readMemoryAccess.getInt();
            this.symbol_total = readMemoryAccess.getInt();
            this.fixup_request_location = readMemoryAccess.getInt();
            this.fixup_request_total = readMemoryAccess.getInt();
            this.symbol_strings_location = readMemoryAccess.getInt();
            this.symbol_strings_size = readMemoryAccess.getInt();
            this.unloadable_sp_location = readMemoryAccess.getInt();
            this.unloadable_sp_size = readMemoryAccess.getInt();
            this.checksum = readMemoryAccess.getInt();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("FILE HEADER VALUES").append(NL);
            stringBuffer.append("system_id               = ").append(this.system_id).append(NL);
            stringBuffer.append("a_magic                 = ").append(this.a_magic).append(NL);
            stringBuffer.append("version_id              = ").append(this.version_id).append(NL);
            stringBuffer.append("file_time_sec           = ").append(this.file_time_sec).append(NL);
            stringBuffer.append("file_time_nano          = ").append(this.file_time_nano).append(NL);
            stringBuffer.append("entry_space             = ").append(this.entry_space).append(NL);
            stringBuffer.append("entry_subspace          = ").append(this.entry_subspace).append(NL);
            stringBuffer.append("aux_header_location     = ").append(this.aux_header_location).append(NL);
            stringBuffer.append("aux_header_size         = ").append(this.aux_header_size).append(NL);
            stringBuffer.append("som_length              = ").append(this.som_length).append(NL);
            stringBuffer.append("presumed_dp             = ").append(this.presumed_dp).append(NL);
            stringBuffer.append("space_location          = ").append(this.space_location).append(NL);
            stringBuffer.append("space_total             = ").append(this.space_total).append(NL);
            stringBuffer.append("subspace_location       = ").append(this.subspace_location).append(NL);
            stringBuffer.append("subspace_total          = ").append(this.subspace_total).append(NL);
            stringBuffer.append("loader_fixup_location   = ").append(this.loader_fixup_location).append(NL);
            stringBuffer.append("loader_fixup_total      = ").append(this.loader_fixup_total).append(NL);
            stringBuffer.append("space_strings_location  = ").append(this.space_strings_location).append(NL);
            stringBuffer.append("space_strings_size      = ").append(this.space_strings_size).append(NL);
            stringBuffer.append("init_array_location     = ").append(this.init_array_location).append(NL);
            stringBuffer.append("init_array_total        = ").append(this.init_array_total).append(NL);
            stringBuffer.append("compiler_location       = ").append(this.compiler_location).append(NL);
            stringBuffer.append("compiler_total          = ").append(this.compiler_total).append(NL);
            stringBuffer.append("symbol_location         = ").append(this.symbol_location).append(NL);
            stringBuffer.append("symbol_total            = ").append(this.symbol_total).append(NL);
            stringBuffer.append("fixup_request_location  = ").append(this.fixup_request_location).append(NL);
            stringBuffer.append("fixup_request_total     = ").append(this.fixup_request_total).append(NL);
            stringBuffer.append("symbol_strings_location = ").append(this.symbol_strings_location).append(NL);
            stringBuffer.append("symbol_strings_size     = ").append(this.symbol_strings_size).append(NL);
            stringBuffer.append("unloadable_sp_location  = ").append(this.unloadable_sp_location).append(NL);
            stringBuffer.append("unloadable_sp_size      = ").append(this.unloadable_sp_size).append(NL);
            stringBuffer.append("checksum                = ").append(this.checksum).append(NL);
            return stringBuffer.toString();
        }
    }

    public class Symbol {
        public static final int SYMSZ = 20;
        public static final int B31_MASK = Integer.MIN_VALUE;
        public static final int B30_MASK = 0x40000000;
        public static final int B29_24_MASK = 0x3F000000;
        public static final int B23_20_MASK = 0xF00000;
        public static final int B19_17_MASK = 917504;
        public static final int B16_MASK = 65536;
        public static final int B15_MASK = 32768;
        public static final int B14_MASK = 16384;
        public static final int B13_MASK = 8192;
        public static final int B12_MASK = 4096;
        public static final int B11_10_MASK = 3072;
        public static final int B9_0_MASK = 1023;
        public static final int B23_0_MASK = 0xFFFFFF;
        public static final int B7_0_MASK = 255;
        public static final int NULL = 0;
        public static final int ABSOLUTE = 1;
        public static final int DATA = 2;
        public static final int CODE = 3;
        public static final int PRI_PROG = 4;
        public static final int SEC_PROG = 5;
        public static final int ENTRY = 6;
        public static final int STORAGE = 7;
        public static final int STUB = 8;
        public static final int MODULE = 9;
        public static final int SYM_EXT = 10;
        public static final int ARG_EXT = 11;
        public static final int MILLICODE = 12;
        public static final int PLABEL = 13;
        public static final int OCT_DIS = 14;
        public static final int MILLI_EXT = 15;
        public static final int ST_DATA = 15;
        public static final int UNSAT = 0;
        public static final int EXTERNAL = 1;
        public static final int LOCAL = 2;
        public static final int UNIVERSAL = 3;
        public boolean hidden;
        public boolean secondary_def;
        public int symbol_type;
        public int symbol_scope;
        public int check_level;
        public boolean must_qualify;
        public boolean initially_frozen;
        public boolean memory_resident;
        public boolean is_common;
        public boolean dup_common;
        public int xleast;
        public int arg_reloc;
        public int name_offset;
        public int qualifier_name_offset;
        public boolean has_long_return;
        public boolean no_relocation;
        public int symbol_info;
        public int symbol_value;

        public Symbol(RandomAccessFile randomAccessFile) throws IOException {
            this(randomAccessFile, randomAccessFile.getFilePointer());
        }

        public Symbol(RandomAccessFile randomAccessFile, long l) throws IOException {
            randomAccessFile.seek(l);
            byte[] byArray = new byte[20];
            randomAccessFile.readFully(byArray);
            ReadMemoryAccess readMemoryAccess = new ReadMemoryAccess(byArray, false);
            int n = readMemoryAccess.getInt();
            this.hidden = (n & Integer.MIN_VALUE) != 0;
            this.secondary_def = (n & 0x40000000) != 0;
            this.symbol_type = (n & 0x3F000000) >> 24;
            this.symbol_scope = (n & 0xF00000) >> 20;
            this.check_level = (n & 0xE0000) >> 17;
            this.must_qualify = (n & 0x10000) != 0;
            this.initially_frozen = (n & 0x8000) != 0;
            this.memory_resident = (n & 0x4000) != 0;
            this.is_common = (n & 0x2000) != 0;
            this.dup_common = (n & 0x1000) != 0;
            this.xleast = (n & 0xC00) >> 10;
            this.arg_reloc = n & 0x3FF;
            this.name_offset = readMemoryAccess.getInt();
            this.qualifier_name_offset = readMemoryAccess.getInt();
            n = readMemoryAccess.getInt();
            this.has_long_return = (n & Integer.MIN_VALUE) != 0;
            this.no_relocation = (n & 0x40000000) != 0;
            this.symbol_info = n & 0xFFFFFF;
            this.symbol_value = readMemoryAccess.getInt();
            if (this.check_level >= 1) {
                randomAccessFile.readFully(byArray);
                readMemoryAccess = new ReadMemoryAccess(byArray, false);
                n = readMemoryAccess.getInt();
                int n2 = n & 0xFF;
                if (n2 > 3 && this.check_level >= 3) {
                    int n3 = (n2 - 3) % 4 == 0 ? (n2 - 3) / 4 : (n2 - 3) / 4 + 1;
                    int n4 = 0;
                    while (n4 < n3) {
                        randomAccessFile.readFully(byArray);
                        ++n4;
                    }
                }
            }
        }

        public String getName(byte[] byArray) {
            if (this.qualifier_name_offset != 0) {
                byte[] byArray2 = new byte[4];
                System.arraycopy(byArray, this.qualifier_name_offset - 4, byArray2, 0, 4);
                ReadMemoryAccess readMemoryAccess = new ReadMemoryAccess(byArray2, false);
                int n = readMemoryAccess.getInt();
                return new String(byArray, this.qualifier_name_offset, n);
            }
            if (this.name_offset != 0) {
                byte[] byArray3 = new byte[4];
                System.arraycopy(byArray, this.name_offset - 4, byArray3, 0, 4);
                ReadMemoryAccess readMemoryAccess = new ReadMemoryAccess(byArray3, false);
                int n = readMemoryAccess.getInt();
                return new String(byArray, this.name_offset, n);
            }
            return "";
        }

        public boolean isFunction() {
            return this.symbol_type == 4 || this.symbol_type == 6 && this.symbol_scope != 2;
        }

        public boolean isVariable() {
            return this.symbol_type == 2 && this.symbol_scope != 2 || this.symbol_type == 7;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SYMBOL TABLE ENTRY").append(NL);
            stringBuffer.append("symbol_name  = ");
            try {
                stringBuffer.append(this.getName(SOM.this.getStringTable())).append(NL);
            }
            catch (IOException iOException) {
                stringBuffer.append("I/O error");
            }
            stringBuffer.append("symbol_value = ").append(this.symbol_value).append(NL);
            stringBuffer.append("symbol_type  = ").append(this.symbol_type).append(NL);
            stringBuffer.append("symbol_scope = ").append(this.symbol_scope).append(NL);
            return stringBuffer.toString();
        }
    }

    public static class Attribute {
        public static final int SOM_TYPE_EXE = 1;
        public static final int SOM_TYPE_SHLIB = 2;
        public static final int SOM_TYPE_OBJ = 3;
        public static final int SOM_TYPE_CORE = 4;
        String cpu;
        int type;
        boolean bDebug;
        boolean isle;

        public String getCPU() {
            return this.cpu;
        }

        public int getType() {
            return this.type;
        }

        public boolean hasDebug() {
            return this.bDebug;
        }

        public boolean isLittleEndian() {
            return this.isle;
        }
    }
}

