/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.som.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.CygPath;
import org.eclipse.cdt.utils.Symbol;
import org.eclipse.cdt.utils.som.AR;
import org.eclipse.cdt.utils.som.SOM;
import org.eclipse.cdt.utils.som.parser.SOMBinaryObject;
import org.eclipse.core.runtime.IPath;

public class ARMember
extends SOMBinaryObject {
    private AR.ARHeader header;

    public ARMember(IBinaryParser iBinaryParser, IPath iPath, AR.ARHeader aRHeader) {
        super(iBinaryParser, iPath);
        this.header = aRHeader;
    }

    protected void addSymbols(SOM.Symbol[] symbolArray, byte[] byArray, Addr2line addr2line, CPPFilt cPPFilt, CygPath cygPath, List list) {
        int n = 0;
        while (n < symbolArray.length) {
            String string;
            if ((symbolArray[n].isFunction() || symbolArray[n].isVariable()) && (string = symbolArray[n].getName(byArray)) != null && string.trim().length() != 0 && Character.isJavaIdentifierStart(string.charAt(0))) {
                Symbol symbol = new Symbol(this);
                symbol.type = symbolArray[n].isFunction() ? 1 : 2;
                symbol.addr = symbolArray[n].symbol_value;
                symbol.name = string;
                if (cPPFilt != null) {
                    try {
                        symbol.name = cPPFilt.getFunction(symbol.name);
                    }
                    catch (IOException iOException) {
                        cPPFilt = null;
                    }
                }
                list.add(symbol);
            }
            ++n;
        }
    }

    protected SOM getSOM() throws IOException {
        if (this.header != null) {
            return this.header.getSOM();
        }
        throw new IOException(CCorePlugin.getResourceString("Util.exception.noFileAssociation"));
    }

    public InputStream getContents() {
        InputStream inputStream = null;
        if (this.path != null && this.header != null) {
            try {
                inputStream = new ByteArrayInputStream(this.header.getObjectData());
            }
            catch (IOException iOException) {}
        }
        if (inputStream == null) {
            inputStream = super.getContents();
        }
        return inputStream;
    }

    public String getName() {
        if (this.header != null) {
            return this.header.getObjectName();
        }
        return "";
    }
}

