/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.som.parser;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.BinaryFile;
import org.eclipse.cdt.utils.som.AR;
import org.eclipse.cdt.utils.som.parser.ARMember;
import org.eclipse.core.runtime.IPath;

public class BinaryArchive
extends BinaryFile
implements IBinaryParser.IBinaryArchive {
    private ArrayList children;

    public BinaryArchive(IBinaryParser iBinaryParser, IPath iPath) throws IOException {
        super(iBinaryParser, iPath);
        new AR(iPath.toOSString()).dispose();
        this.children = new ArrayList(5);
    }

    public int getType() {
        return 8;
    }

    public IBinaryParser.IBinaryObject[] getObjects() {
        if (this.hasChanged()) {
            this.children.clear();
            AR aR = null;
            try {
                aR = new AR(this.getPath().toOSString());
                AR.ARHeader[] aRHeaderArray = aR.getHeaders();
                int n = 0;
                while (n < aRHeaderArray.length) {
                    ARMember aRMember = new ARMember(this.getBinaryParser(), this.getPath(), aRHeaderArray[n]);
                    this.children.add(aRMember);
                    ++n;
                }
            }
            catch (IOException iOException) {}
            if (aR != null) {
                aR.dispose();
            }
            this.children.trimToSize();
        }
        return this.children.toArray(new IBinaryParser.IBinaryObject[0]);
    }
}

