/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.spawner;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.cdt.utils.spawner.IProcessFactoryPath;
import org.eclipse.cdt.utils.spawner.Spawner;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class ProcessFactory {
    private static ProcessFactory instance;
    private boolean hasSpawner = false;
    private Runtime runtime;
    private static final String PATH = "PATH";
    Properties envVars;

    private ProcessFactory() {
        String string = System.getProperty("os.name").toLowerCase();
        this.runtime = Runtime.getRuntime();
        try {
            if (string != null && string.equals("windows 98")) {
                this.hasSpawner = false;
            } else {
                System.loadLibrary("spawner");
                this.hasSpawner = true;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
    }

    public static ProcessFactory getFactory() {
        if (instance == null) {
            instance = new ProcessFactory();
        }
        return instance;
    }

    public Process exec(String string) throws IOException {
        if (this.hasSpawner) {
            return new Spawner(string, this.addPathsToEnv());
        }
        return this.runtime.exec(string, this.addPathsToEnv());
    }

    public Process exec(String[] stringArray) throws IOException {
        if (this.hasSpawner) {
            return new Spawner(stringArray, this.addPathsToEnv());
        }
        return this.runtime.exec(stringArray, this.addPathsToEnv());
    }

    public Process exec(String[] stringArray, String[] stringArray2) throws IOException {
        if (this.hasSpawner) {
            return new Spawner(stringArray, this.addPathsToEnv(stringArray2));
        }
        return this.runtime.exec(stringArray, this.addPathsToEnv(stringArray2));
    }

    public Process exec(String string, String[] stringArray) throws IOException {
        if (this.hasSpawner) {
            return new Spawner(string, this.addPathsToEnv(stringArray));
        }
        return this.runtime.exec(string, this.addPathsToEnv(stringArray));
    }

    public Process exec(String string, String[] stringArray, File file) throws IOException {
        if (this.hasSpawner) {
            return new Spawner(string, this.addPathsToEnv(stringArray), file);
        }
        return this.runtime.exec(string, this.addPathsToEnv(stringArray), file);
    }

    public Process exec(String[] stringArray, String[] stringArray2, File file) throws IOException {
        if (this.hasSpawner) {
            return new Spawner(stringArray, this.addPathsToEnv(stringArray2), file);
        }
        return this.runtime.exec(stringArray, this.addPathsToEnv(stringArray2), file);
    }

    private String[] addPathsToEnv() {
        return this.toArray(this.addPathsToEnv(this.toProperties(null)));
    }

    private String[] addPathsToEnv(String[] stringArray) {
        return this.toArray(this.addPathsToEnv(this.toProperties(stringArray)));
    }

    private Properties addPathsToEnv(Properties properties) {
        String string;
        IPath[] iPathArray = this.getAdditionalPaths();
        if (iPathArray.length == 0) {
            return properties;
        }
        Properties properties2 = this.getEnvVars();
        if (properties == null || properties.size() == 0) {
            properties = (Properties)properties2.clone();
        }
        if ((string = properties.getProperty(PATH)) == null) {
            return properties;
        }
        String[] stringArray = string.split(";");
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        int n = 0;
        while (n < iPathArray.length) {
            String string2 = iPathArray[n].toOSString();
            if (!arrayList.contains(string2)) {
                arrayList.add(0, string2);
            }
            ++n;
        }
        string = "";
        Iterator iterator = arrayList.iterator();
        if (iterator.hasNext()) {
            string = (String)iterator.next();
            while (iterator.hasNext()) {
                string = String.valueOf(string) + ';' + (String)iterator.next();
            }
        }
        properties.setProperty(PATH, string);
        return properties;
    }

    private IPath[] getAdditionalPaths() {
        ArrayList<IPath> arrayList = new ArrayList<IPath>();
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint("org.eclipse.cdt.core", "ProcessFactoryPath");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            IExtension iExtension = iExtensionArray[n];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                try {
                    Object object = iConfigurationElement.createExecutableExtension("class");
                    IProcessFactoryPath iProcessFactoryPath = (IProcessFactoryPath)object;
                    IPath[] iPathArray = iProcessFactoryPath.getPaths();
                    arrayList.addAll(Arrays.asList(iPathArray));
                }
                catch (Throwable throwable) {}
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new IPath[arrayList.size()]);
    }

    private String[] toArray(Properties properties) {
        String[] stringArray;
        if (properties == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            arrayList.add(String.valueOf(stringArray) + '=' + properties.getProperty((String)stringArray));
        }
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        return stringArray;
    }

    private Properties toProperties(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        Properties properties = new Properties();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                int n2 = string.indexOf(61);
                if (n2 != -1) {
                    String string2 = string.substring(0, n2);
                    String string3 = string.substring(n2 + 1);
                    properties.setProperty(string2, string3);
                } else {
                    properties.setProperty(string, new String());
                }
                ++n;
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties getEnvVars() {
        if (this.envVars != null) {
            return (Properties)this.envVars.clone();
        }
        String string = System.getProperty("os.name").toLowerCase();
        Process process = null;
        this.envVars = new Properties();
        String string2 = "env";
        InputStream inputStream = null;
        boolean bl = false;
        boolean bl2 = false;
        if (string.startsWith("windows 9") || string.startsWith("windows me")) {
            string2 = "command.com /c set";
            bl = true;
            bl2 = true;
        } else if (string.startsWith("windows ")) {
            string2 = "cmd.exe /c set";
            bl2 = true;
        }
        try {
            try {
                String string3;
                process = Runtime.getRuntime().exec(string2);
                inputStream = process.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((string3 = bufferedReader.readLine()) != null) {
                    int n = string3.indexOf(61);
                    if (n != -1) {
                        String string4 = string3.substring(0, n);
                        if (bl2) {
                            string4 = string4.toUpperCase();
                        }
                        String string5 = string3.substring(n + 1);
                        this.envVars.setProperty(string4, string5);
                    } else {
                        this.envVars.setProperty(string3, "");
                    }
                    if (!bl || bufferedReader.ready()) continue;
                    break;
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (process == null) throw throwable;
                process.waitFor();
                throw throwable;
            }
            catch (InterruptedException interruptedException) {}
            throw throwable;
        }
        {
            Object var12_14 = null;
        }
        try {}
        catch (IOException iOException) {}
        if (inputStream != null) {
            inputStream.close();
        }
        try {}
        catch (InterruptedException interruptedException) {
            return (Properties)this.envVars.clone();
        }
        if (process == null) return (Properties)this.envVars.clone();
        process.waitFor();
        return (Properties)this.envVars.clone();
    }
}

