/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.spawner;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.core.CCorePlugin;

class SpawnerInputStream
extends InputStream {
    private int fd;

    static {
        System.loadLibrary("spawner");
    }

    public SpawnerInputStream(int n) {
        this.fd = n;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        if (1 != this.read(byArray, 0, 1)) {
            return -1;
        }
        return byArray[0];
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        byte[] byArray2 = new byte[n2];
        if ((n2 = this.read0(this.fd, byArray2, n2)) <= 0) {
            return -1;
        }
        System.arraycopy(byArray2, 0, byArray, n, n2);
        return n2;
    }

    public void close() throws IOException {
        if (this.fd == -1) {
            return;
        }
        int n = this.close0(this.fd);
        if (n == -1) {
            throw new IOException(CCorePlugin.getResourceString("Util.exception.closeError"));
        }
        this.fd = -1;
    }

    private native int read0(int var1, byte[] var2, int var3) throws IOException;

    private native int close0(int var1) throws IOException;
}

