/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.spawner;

import java.io.IOException;
import java.io.OutputStream;

public class SpawnerOutputStream
extends OutputStream {
    private int fd;

    static {
        System.loadLibrary("spawner");
    }

    public SpawnerOutputStream(int n) {
        this.fd = n;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, n, n2);
        this.write0(this.fd, byArray2, n2);
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public void close() throws IOException {
        if (this.fd == -1) {
            return;
        }
        int n = this.close0(this.fd);
        if (n == -1) {
            throw new IOException("close error");
        }
        this.fd = -1;
    }

    private native int write0(int var1, byte[] var2, int var3) throws IOException;

    private native int close0(int var1);
}

