/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.xcoff;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.xcoff.XCoff32;

public class AR {
    protected String filename;
    protected RandomAccessFile file;
    private ARHeader header;
    private MemberHeader[] memberHeaders;

    public AR(String string) throws IOException {
        this.filename = string;
        this.file = new RandomAccessFile(string, "r");
        this.header = new ARHeader();
        if (!this.header.isXcoffARHeader()) {
            this.file.close();
            throw new IOException(CCorePlugin.getResourceString("Util.exception.invalidArchive"));
        }
    }

    public void dispose() {
        try {
            if (this.file != null) {
                this.file.close();
                this.file = null;
            }
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            super.finalize();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        super.finalize();
    }

    public static boolean isARHeader(byte[] byArray) {
        return byArray.length >= 8 && byArray[0] == 60 && byArray[1] == 98 && byArray[2] == 105 && byArray[3] == 103 && byArray[4] == 97 && byArray[5] == 102 && byArray[6] == 62 && byArray[7] == 10;
    }

    private void loadHeaders() throws IOException {
        if (this.memberHeaders != null) {
            return;
        }
        Vector<MemberHeader> vector = new Vector<MemberHeader>();
        try {
            long l = this.header.fstmoff;
            while (l < this.file.length()) {
                this.file.seek(l);
                MemberHeader memberHeader = new MemberHeader();
                memberHeader.getObjectName();
                vector.add(memberHeader);
                if (l != 0L && l != this.header.lstmoff) {
                    l = memberHeader.nxtmem;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {}
        this.memberHeaders = vector.toArray(new MemberHeader[0]);
    }

    public MemberHeader[] getHeaders() throws IOException {
        this.loadHeaders();
        return this.memberHeaders;
    }

    public String[] extractFiles(String string, String[] stringArray) throws IOException {
        Vector<String> vector = new Vector<String>();
        this.loadHeaders();
        int n = 0;
        int n2 = 0;
        while (n2 < this.memberHeaders.length) {
            String string2 = this.memberHeaders[n2].getObjectName();
            if (stringArray == null || this.stringInStrings(string2, stringArray)) {
                string2 = n + "_" + string2;
                ++n;
                byte[] byArray = this.memberHeaders[n2].getObjectData();
                File file = new File(string, string2);
                vector.add(string2);
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                randomAccessFile.write(byArray);
                randomAccessFile.close();
            }
            ++n2;
        }
        return vector.toArray(new String[0]);
    }

    private boolean stringInStrings(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (string.compareTo(stringArray[n]) == 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private String removeBlanks(String string) {
        while (string.charAt(string.length() - 1) == ' ') {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String[] extractFiles(String string) throws IOException {
        return this.extractFiles(string, null);
    }

    private RandomAccessFile getRandomAccessFile() throws IOException {
        if (this.file == null) {
            this.file = new RandomAccessFile(this.filename, "r");
        }
        return this.file;
    }

    public static void main(String[] stringArray) {
        try {
            AR aR = new AR(stringArray[0]);
            aR.getHeaders();
            aR.extractFiles(stringArray[1]);
            System.out.println(aR);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public class ARHeader {
        private static final int SAIAMAG = 8;
        private byte[] fl_magic = new byte[8];
        private byte[] fl_memoff = new byte[20];
        private byte[] fl_gstoff = new byte[20];
        private byte[] fl_gst64off = new byte[20];
        private byte[] fl_fstmoff = new byte[20];
        private byte[] fl_lstmoff = new byte[20];
        private byte[] fl_freeoff = new byte[20];
        private long fstmoff = 0L;
        private long lstmoff = 0L;
        private long memoff = 0L;

        public ARHeader() throws IOException {
            try {
                AR.this.getRandomAccessFile();
                AR.this.file.seek(0L);
                AR.this.file.read(this.fl_magic);
                if (AR.isARHeader(this.fl_magic)) {
                    AR.this.file.read(this.fl_memoff);
                    AR.this.file.read(this.fl_gstoff);
                    AR.this.file.read(this.fl_gst64off);
                    AR.this.file.read(this.fl_fstmoff);
                    AR.this.file.read(this.fl_lstmoff);
                    AR.this.file.read(this.fl_freeoff);
                    this.fstmoff = Long.parseLong(AR.this.removeBlanks(new String(this.fl_fstmoff)));
                    this.lstmoff = Long.parseLong(AR.this.removeBlanks(new String(this.fl_lstmoff)));
                    this.memoff = Long.parseLong(AR.this.removeBlanks(new String(this.fl_memoff)));
                }
            }
            catch (IOException iOException) {
                AR.this.dispose();
                CCorePlugin.log(iOException);
            }
        }

        public boolean isXcoffARHeader() {
            return this.fstmoff != 0L;
        }
    }

    public class MemberHeader {
        byte[] ar_size = new byte[20];
        byte[] ar_nxtmem = new byte[20];
        byte[] ar_prvmem = new byte[20];
        byte[] ar_date = new byte[12];
        byte[] ar_uid = new byte[12];
        byte[] ar_gid = new byte[12];
        byte[] ar_mode = new byte[12];
        byte[] ar_namlen = new byte[4];
        byte[] ar_name;
        byte[] ar_fmag = new byte[2];
        long size;
        long nxtmem;
        long prvmem;
        int namlen;
        String name;
        long file_offset;

        private String removeBlanks(String string) {
            while (string.charAt(string.length() - 1) == ' ') {
                string = string.substring(0, string.length() - 1);
            }
            return string;
        }

        public MemberHeader() throws IOException {
            AR.this.file.read(this.ar_size);
            AR.this.file.read(this.ar_nxtmem);
            AR.this.file.read(this.ar_prvmem);
            AR.this.file.read(this.ar_date);
            AR.this.file.read(this.ar_uid);
            AR.this.file.read(this.ar_gid);
            AR.this.file.read(this.ar_mode);
            AR.this.file.read(this.ar_namlen);
            this.namlen = Integer.parseInt(this.removeBlanks(new String(this.ar_namlen)));
            this.ar_name = new byte[this.namlen];
            AR.this.file.read(this.ar_name);
            AR.this.file.read(this.ar_fmag);
            this.size = Long.parseLong(this.removeBlanks(new String(this.ar_size)));
            this.nxtmem = Long.parseLong(this.removeBlanks(new String(this.ar_nxtmem)));
            this.prvmem = Long.parseLong(this.removeBlanks(new String(this.ar_prvmem)));
            this.name = new String(this.ar_name, 0, this.namlen);
            this.file_offset = AR.this.file.getFilePointer();
            if (this.file_offset % 2L == 1L) {
                ++this.file_offset;
            }
        }

        public String getObjectName() {
            return this.name;
        }

        public long getSize() {
            return this.size;
        }

        public String getArchiveName() {
            return AR.this.filename;
        }

        public XCoff32 getXCoff() throws IOException {
            return new XCoff32(AR.this.filename, this.file_offset);
        }

        public byte[] getObjectData() throws IOException {
            byte[] byArray = new byte[(int)this.size];
            AR.this.file = AR.this.getRandomAccessFile();
            AR.this.file.seek(this.file_offset);
            AR.this.file.read(byArray);
            AR.this.dispose();
            return byArray;
        }
    }
}

