/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.xcoff;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.coff.ReadMemoryAccess;

public class XCoff32 {
    public static final String NL = System.getProperty("line.separator", "\n");
    String filename;
    FileHeader filehdr;
    OptionalHeader opthdr;
    RandomAccessFile rfile;
    long startingOffset;
    byte[] string_table;
    SectionHeader[] scnhdrs;
    Symbol[] symbols;

    public Attribute getAttributes() {
        Attribute attribute = new Attribute();
        switch (this.filehdr.f_magic) {
            case 479: {
                attribute.cpu = "xcoff32";
                break;
            }
            case 503: {
                attribute.cpu = "xcoff64";
                break;
            }
            default: {
                attribute.cpu = "unknown";
            }
        }
        attribute.type = (this.filehdr.f_flags & 0x2000) != 0 ? 2 : ((this.filehdr.f_flags & 2) != 0 ? 1 : 3);
        attribute.isle = false;
        this.filehdr.getClass();
        attribute.bDebug = !false;
        return attribute;
    }

    public FileHeader getFileHeader() throws IOException {
        return this.filehdr;
    }

    public OptionalHeader getOptionalHeader() throws IOException {
        return this.opthdr;
    }

    public SectionHeader[] getSectionHeaders() throws IOException {
        if (this.scnhdrs == null) {
            this.getRandomAccessFile();
            this.scnhdrs = new SectionHeader[this.getFileHeader().f_nscns];
            long l = this.startingOffset + 20L + (long)this.getFileHeader().f_opthdr;
            int n = 0;
            while (n < this.scnhdrs.length) {
                this.scnhdrs[n] = new SectionHeader(this.rfile, l);
                ++n;
                l += 40L;
            }
        }
        return this.scnhdrs;
    }

    public Symbol[] getSymbols() throws IOException {
        if (this.symbols == null) {
            long l = this.startingOffset + (long)this.getFileHeader().f_symptr;
            this.getRandomAccessFile();
            this.rfile.seek(l);
            int n = this.getFileHeader().f_nsyms;
            ArrayList<Symbol> arrayList = new ArrayList<Symbol>(n);
            int n2 = 0;
            while (n2 < n) {
                Symbol symbol = new Symbol(this.rfile);
                arrayList.add(symbol);
                n2 += symbol.n_numaux;
                ++n2;
            }
            this.symbols = arrayList.toArray(new Symbol[arrayList.size()]);
        }
        return this.symbols;
    }

    public byte[] getStringTable() throws IOException {
        if (this.string_table == null && this.filehdr.f_nsyms > 0) {
            this.getRandomAccessFile();
            long l = 18 * this.getFileHeader().f_nsyms;
            long l2 = this.startingOffset + (long)this.getFileHeader().f_symptr + l;
            this.rfile.seek(l2);
            byte[] byArray = new byte[4];
            this.rfile.readFully(byArray);
            int n = ReadMemoryAccess.getIntBE(byArray);
            if (n > 4 && (long)n < this.rfile.length()) {
                this.string_table = new byte[n -= 4];
                this.rfile.seek(l2 + 4L);
                this.rfile.readFully(this.string_table);
            } else {
                this.string_table = new byte[0];
            }
        }
        return this.string_table;
    }

    protected XCoff32() {
    }

    public XCoff32(String string) throws IOException {
        this(string, 0L);
    }

    public XCoff32(String string, long l) throws IOException {
        this.filename = string;
        this.commonSetup(new RandomAccessFile(string, "r"), l);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void commonSetup(RandomAccessFile randomAccessFile, long l) throws IOException {
        this.startingOffset = l;
        this.rfile = randomAccessFile;
        try {
            this.filehdr = new FileHeader(this.rfile, this.startingOffset);
            if (this.filehdr.f_opthdr > 0) {
                this.opthdr = new OptionalHeader(this.rfile, this.startingOffset + 20L);
            }
            if (this.filehdr.f_opthdr < 72) {
                this.getSectionHeaders();
                int n = 0;
                while (n < this.filehdr.f_nscns) {
                    if ((this.scnhdrs[n].s_flags & 0x20) != 0) {
                        this.opthdr.o_sntext = (short)(n + 1);
                    } else if ((this.scnhdrs[n].s_flags & 0x80) != 0) {
                        this.opthdr.o_snbss = (short)(n + 1);
                    } else if ((this.scnhdrs[n].s_flags & 0x40) != 0) {
                        this.opthdr.o_sndata = (short)(n + 1);
                    }
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.dispose();
            throw throwable;
        }
        {
            Object var5_6 = null;
        }
        this.dispose();
    }

    public String toString() {
        int n;
        Object[] objectArray;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            objectArray = null;
            objectArray = this.getFileHeader();
            if (objectArray != null) {
                stringBuffer.append(objectArray);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            objectArray = null;
            objectArray = this.getOptionalHeader();
            if (objectArray != null) {
                stringBuffer.append(objectArray);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            objectArray = this.getSectionHeaders();
            n = 0;
            while (n < objectArray.length) {
                stringBuffer.append(objectArray[n]);
                ++n;
            }
        }
        catch (IOException iOException) {}
        try {
            objectArray = this.getSymbols();
            n = 0;
            while (n < objectArray.length) {
                stringBuffer.append(objectArray[n]).append("n_name = ");
                stringBuffer.append(((Symbol)objectArray[n]).getName(this.getStringTable())).append(NL);
                ++n;
            }
        }
        catch (IOException iOException) {}
        return stringBuffer.toString();
    }

    public void dispose() throws IOException {
        if (this.rfile != null) {
            this.rfile.close();
            this.rfile = null;
        }
    }

    RandomAccessFile getRandomAccessFile() throws IOException {
        if (this.rfile == null) {
            this.rfile = new RandomAccessFile(this.filename, "r");
        }
        return this.rfile;
    }

    public static void main(String[] stringArray) {
        try {
            XCoff32 xCoff32 = new XCoff32(stringArray[0]);
            System.out.println(xCoff32);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static boolean isXCOFF32Header(byte[] byArray) {
        return byArray != null && byArray[0] == 1 && byArray[1] == -33;
    }

    public static Attribute getAttributes(byte[] byArray) throws IOException {
        XCoff32 xCoff32 = new XCoff32();
        xCoff32.filehdr = new FileHeader(byArray, false);
        Attribute attribute = xCoff32.getAttributes();
        xCoff32.dispose();
        return attribute;
    }

    public static Attribute getAttributes(String string) throws IOException {
        XCoff32 xCoff32 = new XCoff32(string);
        Attribute attribute = xCoff32.getAttributes();
        xCoff32.dispose();
        return attribute;
    }

    public static class FileHeader {
        public static final int FILHSZ = 20;
        public static final int U802TOCMAGIC = 479;
        public static final int U803TOCMAGIC = 487;
        public static final int U803XTOCMAGIC = 495;
        public static final int U64_TOCMAGIC = 503;
        public static final int F_RELFLG = 1;
        public static final int F_EXEC = 2;
        public static final int F_LNNO = 4;
        public static final int F_LSYMS = 8;
        public static final int F_FDPR_PROF = 16;
        public static final int F_FDPR_OPTI = 32;
        public static final int F_DSA = 64;
        public static final int F_DYNLOAD = 4096;
        public static final int F_SHROBJ = 8192;
        public static final int F_LOADONLY = 16384;
        public short f_magic;
        public short f_nscns;
        public int f_timdat;
        public int f_symptr;
        public int f_nsyms;
        public short f_opthdr;
        public short f_flags;

        public FileHeader(RandomAccessFile randomAccessFile) throws IOException {
            this(randomAccessFile, randomAccessFile.getFilePointer());
        }

        public FileHeader(RandomAccessFile randomAccessFile, long l) throws IOException {
            randomAccessFile.seek(l);
            byte[] byArray = new byte[20];
            randomAccessFile.readFully(byArray);
            this.commonSetup(byArray, false);
        }

        public FileHeader(byte[] byArray, boolean bl) throws IOException {
            this.commonSetup(byArray, bl);
        }

        public void commonSetup(byte[] byArray, boolean bl) throws IOException {
            if (byArray == null || byArray.length < 20) {
                throw new EOFException(CCorePlugin.getResourceString("Util.exception.arrayToSmall"));
            }
            if (!XCoff32.isXCOFF32Header(byArray)) {
                throw new IOException(CCorePlugin.getResourceString("Util.exception.notXCOFF32"));
            }
            ReadMemoryAccess readMemoryAccess = new ReadMemoryAccess(byArray, bl);
            this.f_magic = readMemoryAccess.getShort();
            this.f_nscns = readMemoryAccess.getShort();
            this.f_timdat = readMemoryAccess.getInt();
            this.f_symptr = readMemoryAccess.getInt();
            this.f_nsyms = readMemoryAccess.getInt();
            this.f_opthdr = readMemoryAccess.getShort();
            this.f_flags = readMemoryAccess.getShort();
        }

        public boolean isStrip() {
            return (this.f_flags & 1) == 1;
        }

        public boolean isExec() {
            return (this.f_flags & 2) == 2;
        }

        public boolean isDebug() {
            return (this.f_flags & 4) != 4;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("FILE HEADER VALUES").append(NL);
            stringBuffer.append("f_magic  = ").append(this.f_magic).append(NL);
            stringBuffer.append("f_nscns  = ").append(this.f_nscns).append(NL);
            stringBuffer.append("f_timdat = ");
            stringBuffer.append(DateFormat.getDateInstance().format(new Date(this.f_timdat)));
            stringBuffer.append(NL);
            stringBuffer.append("f_symptr = ").append(this.f_symptr).append(NL);
            stringBuffer.append("f_nsyms  = ").append(this.f_nsyms).append(NL);
            stringBuffer.append("f_opthdr = ").append(this.f_opthdr).append(NL);
            stringBuffer.append("f_flags  = ").append(this.f_flags).append(NL);
            return stringBuffer.toString();
        }
    }

    public static class OptionalHeader {
        public static final int AOUTHDRSZ = 72;
        public short magic;
        public short vstamp;
        public int tsize;
        public int dsize;
        public int bsize;
        public int entry;
        public int text_start;
        public int data_start;
        public int o_toc;
        public short o_snentry;
        public short o_sntext;
        public short o_sndata;
        public short o_sntoc;
        public short o_snloader;
        public short o_snbss;
        public short o_algntext;
        public short o_algndata;
        public short o_modtype;
        public byte o_cpuflag;
        public byte o_cputype;
        public int o_maxstack;
        public int o_maxdata;
        public int o_debugger;

        public OptionalHeader(RandomAccessFile randomAccessFile) throws IOException {
            this(randomAccessFile, randomAccessFile.getFilePointer() + 20L);
        }

        public OptionalHeader(RandomAccessFile randomAccessFile, long l) throws IOException {
            randomAccessFile.seek(l);
            byte[] byArray = new byte[72];
            randomAccessFile.readFully(byArray);
            ReadMemoryAccess readMemoryAccess = new ReadMemoryAccess(byArray, false);
            this.magic = readMemoryAccess.getShort();
            this.vstamp = readMemoryAccess.getShort();
            this.tsize = readMemoryAccess.getInt();
            this.dsize = readMemoryAccess.getInt();
            this.bsize = readMemoryAccess.getInt();
            this.entry = readMemoryAccess.getInt();
            this.text_start = readMemoryAccess.getInt();
            this.data_start = readMemoryAccess.getInt();
            this.o_toc = readMemoryAccess.getInt();
            this.o_snentry = readMemoryAccess.getShort();
            this.o_sntext = readMemoryAccess.getShort();
            this.o_sndata = readMemoryAccess.getShort();
            this.o_sntoc = readMemoryAccess.getShort();
            this.o_snloader = readMemoryAccess.getShort();
            this.o_snbss = readMemoryAccess.getShort();
            this.o_algntext = readMemoryAccess.getShort();
            this.o_algndata = readMemoryAccess.getShort();
            this.o_modtype = readMemoryAccess.getShort();
            this.o_cpuflag = readMemoryAccess.getByte();
            this.o_cputype = readMemoryAccess.getByte();
            this.o_maxstack = readMemoryAccess.getInt();
            this.o_maxdata = readMemoryAccess.getInt();
            this.o_debugger = readMemoryAccess.getInt();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("OPTIONAL HEADER VALUES").append(NL);
            stringBuffer.append("magic      = ").append(this.magic).append(NL);
            stringBuffer.append("vstamp     = ").append(this.vstamp).append(NL);
            stringBuffer.append("tsize      = ").append(this.tsize).append(NL);
            stringBuffer.append("dsize      = ").append(this.dsize).append(NL);
            stringBuffer.append("bsize      = ").append(this.bsize).append(NL);
            stringBuffer.append("entry      = ").append(this.entry).append(NL);
            stringBuffer.append("text_start = ").append(this.text_start).append(NL);
            stringBuffer.append("data_start = ").append(this.data_start).append(NL);
            stringBuffer.append("o_toc      = ").append(this.o_toc).append(NL);
            stringBuffer.append("o_snentry  = ").append(this.o_snentry).append(NL);
            stringBuffer.append("o_sntext   = ").append(this.o_sntext).append(NL);
            stringBuffer.append("o_sndata   = ").append(this.o_sndata).append(NL);
            stringBuffer.append("o_sntoc    = ").append(this.o_sntoc).append(NL);
            stringBuffer.append("o_snloader = ").append(this.o_snloader).append(NL);
            stringBuffer.append("o_snbss    = ").append(this.o_snbss).append(NL);
            stringBuffer.append("o_algntext = ").append(this.o_algntext).append(NL);
            stringBuffer.append("o_algndata = ").append(this.o_algndata).append(NL);
            stringBuffer.append("o_modtype  = ").append(this.o_modtype).append(NL);
            stringBuffer.append("o_cpuflag  = ").append(this.o_cpuflag).append(NL);
            stringBuffer.append("o_cputype  = ").append(this.o_cputype).append(NL);
            stringBuffer.append("o_maxstack = ").append(this.o_maxstack).append(NL);
            stringBuffer.append("o_maxdata  = ").append(this.o_maxdata).append(NL);
            stringBuffer.append("o_debugger = ").append(this.o_debugger).append(NL);
            return stringBuffer.toString();
        }
    }

    public static class SectionHeader {
        public static final int SCNHSZ = 40;
        public static final String _TEXT = ".text";
        public static final String _DATA = ".data";
        public static final String _BSS = ".bss";
        public static final String _PAD = ".pad";
        public static final String _LOADER = ".loader";
        public static final String _DEBUG = ".debug";
        public static final String _TYPCHK = ".typchk";
        public static final String _EXCEPT = ".except";
        public static final String _OVRFLO = ".ovrflo";
        public static final String _INFO = ".info";
        public static final int STYP_PAD = 8;
        public static final int STYP_TEXT = 32;
        public static final int STYP_DATA = 64;
        public static final int STYP_BSS = 128;
        public static final int STYP_EXCEPT = 128;
        public static final int STYP_INFO = 512;
        public static final int STYP_LOADER = 4096;
        public static final int STYP_DEBUG = 8192;
        public static final int STYP_TYPCHK = 16384;
        public static final int STYP_OVRFLO = 32768;
        public byte[] s_name = new byte[8];
        public int s_paddr;
        public int s_vaddr;
        public int s_size;
        public int s_scnptr;
        public int s_relptr;
        public int s_lnnoptr;
        public short s_nreloc;
        public short s_nlnno;
        public int s_flags;
        RandomAccessFile sfile;

        public SectionHeader(RandomAccessFile randomAccessFile, long l) throws IOException {
            this.sfile = randomAccessFile;
            randomAccessFile.seek(l);
            byte[] byArray = new byte[40];
            randomAccessFile.readFully(byArray);
            ReadMemoryAccess readMemoryAccess = new ReadMemoryAccess(byArray, false);
            readMemoryAccess.getBytes(this.s_name);
            this.s_paddr = readMemoryAccess.getInt();
            this.s_vaddr = readMemoryAccess.getInt();
            this.s_size = readMemoryAccess.getInt();
            this.s_scnptr = readMemoryAccess.getInt();
            this.s_relptr = readMemoryAccess.getInt();
            this.s_lnnoptr = readMemoryAccess.getInt();
            this.s_nreloc = readMemoryAccess.getShort();
            this.s_nlnno = readMemoryAccess.getShort();
            this.s_flags = readMemoryAccess.getInt();
        }

        public byte[] getRawData() throws IOException {
            byte[] byArray = new byte[this.s_size];
            this.sfile.seek(this.s_scnptr);
            this.sfile.readFully(byArray);
            return byArray;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SECTION HEADER VALUES").append(NL);
            stringBuffer.append(new String(this.s_name)).append(NL);
            stringBuffer.append("s_paddr = ").append(this.s_paddr).append(NL);
            stringBuffer.append("s_vaddr = ").append(this.s_vaddr).append(NL);
            stringBuffer.append("s_size = ").append(this.s_size).append(NL);
            stringBuffer.append("s_scnptr = ").append(this.s_scnptr).append(NL);
            stringBuffer.append("s_relptr = ").append(this.s_relptr).append(NL);
            stringBuffer.append("s_lnnoptr = ").append(this.s_lnnoptr).append(NL);
            stringBuffer.append("s_nreloc = ").append(this.s_nreloc).append(NL);
            stringBuffer.append("s_nlnno = ").append(this.s_nlnno).append(NL);
            stringBuffer.append("s_flags = ").append(this.s_flags).append(NL);
            return stringBuffer.toString();
        }
    }

    public class Symbol {
        public static final int SYMSZ = 18;
        public static final int SYMNMLEN = 8;
        public static final int N_DEBUG = -2;
        public static final int N_ABS = -1;
        public static final int N_UNDEF = 0;
        public static final int C_BCOMM = 135;
        public static final int C_BINCL = 108;
        public static final int C_BLOCK = 100;
        public static final int C_BSTAT = 143;
        public static final int C_DECL = 140;
        public static final int C_ECOML = 136;
        public static final int C_ECOMM = 127;
        public static final int C_EINCL = 109;
        public static final int C_ENTRY = 141;
        public static final int C_ESTAT = 144;
        public static final int C_EXT = 2;
        public static final int C_FCN = 101;
        public static final int C_FILE = 103;
        public static final int C_FUN = 142;
        public static final int C_GSYM = 128;
        public static final int C_HIDEXT = 107;
        public static final int C_INFO = 100;
        public static final int C_LSYM = 129;
        public static final int C_NULL = 0;
        public static final int C_PSYM = 130;
        public static final int C_RPSYM = 132;
        public static final int C_RSYM = 131;
        public static final int C_STAT = 3;
        public static final int C_STSYM = 133;
        public static final int C_TCSYM = 134;
        public static final int C_WEAKEXT = 111;
        public static final int XMC_PR = 0;
        public static final int XMC_RO = 1;
        public static final int XMC_DB = 2;
        public static final int XMC_TC = 3;
        public static final int XMC_UA = 4;
        public static final int XMC_RW = 5;
        public static final int XMC_GL = 6;
        public static final int XMC_XO = 7;
        public static final int XMC_SV = 8;
        public static final int XMC_BS = 9;
        public static final int XMC_DS = 10;
        public static final int XMC_UC = 11;
        public static final int XMC_TI = 12;
        public static final int XMC_TB = 13;
        public static final int XMC_TC0 = 15;
        public static final int XMC_TD = 16;
        public static final int XMC_SV64 = 17;
        public static final int XMC_SV3264 = 18;
        public byte[] _n_name = new byte[8];
        public int n_value;
        public short n_scnum;
        public short n_type;
        public byte n_sclass;
        public byte n_numaux;
        private byte[] aux;
        public byte x_smclas;

        public Symbol(RandomAccessFile randomAccessFile) throws IOException {
            this(randomAccessFile, randomAccessFile.getFilePointer());
        }

        public Symbol(RandomAccessFile randomAccessFile, long l) throws IOException {
            randomAccessFile.seek(l);
            byte[] byArray = new byte[18];
            randomAccessFile.readFully(byArray);
            ReadMemoryAccess readMemoryAccess = new ReadMemoryAccess(byArray, false);
            readMemoryAccess.getBytes(this._n_name);
            this.n_value = readMemoryAccess.getInt();
            this.n_scnum = readMemoryAccess.getShort();
            this.n_type = readMemoryAccess.getShort();
            this.n_sclass = readMemoryAccess.getByte();
            this.n_numaux = readMemoryAccess.getByte();
            this.aux = new byte[this.n_numaux * 18];
            randomAccessFile.readFully(this.aux);
            this.x_smclas = this.n_numaux > 0 ? this.aux[this.aux.length - 7] : (byte)0;
        }

        private boolean isLongName() {
            return this._n_name[0] == 0 && this._n_name[1] == 0 && this._n_name[2] == 0 && this._n_name[3] == 0;
        }

        private String getShortName() {
            int n = 0;
            while (n < this._n_name.length) {
                if (this._n_name[n] == 0) {
                    return new String(this._n_name, 0, n);
                }
                ++n;
            }
            return "";
        }

        public String getName(byte[] byArray) {
            if (byArray.length > 0 && this.isLongName()) {
                ReadMemoryAccess readMemoryAccess = new ReadMemoryAccess(this._n_name, false);
                readMemoryAccess.getInt();
                int n = readMemoryAccess.getInt() - 4;
                if (n >= 0) {
                    int n2 = n;
                    while (n2 < byArray.length) {
                        if (byArray[n2] == 0) {
                            return new String(byArray, n, n2 - n);
                        }
                        ++n2;
                    }
                }
            }
            return this.getShortName();
        }

        public boolean isFunction() {
            return (this.n_sclass == 2 || this.n_sclass == 107 || this.n_sclass == 111) && this.n_scnum == XCoff32.this.opthdr.o_sntext && !this.getShortName().equals(".text");
        }

        public boolean isVariable() {
            return !(this.n_sclass != 2 && this.n_sclass != 107 && this.n_sclass != 111 || this.n_scnum != XCoff32.this.opthdr.o_snbss && this.n_scnum != XCoff32.this.opthdr.o_sndata || this.x_smclas == 15 || this.x_smclas == 3 || this.x_smclas == 10 || this.getShortName().equals(".bss") || this.getShortName().equals(".data"));
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SYMBOL TABLE ENTRY").append(NL);
            stringBuffer.append("n_value = ").append(this.n_value).append(NL);
            stringBuffer.append("n_scnum = ").append(this.n_scnum).append(NL);
            stringBuffer.append("n_type = ").append(this.n_type).append(NL);
            stringBuffer.append("n_sclass = ").append(this.n_sclass).append(NL);
            stringBuffer.append("n_numaux = ").append(this.n_numaux).append(NL);
            return stringBuffer.toString();
        }
    }

    public static class Attribute {
        public static final int XCOFF_TYPE_EXE = 1;
        public static final int XCOFF_TYPE_SHLIB = 2;
        public static final int XCOFF_TYPE_OBJ = 3;
        public static final int XCOFF_TYPE_CORE = 4;
        String cpu;
        int type;
        boolean bDebug;
        boolean isle;

        public String getCPU() {
            return this.cpu;
        }

        public int getType() {
            return this.type;
        }

        public boolean hasDebug() {
            return this.bDebug;
        }

        public boolean isLittleEndian() {
            return this.isle;
        }
    }
}

