/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.xcoff.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.CygPath;
import org.eclipse.cdt.utils.Symbol;
import org.eclipse.cdt.utils.xcoff.AR;
import org.eclipse.cdt.utils.xcoff.XCoff32;
import org.eclipse.cdt.utils.xcoff.parser.XCOFFBinaryObject;
import org.eclipse.core.runtime.IPath;

public class ARMember
extends XCOFFBinaryObject {
    private AR.MemberHeader header;

    public ARMember(IBinaryParser iBinaryParser, IPath iPath, AR.MemberHeader memberHeader) {
        super(iBinaryParser, iPath);
        this.header = memberHeader;
    }

    public InputStream getContents() {
        InputStream inputStream = null;
        if (this.path != null && this.header != null) {
            try {
                inputStream = new ByteArrayInputStream(this.header.getObjectData());
            }
            catch (IOException iOException) {}
        }
        if (inputStream == null) {
            inputStream = super.getContents();
        }
        return inputStream;
    }

    public String getName() {
        if (this.header != null) {
            return this.header.getObjectName();
        }
        return "";
    }

    protected void addSymbols(XCoff32.Symbol[] symbolArray, byte[] byArray, Addr2line addr2line, CPPFilt cPPFilt, CygPath cygPath, List list) {
        int n = 0;
        while (n < symbolArray.length) {
            String string;
            if ((symbolArray[n].isFunction() || symbolArray[n].isVariable()) && (string = symbolArray[n].getName(byArray)) != null && string.trim().length() != 0) {
                Symbol symbol = new Symbol(this);
                symbol.type = symbolArray[n].isFunction() ? 1 : 2;
                symbol.addr = symbolArray[n].n_value;
                symbol.name = string;
                if (cPPFilt != null) {
                    try {
                        symbol.name = cPPFilt.getFunction(symbol.name);
                    }
                    catch (IOException iOException) {
                        cPPFilt = null;
                    }
                }
                list.add(symbol);
            }
            ++n;
        }
    }

    protected XCoff32 getXCoff32() throws IOException {
        if (this.header != null) {
            return this.header.getXCoff();
        }
        throw new IOException(CCorePlugin.getResourceString("Util.exception.noFileAssociation"));
    }
}

