/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.xcoff.parser;

import java.io.EOFException;
import java.io.IOException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.ToolsProvider;
import org.eclipse.cdt.utils.xcoff.AR;
import org.eclipse.cdt.utils.xcoff.XCoff32;
import org.eclipse.cdt.utils.xcoff.parser.BinaryArchive;
import org.eclipse.cdt.utils.xcoff.parser.XCOFFBinaryObject;
import org.eclipse.core.runtime.IPath;

public class XCOFF32Parser
extends ToolsProvider
implements IBinaryParser {
    public IBinaryParser.IBinaryFile getBinary(byte[] byArray, IPath iPath) throws IOException {
        if (iPath == null) {
            throw new IOException(CCorePlugin.getResourceString("Util.exception.nullPath"));
        }
        IBinaryParser.IBinaryFile iBinaryFile = null;
        if (this.isBinary(byArray, iPath)) {
            try {
                XCoff32.Attribute attribute = null;
                if (byArray != null && byArray.length > 0) {
                    try {
                        attribute = XCoff32.getAttributes(byArray);
                    }
                    catch (EOFException eOFException) {}
                }
                if (attribute == null) {
                    attribute = XCoff32.getAttributes(iPath.toOSString());
                }
                if (attribute != null) {
                    switch (attribute.getType()) {
                        case 1: {
                            iBinaryFile = this.createBinaryExecutable(iPath);
                            break;
                        }
                        case 2: {
                            iBinaryFile = this.createBinaryShared(iPath);
                            break;
                        }
                        case 3: {
                            iBinaryFile = this.createBinaryObject(iPath);
                            break;
                        }
                        case 4: {
                            iBinaryFile = this.createBinaryCore(iPath);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                iBinaryFile = this.createBinaryArchive(iPath);
            }
        }
        return iBinaryFile;
    }

    public IBinaryParser.IBinaryFile getBinary(IPath iPath) throws IOException {
        return this.getBinary(null, iPath);
    }

    public String getFormat() {
        return "XCOFF32";
    }

    public boolean isBinary(byte[] byArray, IPath iPath) {
        return XCoff32.isXCOFF32Header(byArray) || AR.isARHeader(byArray);
    }

    public int getHintBufferSize() {
        return 512;
    }

    private IBinaryParser.IBinaryFile createBinaryExecutable(IPath iPath) {
        return new XCOFFBinaryObject(this, iPath){

            public int getType() {
                return 2;
            }
        };
    }

    private IBinaryParser.IBinaryFile createBinaryShared(IPath iPath) {
        return new XCOFFBinaryObject(this, iPath){

            public int getType() {
                return 4;
            }
        };
    }

    private IBinaryParser.IBinaryFile createBinaryObject(IPath iPath) {
        return new XCOFFBinaryObject(this, iPath);
    }

    private IBinaryParser.IBinaryFile createBinaryCore(IPath iPath) {
        return new XCOFFBinaryObject(this, iPath){

            public int getType() {
                return 16;
            }
        };
    }

    private IBinaryParser.IBinaryFile createBinaryArchive(IPath iPath) throws IOException {
        return new BinaryArchive(this, iPath);
    }
}

