/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmos4dev;

import com.palmsource.eclipse.palmoscore.Messages;
import com.palmsource.eclipse.palmoscore.sdk.ISDKContributor;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PalmOS4Plugin
extends AbstractUIPlugin {
    private static PalmOS4Plugin plugin;
    private ResourceBundle resourceBundle;
    public static final String PLUGIN_ID = "com.palmsource.eclipse.palmos4dev";
    private static final String SDK_ID = "com.palmsource.eclipse.sdk.palmos5";
    private static final String SDK_CONTRIBUTION_POINT = "sdkContributions";
    private static final String SDK_CONTRIBUTION_ID = "id";
    private static final String SDK_CONTRIBUTION_CLASS = "class";

    public PalmOS4Plugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("com.palmsource.eclipse.palmos4dev.PalmOS4PluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static PalmOS4Plugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String string) {
        ResourceBundle resourceBundle = PalmOS4Plugin.getDefault().getResourceBundle();
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static String getSDKId() {
        return SDK_ID;
    }

    public ISDKContributor getSDKContributor() throws CoreException {
        ISDKContributor iSDKContributor = null;
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint("com.palmsource.eclipse.palmoscore", SDK_CONTRIBUTION_POINT);
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            IExtension iExtension = iExtensionArray[n];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                if (iConfigurationElement.getAttribute(SDK_CONTRIBUTION_ID).equals(SDK_ID)) {
                    iSDKContributor = (ISDKContributor)iConfigurationElement.createExecutableExtension(SDK_CONTRIBUTION_CLASS);
                }
                ++n2;
            }
            ++n;
        }
        if (iSDKContributor == null) {
            Status status = new Status(4, PLUGIN_ID, 0, Messages.getString((String)"Error.sdkNotFound"), null);
            throw new CoreException((IStatus)status);
        }
        return iSDKContributor;
    }
}

