/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.editor;

import java.util.ArrayList;
import org.eclipse.cdt.make.core.makefile.IBadDirective;
import org.eclipse.cdt.make.core.makefile.ICommand;
import org.eclipse.cdt.make.core.makefile.IComment;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.core.makefile.IEmptyLine;
import org.eclipse.cdt.make.core.makefile.IInferenceRule;
import org.eclipse.cdt.make.core.makefile.IMacroDefinition;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.core.makefile.IParent;
import org.eclipse.cdt.make.core.makefile.IRule;
import org.eclipse.cdt.make.core.makefile.ITargetRule;
import org.eclipse.cdt.make.core.makefile.gnu.IInclude;
import org.eclipse.cdt.make.core.makefile.gnu.ITerminal;
import org.eclipse.cdt.make.internal.core.makefile.NullMakefile;
import org.eclipse.cdt.make.internal.ui.MakeUIImages;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.editor.AddBuildTargetAction;
import org.eclipse.cdt.make.internal.ui.editor.LexicalSortingAction;
import org.eclipse.cdt.make.internal.ui.editor.MakefileEditor;
import org.eclipse.cdt.make.ui.IWorkingCopyManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class MakefileContentOutlinePage
extends ContentOutlinePage
implements IContentOutlinePage {
    protected MakefileEditor fEditor;
    protected Object fInput;
    protected AddBuildTargetAction fAddBuildTargetAction;

    public MakefileContentOutlinePage(MakefileEditor makefileEditor) {
        this.fEditor = makefileEditor;
        this.fAddBuildTargetAction = new AddBuildTargetAction(this);
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        TreeViewer treeViewer = this.getTreeViewer();
        treeViewer.setContentProvider((IContentProvider)new MakefileContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new MakefileLabelProvider());
        if (this.fInput != null) {
            treeViewer.setInput(this.fInput);
        }
        MenuManager menuManager = new MenuManager("#MakefileOutlinerContext");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                MakefileContentOutlinePage.this.contextMenuAboutToShow(iMenuManager);
            }
        });
        Control control = treeViewer.getControl();
        Menu menu = menuManager.createContextMenu(control);
        control.setMenu(menu);
        IPageSite iPageSite = this.getSite();
        iPageSite.registerContextMenu(String.valueOf(MakeUIPlugin.getPluginId()) + ".outline", menuManager, (ISelectionProvider)treeViewer);
        iPageSite.setSelectionProvider((ISelectionProvider)treeViewer);
    }

    protected void contextMenuAboutToShow(IMenuManager iMenuManager) {
        if (this.fAddBuildTargetAction.canActionBeAdded(this.getSelection())) {
            iMenuManager.add((IAction)this.fAddBuildTargetAction);
        }
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.add((IContributionItem)new Separator("additions-end"));
    }

    public void setInput(Object object) {
        this.fInput = object;
        this.update();
    }

    public Object getInput() {
        return this.fInput;
    }

    public void update() {
        Control control;
        final TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null && (control = treeViewer.getControl()) != null && !control.isDisposed()) {
            control.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!control.isDisposed()) {
                        control.setRedraw(false);
                        treeViewer.setInput(MakefileContentOutlinePage.this.fInput);
                        treeViewer.expandAll();
                        control.setRedraw(true);
                    }
                }
            });
        }
    }

    public void setActionBars(IActionBars iActionBars) {
        super.setActionBars(iActionBars);
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        LexicalSortingAction lexicalSortingAction = new LexicalSortingAction(this.getTreeViewer());
        iToolBarManager.add((IAction)lexicalSortingAction);
    }

    private class MakefileContentProvider
    implements ITreeContentProvider {
        protected boolean showMacroDefinition = true;
        protected boolean showTargetRule = true;
        protected boolean showInferenceRule = true;
        protected boolean showIncludeChildren = false;
        protected IMakefile makefile;
        protected IMakefile nullMakefile = new NullMakefile();

        MakefileContentProvider() {
        }

        public Object[] getChildren(Object object) {
            if (object == MakefileContentOutlinePage.this.fInput) {
                return this.getElements(this.makefile);
            }
            if (object instanceof IDirective) {
                return this.getElements(object);
            }
            return new Object[0];
        }

        public Object getParent(Object object) {
            if (object instanceof IMakefile) {
                return MakefileContentOutlinePage.this.fInput;
            }
            if (object instanceof IDirective) {
                return ((IDirective)object).getParent();
            }
            return MakefileContentOutlinePage.this.fInput;
        }

        public boolean hasChildren(Object object) {
            if (object == MakefileContentOutlinePage.this.fInput) {
                return true;
            }
            if (object instanceof IParent) {
                return !(object instanceof IInclude) || this.showIncludeChildren;
            }
            return false;
        }

        public Object[] getElements(Object object) {
            Object[] objectArray = object == MakefileContentOutlinePage.this.fInput ? this.makefile.getDirectives() : (object instanceof IRule ? ((IRule)object).getCommands() : (object instanceof IParent ? (object instanceof IInclude && !this.showIncludeChildren ? new IDirective[]{} : ((IParent)object).getDirectives()) : new IDirective[]{}));
            ArrayList<IDirective> arrayList = new ArrayList<IDirective>(objectArray.length);
            int n = 0;
            while (n < objectArray.length) {
                if (this.showMacroDefinition && objectArray[n] instanceof IMacroDefinition) {
                    arrayList.add(objectArray[n]);
                } else if (this.showInferenceRule && objectArray[n] instanceof IInferenceRule) {
                    arrayList.add(objectArray[n]);
                } else if (this.showTargetRule && objectArray[n] instanceof ITargetRule) {
                    arrayList.add(objectArray[n]);
                } else {
                    boolean bl;
                    boolean bl2 = bl = objectArray[n] instanceof IComment || objectArray[n] instanceof IEmptyLine || objectArray[n] instanceof ITerminal;
                    if (!bl) {
                        arrayList.add(objectArray[n]);
                    }
                }
                ++n;
            }
            return arrayList.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            if (object != null) {
                this.makefile = this.nullMakefile;
            }
            if (object2 != null) {
                IWorkingCopyManager iWorkingCopyManager = MakeUIPlugin.getDefault().getWorkingCopyManager();
                this.makefile = iWorkingCopyManager.getWorkingCopy((IEditorInput)object2);
                if (this.makefile == null) {
                    this.makefile = this.nullMakefile;
                }
            }
        }
    }

    private class MakefileLabelProvider
    extends LabelProvider
    implements ILabelProvider {
        MakefileLabelProvider() {
        }

        public Image getImage(Object object) {
            if (object instanceof ITargetRule) {
                return MakeUIImages.getImage(MakeUIImages.IMG_OBJS_MAKEFILE_TARGET_RULE);
            }
            if (object instanceof IInferenceRule) {
                return MakeUIImages.getImage(MakeUIImages.IMG_OBJS_MAKEFILE_INFERENCE_RULE);
            }
            if (object instanceof IMacroDefinition) {
                return MakeUIImages.getImage(MakeUIImages.IMG_OBJS_MAKEFILE_MACRO);
            }
            if (object instanceof ICommand) {
                return MakeUIImages.getImage(MakeUIImages.IMG_OBJS_MAKEFILE_COMMAND);
            }
            if (object instanceof IInclude) {
                return MakeUIImages.getImage(MakeUIImages.IMG_OBJS_MAKEFILE_INCLUDE);
            }
            if (object instanceof IBadDirective) {
                return MakeUIImages.getImage(MakeUIImages.IMG_OBJS_ERROR);
            }
            if (object instanceof IParent) {
                return MakeUIImages.getImage(MakeUIImages.IMG_OBJS_MAKEFILE_RELATION);
            }
            return super.getImage(object);
        }

        public String getText(Object object) {
            String string = object instanceof IRule ? ((IRule)object).getTarget().toString().trim() : (object instanceof IMacroDefinition ? ((IMacroDefinition)object).getName().trim() : super.getText(object));
            if (string != null && (string = string.trim()).length() > 25) {
                string = String.valueOf(string.substring(0, 25)) + " ...";
            }
            return string;
        }
    }
}

